+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-03-12T11:38:00-04:00"
lastmod = "2018-03-13T08:25:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520890383702/BlytheQuickly.jpg.jpg"
primary_image_credit = "Stephanie Blythe as Mistress Quickly in Falstaff, The Metropolitan Opera, 2013. Photo: Ken Howard/Metropolitan Opera."
publishDate = "2018-03-12T22:36:00-04:00"
related_articles = ["articles/a-bel-canto-winner-atlantas-fille-du-rgiment.md","articles/talking-with-singers-sir-john-tomlinson.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/the-atlanta-opera.md"]
related_people = ["scene/people/stephanie-blythe.md"]
short_description = "Blythe approaches her recital work with a refreshingly casual air, as though she doesn&#039;t confuse her passion with taking it all too seriously. She has even graced the recital stage with her ukulele in hand, a more recent passion-project of hers. &quot;I just did a recital in New York; here we are in Merkin Hall, singing &#039;Don&#039;t Fence Me In&#039; and I was accompanying on ukulele.&quot;"
slug = "talking-with-singers-stephanie-blythe"
title = "Talking with singers: Stephanie Blythe"
+++

"Very early on, I decided I would really be adventurous in my choices of repertoire," says American mezzo-soprano Stephanie Blythe. Her enviable singing career began with a high-profile professional debut in *Parsifal* at the Metropolitan Opera in 1995; since then she has made the conscious decision to "switch it up," scheduling her contracts so that Handel led into Verdi, concert work leading into fully staged opera. "I'm always changing it up."

Blythe recently finished a run of [*La fille du régiment* at The Atlanta Opera](/a-bel-canto-winner-atlantas-fille-du-régiment/), where she sang the Marquise de Berkenfield. The Marquise is a bit of musical and dramatic sorbet amid the heavy roles that fill her schedule - Fricka (*Das Rheingold* and *Die Walküre*), Ulrica (*Un ballo in maschera*), Azucena (*Il trovatore*), Baba the Turk (*The Rake's Progress*) and Dalila (*Samson et Dalila*).

"Everyone will say this: Comedy is all about timing," Blythe says of the part-funny, part-tragic Marquise. "Even when you're singing big coloratura passages its all about beats and arrival." 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520867140483/JB4A0507.jpg.jpg)
<figcaption>Stephanie Blythe (Marquise of Berkenfield) in *La fille du régiment*, The Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera.</figcaption>
</figure>

Finding where the jokes should land is no doubt some levity for Blythe; but Donizetti's opera also has a function in her grand plan for variety. "Lately I've been moving back to Early Music and bel canto, and I'm really happy with it," she says. Operas like *La fille du régiment* demand an instrument that's in shape, and Blythe finds the style demanding in just the right way. "You have to keep your technique reasonably healthy to do it," she says.

Of course, with each return to any role or style, Blythe pays new attention to how her voice takes to it. "I have a very different voice now than when I was younger," she says, though she can still trust her instrument to tell her what roles will suit her well.

That kind of awareness is a trusty tool for any singer, and in particular Blythe, who says, "What I'm looking forward to most is the next new opera." New work has been an important part in Blythe's career, including her notable portrayal of Gertrude Stein in *27*, the opera by Ricky Ian Gordon and Royce Vavrek.

*27* is one of the "revelatory" stories being told in contemporary opera, about people with whom audiences connect easily, but which still present a surprise or challenge. "The thing that was so great about *27* was that it didn't sugar-coat the woman," says Blythe. "It was very honest about who she was. This was a kaleidoscope of a human being, and not all the pictures were pretty."

Even more than contemporary opera is Blythe's passion and industriousness with new song repertoire. Freshly written music is something she loves to sing, and she considers the 21st century so far to be "a golden age of composition."

"There is so much good music being written right now," says Blythe, excited to see such a change from the 20th-century output of North American music. Upon hearing of the recent death of American composer Richard Hundley, Blythe found [his entry on SongOfAmerica.net](http://www.songofamerica.net/composer/hundley-richard), and learned that in 1987 the Carnegie Hall International American Music Competition designated Richard Hundley as one of just twelve standard American composers for singers.

"I read that and thought, *twelve?*"

In that meager group were the likes of George Crumb and John Duke, and it's certainly true that "there weren't a lot of them. And look at where we are now!"

Each summer, Blythe runs the [Fall Island Vocal Arts Seminar](http://www.fallisland.org/) in Potsdam, NY, where she and the participants focus strictly on American song by living composers. "I'm continually shocked," she says of the great music she hears. "Every summer it's a revelation."

Blythe sees an interesting difference in today's "golden age" of vocal composition, that it's the song composers who are also writing operas. "If you go back in history, you don't find that," she muses. "They're finding a different relationship to the voice than other composers have done."

She adds, "That's a great doctoral thesis!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520870078424/resized---SB2-Stephanie-Blythe.jpg.jpg)
<figcaption>Stephanie Blythe, a self-portrait by Stephanie Blythe.</figcaption>
</figure>

Perhaps it's a chicken-or-the-egg situation, but composers are writing in a more friendly way for the voice at the same time as contemporary music has lost its negative connotations. 

"Contemporary music has a very different slant to it now," Blythe says. "Even ten years ago, people would say, 'Oh, I don't sing squeak-fart music.'"

The music sounds different, but perhaps a larger factor is the symbiotic relationship between composer and singer. Blythe likes a dialogue as part of her new-work process - it only enhances her excitement to share the music with her audiences. She has on deck new song cycles by Juliana Hall and Evan Mack. "I can't wait to have the opportunity to sing these things in public."

Blythe approaches her recital work with a refreshingly casual air, as though she doesn't confuse her passion with taking it all too seriously. She has even graced the recital stage with her ukulele in hand, a more recent passion-project of hers. "I just did a recital in New York; here we are in Merkin Hall, singing 'Don't Fence Me In' and I was accompanying on ukulele."

She taught herself to play two years ago, and her curiosity has quickly grown into an obsession. "I own twn ukuleles now," she laughs. She bought one for her nephew and one for her sister, investments that pay off in sheer happiness. 

"When the three of us sat around playing a C-chord together, I'm telling you, it is heaven. If I'm ever feeling stressed out, I pick up my ukulele, I play a few tunes, and I feel better immediately."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520890899828/Hi-res.jpg.jpg)
<figcaption>Photo: Stephanie Blythe.</figcaption>
</figure>

So, when she brings to high profile stages like Carnegie Hall a mix of her decades-long, internationally acclaimed voice, and her from-the-heart ukulele strumming, Blythe seems to have found the real point of it all.

"I'll get the audience to sing along with me," she says. "That's sort of my goal, is to get America singing."
