+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-11-16T19:45:00+00:00"
lastmod = "2016-11-24T09:44:00+00:00"
postamble = "Manon Lescaut plays at the Royal Opera House until December 12. For details and ticket information, [click here.](http://www.roh.org.uk/productions/manon-lescaut-by-jonathan-kent)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479929155754/2016-11-23---Radvanovsky-Eccles.jpg.jpg"
primary_image_credit = "Photo by Andrew Eccles."
publishDate = "2016-11-24T09:23:00+00:00"
related_articles = ["articles/talking-with-singers-jamie-barton.md", "articles/talking-with-singers-christine-goerke.md", "articles/whos-afraid-of-the-aging-singer.md", "articles/dont-miss-radvanovsky-in-recital-at-cadogan-hall.md", "articles/talking-with-singers-ailyn-perez.md", "articles/talking-with-singers-angela-meade.md", "articles/spotlight-on-jennifer-davis.md", "articles/reason-947-we-dont-envy-singers-singing-on-camera.md", "articles/talking-with-singers-siobhan-stagg.md"]
related_companies = ["scene/companies/royal-opera-house.md", "scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/sondra-radvanovsky.md"]
short_description = "&quot;It took me twenty years to get here,&quot; says Radvanovsky of the long game that is the opera singer&#039;s career. &quot;Twenty years of cracking on high notes at the Metropolitan Opera, and saying, &#039;This didn&#039;t work tonight, let&#039;s try it another way!&#039;&quot; And the work is still not over."
slug = "talking-with-singers-sondra-radvanovsky"
title = "Talking with singers: Sondra Radvanovsky"

+++
"If anybody could do it, everyone would be doing it," says star soprano [Sondra Radvanovsky](/scene/people/sondra-radvanovsky/) of the kind of singing that sets her apart as one of the top opera divas of today. Hers are definitive performances of Bellini's [Norma](/review-sondra-slays-in-bellini-masterwork/), Verdi's Leonora (_Il trovatore_), and Donizetti's Three Queens (_Maria Stuarda_, _Anna Bolena_, and Queen Elizabeth I in _Roberto Devereux_); until December 12, Radvanovsky is at the [Royal Opera House](/scene/companies/royal-opera-house/), singing the title role in Puccini's [_Manon Lescaut_](http://www.roh.org.uk/productions/manon-lescaut-by-jonathan-kent), conducted by Antonio Pappano and directed by Jonathan Kent.

A role like Norma is no simple sing, yet Puccini's orchestration demands a certain kind of technical care and attention. "That Puccini orchestra is big," says Radvanovsky, noting that unlike much of the _bel canto_ repertoire, Puccini's orchestration often doubles the vocal line. "They're wailing away right with you. You have to find that breath support and that line." Anyone who has heard Radvanovsky sing live has no doubts of the sheer power in her sound. Still, she is acutely aware of the difference between effort and efficiency. "You have to learn, 'Ok, this is as much as I can give,' and that only comes from experience, and trying it onstage."

> "I think that I'm singing the best that I've ever sung right now."

Radvanovsky spends her professional life embodying the extreme; so, where lies the balance between beauty of sound, and a performance which rises to the dramatic heights of the music? "It's still always a fight with me," she admits. Her training as an actress and a singer illuminated for her the different between acting and tension, which are "two separate things."

She puts it simply: "Tension's just tension. It's not emotion." Similarly, "tight is not intention." As an educator to younger singers, Radvanovsky sees how easy it is for an artist to fall into the trap of bearing down, of getting caught up in opera's enormous emotional scope; that trap can work against a singer, leaving them with fewer options, and "a throat that's closed and tense."

"The minute I start to _feel something_, I know I'm done," she explains. It's a conscious, practiced technique to sing roles like Tosca, Manon Lescaut, "and Norma, who's screaming her head off, and you have to just sit there, like you're reading the phone book." Radvanovsky has learned that if she, the performer, really experiences the sentiments of her characters, it means the audience cannot do the same along with her. Understanding the dramatic arc of her emotionally-charged roles is vital to her process ("That's what is so great about the rehearsal process, is learning how far you can push yourself."), yet the real trick is in stepping beyond that sympathetic state, into a delivery that feels almost removed.

It's an extraordinary amount of trust, for a performer to distance herself from a role - especially a role whose experiences ring true to the artist. Radvanovsky puts trust in her technique as a singer and actress, finding "that line in the sand" that allows her to move an audience and still sing healthily.

"I lost my father very early in my life. I found him dead when I was 16," says Radvanovsky, candidly. "There are certain arias, like 'D'amor, sull'ali rosee' in _Trovatore_, where I even think about it, and I have to step back." That character's experience is "too much" for Radvanovsky to connect with on a personal level, and it's a moment where "I have to read the phonebook, and tell myself, 'don't go there.'"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479928671538/2016-11-23---SONDRA-RADVANOVSKY-AS-MANON-LESCAUT%2C-ALEKSANDRS-ANTONENKO-AS-CHEVALIER-DES-GRIEUX-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg)
<figcaption>Sondra Radvanovsky as Manon Lescaut, ROH, 2016. Photo by Bill Cooper.</figcaption>
</figure>

## "That's where opera was going."

Alongside her training as a singer, Radvanovsky took just as seriously her training as an actress. She began voice lessons at 11 years of age, and when she began to look seriously at opera, she was confident that singing was inseparable from acting. Radvanovsky studied drama formally both at UCLA and privately, while continuing voice lessons. She recalls the straightforward choice: "If I'm going to be an opera singer, I want to learn how to move onstage." She was eager to learn everything she could about costuming, stage make-up, how to find her light, and what it meant to play roles from different historical periods.

> "Do I sing it for those 4200 people who paid a lot of money for those tickets, and actually came and showed up at the opera house, or do I minimize my movements, and think about my gestures for the millions of people who are going to watch it in the cinema and on DVD?"

"You had the opera stars of the 70s at the pinnacles of their careers, these younger singers coming up that were more mobile and more agile onstage, and acting was meaning more and more as television and cinema was really trying to infuse itself into opera," recalls Radvanovsky of her assessment of the operatic world as she prepared to enter it. "I really felt, as an opera singer, that's where opera was going."

Her enthusiasm for acting is no secondary passion. For "a brief second," Radvanovsky considered pursuing a career as an actress. Throughout her career, she has had tempting offers outside of the operatic world; famed stage director Francesca Zambello offered her a role in a Broadway musical, and film director William Friedkin (_The Exorcist_) still courts her acting abilities for the screen. While she humbly admits that she lacks a versatile actress's comedic skills ("I don't do funny! I like to suffer."), and that her singing voice doesn't quite lend itself to Broadway ("It's kind of asking a long distance runner if they would do a sprint!"), it's her real hunger for music that kept all of Radvanovsky's training focused towards the operatic stage.

"I can't not have music in my life."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479393237854/2016-11-16---Radvanovsky---Eccles---2.jpg.jpg)
<figcaption>Sondra Radvanovsky, soprano. Photo by Andrew Eccles.</figcaption>
</figure>

## "Thanks, Kim Kardashian."

Of course, in the world of being HD-ready, a singer like Radvanovsky is somewhat of a jackpot; her singing is true, and her skills as an actress are honed for audiences of any size. She, like many opera lovers, is conflicted about the role of video broadcasts and split audiences - those in the theatre, and those watching remotely - and how it affects the industry and its product. In the competitive arena of opera, singers who hone their skills in singing, foreign languages, movement, and acting, now must add "the look" to their long list of must-haves. ("Thanks, Kim Kardashian," jokes Radvanovsky.)

"Everything is about looks, and movement, and some days I fear that the voice comes second, as opposed to first," she says of the visual era that is the 21st century. "If people aren't satisfied visually, as well as aurally, they're going to go home and put on a recording. Or, nothing at all." Even for the singers who make it onto both the big stage and the big screen, new, contemporary questions about their artistic responsibilities arise.

Radvanovsky recalls her first performance in a HD broadcast at the Metropolitan Opera, as Leonora in _Il trovatore_. Over four thousand people were sat live in the theatre, and millions would watch in cinemas and through the Met's [On Demand](http://www.metopera.org/Season/On-Demand/) subscription service. "Do I sing it for those 4200 people who paid a lot of money for those tickets, and actually came and showed up at the opera house, or do I minimize my movements, and think about my gestures for the millions of people who are going to watch it in the cinema and on DVD?"

It was a "moral dilemma" for Radvanovsky, but the solution was inevitably clear. "I'm an opera singer, first and foremost," she says. "People need to see how hard we actually work." The "funny faces" and the sweat of vocal athleticism are part of the art form, and Radvanovsky believes that even if she doesn't adapt her stagecraft to suit the camera, cinema audiences will gladly accept the payoff, which is simple: "glorious sound and telling a story."

## "It took me twenty years to get here."

With today's visually-inclined opera scene also comes an obsession with youth. "Kids want to go out, they want to do it before they're ready," says Radvanovsky. "I understand, because there are less and less positions for young artists programmes."

As the industry grows more and more competitive, opera demands ever-rising standards for its young artists. Radvanovsky acknowledges that "it's tougher now" to eke out a living as an opera singer, and that there are fewer places to work, and less opportunities available than when she began her own career.

She is still a rarity among singers, having studied both singing and acting seriously, and concurrently. Young singers are realizing that "voice-first" doesn't necessarily mean "voice-only," yet Radvanovsky is still troubled by the apparent low priority that acting takes in many post-secondary music degrees. "I am confounded by it. I think they should be taught hand in hand."

> "I think it's my duty, in many ways, to nurture this gift. I feel it's what I was put on this earth to do."

"It took me twenty years to get here," says Radvanovsky of the long game that is the opera singer's career. "Twenty years of cracking on high notes at the Metropolitan Opera, and saying, 'This didn't work tonight, let's try it another way!'" And the work is still not over.

She points to her phone, wrapped in those ubiquitous earbuds, sitting atop the piano in her dressing room at the Royal Opera House. "I listen to my coach and my teacher when I warm up, just to reiterate, 'no, Sondra, that's not right.'"

Her support system of teachers and coaches is another set of tools that Radvanovsky has honed along the way; the responsibilities and trust that she has in her mentors have come from active participation in the learning process. "You have to listen to yourself, and you have to 100% trust what \[your teachers\] are doing," she says. "And if you don't, then you need a different teacher."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479928627433/2016-11-23---SONDRA-RADVANOVSKY-AS-MANON-LESCAUT-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg)
<figcaption>Sondra Radvanovsky as Manon Lescaut, ROH, 2016. Photo by Bill Cooper.</figcaption>
</figure>

## "I dread the day that I have to stop singing."

"I think some people never find out what their gift is in life. Even until the very end, some people search for it their whole life." Radvanovsky considers herself one of the "fortunate few" who found hers at an early age, and "I think it's my duty, in many ways, to nurture this gift. I feel it's what I was put on this earth to do." She smiles at the esoteric, "woo-woo" sentiment, but she is earnest about what singing means to her.

"I think that I have a story to tell, and I couldn't imagine a world without it." Along with the other great artists of today, Radvanovsky feels a responsibility to keep opera alive, and to keep it a true experience for the audience.

"I dread the day that I have to stop singing," she says, laughing. "I feel bad for my husband the day I have to stop singing." Radvanovsky will soon turn 48, and as her career progresses further, it's clear that she wants to stay honest - even brutally so - about what she can offer as a singer.

Humble and self-aware as she is, it's still refreshing to see that Radvanovsky knows the power she has onstage. "I think that I'm singing the best that I've ever sung right now."

Agreed.