+++
author = ["authors/hannah-de-priest.md"]
categories = "Interview"
date = "2018-12-10T20:29:00-05:00"
lastmod = "2018-12-10T20:29:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544491721633/sqSiobhan_StaggSimonPauly2018_13.jpg.jpg"
publishDate = "2018-12-10T20:29:00-05:00"
related_articles = ["articles/talking-with-singers-melody-moore.md","articles/talking-with-singers-sondra-radvanovsky.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md","scene/companies/deutsche-oper-berlin.md","scene/companies/royal-opera-house.md"]
related_people = ["scene/people/siobhan-stagg.md"]
short_description = "For the moment, Stagg is enjoying Chicago. Recent highlights include bundling up for a walk through Millennium Park, an outing to hear Verdi&#039;s Requiem with Riccardo Muti at the Chicago Symphony, and a trip to the city&#039;s famed Art Institute, where she especially enjoyed the collection of French impressionist paintings."
slug = "talking-with-singers-siobhan-stagg"
title = "Talking with singers: Siobhan Stagg"
+++

Australian soprano [Siobhan Stagg](/scene/people/siobhan-stagg/), currently starring in Lyric Opera of Chicago's [*Cendrillon*](/actual-magic-in-chicago-lyrics-cendrillon/), has been on a meteoric rise since 2013, the year she moved to Berlin to join the prestigious young artist program at Deutsche Oper Berlin. 

Raised in Midura, a small city in northern Victoria, Stagg now sings all over Europe — and, increasingly, the world — but she still makes her home in Berlin (a city she loves), where she is now a principal soloist with Deutsche Oper Berlin. Stagg says her deep relationship with the company has "allowed me to develop my roles and my craft in a place that is familiar and supportive."

Scrolling through Stagg's schedule, mentally adding in recent recording projects and accounting for travel, the volume and variety of work she packs into her seasons is astonishing. But then, Stagg is a notoriously quick-study — a skill she says she honed starting out in the choral and baroque worlds, where learning often - obscure music quickly is a professional necessity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544491638863/Siobhan_StaggSimonPauly2018_3.jpg.jpg)
<figcaption>Photo: Simon Pauly.</figcaption>
</figure>

Especially in 2015: Stagg did a string of high-profile "jump-ins" that she credits as kick-starting her career. The most extreme example was a Royal Opera House production of Luigi Rossi's *Orfeo* at Shakespeare's Globe Theater. Within a week of the scheduled opening, the soprano in the title role was too ill to sing. Stagg was contacted and asked if she could learn the part in five days. She said yes. Reflecting on that decision, Stagg said, "I don't think I would've been able to do it if I hadn't had that training in baroque music, both in terms of style and learning music so quickly." That successful jump-in ultimately led to her ROH mainstage company debut last season as Pamina in *Die Zauberflöte* — one of her signature roles.

In fact, her 2017-2018 season consisted "almost exclusively singing Pamina," whereas this season, she's “barely doing anything I've ever done before." That includes her current run as Lucette/Cendrillon at [Lyric Opera of Chicago](/actual-magic-in-chicago-lyrics-cendrillon/). More role debuts are swiftly coming: later this month she will sing her first Adele in the Rolando Villazón production of *Die Fledermaus* and in February, Micaëla in *Carmen*, both at Deutsche Oper Berlin. 

When asked about especially meaningful recent performances, Stagg was quick to mention another role and house debut earlier this season: Mélisande in Debussy's *Pelléas et Mélisande* at Victorian Opera (Melbourne). Not only was it thrilling to make her operatic debut in her home country, but taking on the role of Mélisande also heralded a turn toward plummier, lyric repertoire for Stagg. Like Mélisande, Cendrillon is a zwischen role, (a role that can be sung convincingly by sopranos or mezzos). Stagg is excited by these fuller roles, saying, "I feel these roles are more 'me' in terms of personality and vocalism… [than] the very high soprano roles [I sang] at the beginning of my career."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544491683634/SiobhanStagg_CENDRILLON_LyricOperaofChicago_LYR181128_215_c.jpg.jpg)
<figcaption>Siobhan Stagg as Cendrillon in *Cendrillon*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Stagg seems to be in a French state of mind of late. In addition to her recent debuts as Mélisande and Cendrillon, she’s been doing "heaps of French art song," including a recent recording project with the Berlin-based Noga Quartet, which features Stagg singing Debussy's achingly beautiful song cycle *Ariettes Oubliées* arranged for the quartet by its cellist, Joan Bachs. Yet more French repertoire is on the horizon, with Stagg set to perform both Ravel's *Sheherazade* and Poulenc's *Stabat Mater* with the West Australian Symphony Orchestra in March. (She is the ensemble's "Artist-in-Association" for 2019.)

For the moment, Stagg is enjoying Chicago. Recent highlights include bundling up for a walk through Millennium Park, an outing to hear Verdi's *Requiem* with Riccardo Muti at the Chicago Symphony, and a trip to the city's famed Art Institute, where she especially enjoyed the collection of French impressionist paintings.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544491648891/Siobhan_StaggSimonPauly2018_11.jpg.jpg)
<figcaption>Photo: Simon Pauly.</figcaption>
</figure>

Chicagoans can catch Siobhan Stagg when she returns in the new year to continue her run as the titular heroine in Massenet's *Cendrillon*, January 11, 17, and 20th. Those undaunted by freeway traffic might additionally consider a hop over state lines to St. Louis, Missouri, where Stagg will perform in Brahms' *Ein Deutsches Requiem* with the stellar St. Louis Symphony Orchestra in early March.
