+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-04-18T13:59:00-04:00"
lastmod = "2017-04-25T09:39:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492542568990/2017-04-19---Square---SASHA_COOKE_pc_Dario_Acosta.jpg.jpg"
primary_image_credit = "Photo by Dario Acosta."
publishDate = "2017-04-25T09:39:00-04:00"
related_articles = ["articles/spotlight-on-danielle-buonaiuto.md","articles/young-singers-in-santa-fe-adelaide-boedecker.md","articles/left-wanting-more-enos-marnie.md"]
related_companies = ["scene/companies/the-santa-fe-opera.md"]
related_people = ["scene/people/sasha-cooke.md"]
short_description = "Hers is a career that proves the value of working well with one&#039;s contemporaries, be they professional or academic. &quot;You don&#039;t realize when you&#039;re young that everyone around you will continue to be around you. Treat people well, be grateful.&quot; Cooke knows well that no musician is an island, and &quot;in a way, being a musician is a perfect heightened example of being human. We are all dependent on one another.&quot;"
slug = "talking-with-singers-sasha-cooke"
title = "Talking with singers: Sasha Cooke"
+++

"I can't imagine anyone who wouldn't be interested in it," says American mezzo-soprano [Sasha Cooke](/scene/people/sasha-cooke/) about the highly anticipated world premiere of [*The (R)evolution of Steve Jobs* at Santa Fe Opera](https://www.santafeopera.org/operas-and-ticketing/the-revolution-of-steve-jobs). She calls *Steve Jobs* a "family project" of sorts, a working environment where she knows well the opera's composer, Mason Bates, and most of the creative team, which includes her husband, baritone Kelly Markgraf. 

Cooke is set to sing Laurene Jobs, Steve's wife, arguably a couple from contemporary history who had a truly global kind of social impact. "I think one of the most moving aspects of the subject matter is that I don't know a person on the planet who isn't connected to Steve and Laurene Jobs. We are all connected by this device."

Both mothers, and passionate advocates of education and healthy eating, Cooke found it easy to discover common ground between herself and Laurene. "Laurene is an amazing part, it's a huge honour to portray her," she says. "She's someone I'd look up to anyway...she's many things that I aim to be." 

In the context of Bates' opera, Laurene Jobs is one of those strong women who, perhaps subtly, have great influence on strong men. "I think I relate to [Steve and Laurene] in a way, also because I'm married to someone who's very dynamic," says Cooke. "We're both managing a lot, and I think they too did that. Still, [they have] this very obvious, beautiful intimacy and devotion to each other."

The story of the relationship between Steve and Laurene is something that Cooke admires in the libretto by Mark Campbell (*Silent Night*, *The Shining*). "You feel as though it's *your* story happening on stage. He makes it very universal," she explains. "There's a poetic simplicity to his writing. It's immediately accessible, but you keep thinking about it when the show's over." It's a style that suits Bates' aesthetic for *The (R)evolution of Steve Jobs*, an opera which is "almost like a play. It's really not about a long high note, it's about clear text and clear communication."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492541179914/2017-04-18---Cooke-Atomic-ENO.jpg.jpg)<figcaption>Cooke in *Doctor Atomic*, English National Opera, 2009.</figcaption>
</figure>

## "I never would have imagined I would be somebody who does world premieres."

When we spoke with Cooke, she was in the middle of a busy stretch of concert work across the United States and Europe. The short-burst schedule of singing with the country's great orchestras demands a cool head, a nature that doesn't get frazzled by the revolving door of repertoire to prepare, nor by the frequent flights. "The travel gets taxing," agrees Cooke, who finds herself in up to four cities in a single month. "There is a lot of wear and tear on the body and mind. It just means flights, and baggage, and pulling things, especially when you add to that a baby!" 

Yet the perks are appealing, too. "One of the great benefits of concert work is that I get to go home after a week." Compared to the longer stretches of rehearsing fully staged operas, concert gigs allow Cooke more time with her children, and to herself. 

"I think with opera singers that do primarily opera, they hardly see their loved ones," she says, adding that the potential trade-off may be in the sheer quantity of music to keep neatly packed in her mind. "Sometimes I envy the singers that repeat *Barber of Seville* ten times," she laughs.

Cooke confesses that learning repertoire quickly - and learning it well - hasn't always come to her easily, yet you wouldn't guess it based on her packed calendar. She likens her constant workload to preparing Thanksgiving dinner: "you have to put a lot of dishes in the oven, and everything has a different cooking time, but there's one oven. You just think it through."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492541197288/2017-04-19---Cooke-Hansel-Seattle.jpg.jpg)<figcaption>Cooke (left) *Hänsel and Gretel*, Seattle Opera, 2016. Photo by Philip Newton.</figcaption>
</figure>

She often works with young singers, and the importance of preparation is a constant when she is asked for professional advice. "When you're not prepared, and then you add to that anxiety or nerves or a torn dress or rainy weather or you're late to the hall, it just compounds everything," she says. First impressions in the rehearsal room can be difficult to undo, and Cooke sees preparation as a way to "be a master of all the things you *can* master."

"It's really hard to figure out for young singers, because everyone has a different pace and everyone can handle a different amount," Cooke admits. Learning early on what that pace is sets a singer apart in the professional world, and proves to conductors that they're a smart and reliable hire.

Cooke has found herself a specialist of sorts in contemporary music, a trend that began when she was still studying. "I [sang new music] because my friend asked me to learn a piece, or because I loved the challenge of figuring out strange dissonances," she says. "It ended up becoming part of my career." 

"I never would have imagined I would be somebody who does world premieres." Cooke sang - and sings - more traditional, lyrical mezzo-soprano repertoire, but it seems a fateful decision to embrace the invitation to sing brand new works. "If I'd said no, I probably wouldn't be having this interview."

Hers is a career that proves the value of working well with one's contemporaries, be they professional or academic. "You don't realize when you're young that everyone around you will continue to be around you. Treat people well, be grateful." Cooke knows well that no musician is an island, and "in a way, being a musician is a perfect heightened example of being human. We are all dependent on one another."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492541188190/2017-04-19---Cooke-Magdalene-SFO.jpg.jpg)
<figcaption>Cooke in *The Gospel of Mary Magdalene* at San Francisco Opera, 2013. Photo by Cory Weaver.</figcaption>
</figure>

## "You have to be crazy about singing."

"The best advice I got, when I was 18, was from Matthew Epstein. He said for him, one of the defining characteristics of someone who will have a career is gut." Somewhat ironically, Cooke applies that bit of wisdom to how she receives professional feedback. "So often you're getting advice from a hundred people, and you can get lost. You have to have this moment with yourself to say, 'how do *I* feel about this?'"

The ambitious singer still struggles with her own high standards, and her eagerness to take on a varied workload. "I have to check in with my gut, and sometimes it will say 'this is too much,'" says Cooke. "You're also a human being, and a mom, and those things require energy too."

When it comes to sorting out advice and feedback, Cooke feels strongly that singers, even at a young age, must take responsibility for their professional choices. "You see those people who get lost, or they blame their teacher. *You* are part of that equation; if something wasn't working, you have to have the bravery to know and separate yourself from that circumstance."

At the same time, gut instincts shouldn't get in the way of trying new things. "I love singers, I'm one of them. But I often say, just say less, say 'yes maestro', try and be open-minded, and don't have every answer figured out." Cooke sees it as another of life's moments of moderation, where receiving advice is balanced by being willing to give.

Absolutely, it's another reason that it's tough to be a singer, and Cooke agrees. "If you don't get crazy, awesome, spiritual happiness from performing, it just isn't worth it," she says, "because it's hard. And it only gets harder."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492727361060/2017-04-19---Sasha-Cooke---Acosta.jpg.jpg)
<figcaption>Sasha Cooke, mezzo-soprano. Photo by Dario Acosta.</figcaption>
</figure>

Cooke credits much of her success to preparation and gratitude, the latter of which manifests itself particularly strongly in singers. "What you feel, both on and offstage, will be palpable to those around you. The more positivity and gratitude you can bring to your work, to your person, the more people will want to be around you, and the more they'll rehire you."

"There's nothing wrong with questioning things," she says of singing, and the natural inclination to pause and think about how the reality of the career compares with the hypothetical. Cooke calls it a "spiritual" process, perhaps heightened in recent months by the large and often frightening happenings around the globe. "It's a forum to make the world a better place," she says. "It's a way of healing people, bringing them together, and reminding them of their humanity."

"We should all be much more connected and considerate of one another. Art is meant to deepen our appreciation of life and each other. We need that now more than ever."
