+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-05-22T21:52:00-04:00"
lastmod = "2018-05-22T22:08:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527040256619/sqSamanthaPickett-DSC_3902.jpg.jpg"
primary_image_credit = "Samantha Pickett, 2017. Photo: Gaetz Photography."
publishDate = "2018-05-22T21:52:00-04:00"
related_articles = ["articles/spotlight-on-samantha-pickett.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/samantha-pickett.md"]
short_description = "There&#039;s no manual for anyone&#039;s five-year plan, and Pickett is on no quest for any sort of Right Answer™. &quot;That would make for a really uninteresting artistic journey, if we were all following the same path.&quot;"
slug = "talking-with-singers-samantha-pickett"
title = "Talking with singers: Samantha Pickett"
+++

If you're looking for them, it's easy to spot the young artists of the Canadian Opera Company throughout the season. The singers of the Ensemble Studio - Canada's top-tier training program - share the stage with world-class headlining artists, singing supporting roles and often staying on-the-ready to step in as understudies. 

Yet once a season, the Ensemble Studio becomes the main event. This year, **May 25, 7:30pm** at the Four Seasons Centre, [*An Evening with the Ensemble Studio*](https://www.coc.ca/season-calendar/ESPerformance) will be your chance to really hear the nine young singers and pianists at work. With Music Director Johannes Debus leading the COC Orchestra, the Ensemble Studio will present scenes from Mozart's *Così fan tutte*, and a concert staging of Purcell's *Dido and Aeneas*.

For soprano Samantha Pickett, who sings Fiordiligi in *Così* and appears as a Witch in *Dido*, this event will mark the end of her two seasons with the COC. She sees it as a happy send-off, a nod to the company that has fostered her artistic development.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527040173264/2017-09-26-FCS-Ensemble-050.jpg.jpg)
<figcaption>Samantha Pickett performs in the Richard Bradshaw Amphitheatre, 2017, photo: Chris Hutcheson.</figcaption>
</figure>

"It was great to have time to hone my craft and get really good at singing," she says of her day-to-day schedule in the Ensemble. Her mainstage duties were lighter than some of her colleagues', yet Pickett soaked up the program's training opportunities, opting to study roles and work with the COC's line-up of coaches and voice teachers. She joined the program at a time of transition for herself, which included a significant weight loss; honing her skills as a singer inevitably took on the added layer of adjusting to a new body.

"I'm a voice type that's kind of hard to have in these types of programs," Pickett adds. As a soprano on the verge of singing dramatic repertoire, hers is the type of instrument that often takes longer to mature. It can become a dilemma for singers like Pickett, for whom the chance to join Young Artist programs like the Ensemble Studio comes before their voices have truly settled.

"I'm not cooked yet," says Pickett, aware of her position in her path of development, "and I'm fine to be in that marination stage."

Regardless of her vocal development, Pickett took advantage of one invaluable resource available to young artists at a major opera house: watching the professionals. In that respect, the COC is one of very few places in Canada where larger, long-game voices can get an up-close look at singers who are masters of the repertoire that lies ahead. 

Artists like Christine Goerke (*Götterdämmerung*) and Sondra Radvanovsky (*Anna Bolena*) have been model case-studies for Pickett, who is grateful to the COC for "letting me watch the big dogs run."

Through observation, Pickett has learned the habits of successful singers. In preparation for the COC's production of *Anna Bolena*, she studied the title role, ready to learn not just from Donizetti's score, but from the approach of a voice like Radvanovsky's. 

"From the rehearsal room, to the Sitzprobe, to the stage, it's all there," says Pickett. "She's an incredibly generous, lovely performer and person." Of course, if there's anything to learn from someone like Radvanovsky, it's that "*bel canto* will teach you how to be a good singer."

Equally valuable to artists on the cusp of a professional career is seeing the industry's great artists as simple humans. "It's nice to see singers as people, not as characters," she says, offering a favourite example: "Christine Goerke is just a huge Mensch."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527040192537/KLP170510-_DSC6062.jpg.jpg)
<figcaption>Samantha Pickett performs in the Richard Bradshaw Amphitheatre, 2017, photo: Kevin Lloyd.</figcaption>
</figure>

Pickett has always approached her decidedly tough career with a healthy mix of reality and self-love, a few of the industry topics she unpacks on her website, [The Emerging Project](https://www.theemergingproject.com/). As she approaches her last performance on the Four Seasons Centre stage as a member of the Ensemble Studio, Pickett is remarkably settled among all the unsettling unknowns that lie ahead.

There's no manual for anyone's five-year plan, and Pickett is on no quest for any sort of Right Answer™. "That would make for a really uninteresting artistic journey, if we were all following the same path."

It's a mentality that not everyone finds, especially so early in their careers. Yet it's a huge advantage when one considers two ubiquitous elements in a singer's career: criticism, and auditions.

"You could go out and sing the absolute pants off of something, and they were looking for something different," says Pickett. "They were looking for an apple, and you're a peach."

"It took me a long time to realize that I'm not one secret away from being a fully-formed person. Every day is an opportunity to be your best, or whatever version of artist you are."

Pickett takes the stage with her fellow Ensemble Studio members on May 25, 7:30pm, at the Four Seasons Centre. For details and tickets, [click here.](https://www.coc.ca/season-calendar/ESPerformance)
