+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-03-22T14:07:00+00:00"
lastmod = "2017-03-24T12:43:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490190871247/2017-03-22---SAIMIR_PIGRU-Paul-Scala.jpg.jpg"
primary_image_credit = "Photo by Paul Scala."
publishDate = "2017-03-24T12:43:00+00:00"
related_articles = ["articles/spotlight-on-william-ford.md","articles/spotlight-on-owen-mccausland.md","articles/talking-with-singers-rene-barbera.md"]
related_companies = ["scene/companies/wiener-staatsoper.md","scene/companies/the-metropolitan-opera.md","scene/companies/royal-opera-house.md"]
related_people = ["scene/people/saimir-pirgu.md"]
short_description = "Though the risks are low in practicing one&#039;s craft within school or young artist productions, Pirgu feels that the benefits are equally low. &quot;From nothing, comes nothing,&quot; he says. &quot;That&#039;s what I learned in those years. I did things when I was not supposed to do it.&quot; In a way, he misses the carefree approach he had towards singing in these early years. &quot;It was beautiful. Just go straight away and sing. Now, I think too much.&quot;"
slug = "talking-with-singers-saimir-pirgu"
title = "Talking with singers: Saimir Pirgu"
+++

"What can I say? I'm a product of the Three Tenors," says Albanian tenor [Saimir Pirgu](/scene/people/saimir-pirgu/) with a smile. He says his teenage years were filled with the voices of Pavarotti, Domingo, and Carreras, particularly after hearing their infamous [1990 concert](https://www.amazon.co.uk/Original-Three-Tenors-Concert-DVD/dp/B00004R72K) in Rome's Caracella Baths. "Even now I remember the whole thing," he says, hinting at his own ability to sing everything on their line-up, from "Nessun Dorma" to "Granada".

"After that, it was a dream for me." Though still relatively young at 35, Pirgu has an impressive list of colleagues and performances in his career to date. He has worked with the likes of Claudio Abbado, Daniel Barenboim, Riccardo Muti, Franco Zeffirelli, and even Woody Allen, making a name for himself with the great tenor roles of Mozart, Donizetti, Puccini, and Verdi.

Perhaps the most notable influence in his career was his early work with Luciano Pavarotti. At 20, Pirgu had the chance to meet the infamous singer, and it was an encounter that he assumed would be singular. "When Luciano called me again, to listen to me again, to teach me more," he says, "then slowly after every day, after every year, it became more of a friendship."

He calls them the "best lessons I have had in my entire career", those opportunities to learn from Pavarotti. He taught Pirgu vocal technique, the value of warming up his *passaggio*, and the importance of care and patience with his young voice. "You cannot be an opera singer, or have an international career, without a quality voice," says Pirgu. "But for a voice that can sing for a long time, you need the wonderful technique that Luciano Pavarotti had."

He also learned an all-too-simple lesson that often gets overshadowed by the minutia of mastering good vocal technique: the simple care and attention to singing clear text. "He said, 'listen, Saimir, if people understand you, they will listen to you with more pleasure.'" Pirgu agrees that singers can almost forget their audience, who don't necessarily understand - or care about - the "minimal problems" that singers deal with daily. "We forget that we have a big and huge role that needs interpretation."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490358730447/2017-03-24---With-Placido-Domingo---Traviata---Metropolitan-Opera-New-York---Photo-Ken-Howard.jpg.jpg)
<figcaption>Saimir Pirgu with Plácido Domingo in *La traviata*, Metropolitan Opera. Photo by Ken Howard.</figcaption>
</figure>

## "*Traviata* is an opera for a soprano, it's not for a tenor."

"The real Saimir, I find him with *Rigoletto* and *Traviata*," says Pirgu of two roles he holds dear. The Duke of Mantua in *Rigoletto* is a role he performed both at the Royal Opera House and at the Arena di Verona; the difficult role, full of famous music, make it "easy to compare with other tenors." Yet the mythology of the role holds meaning for Pirgu, and it marks an achievement of sorts in his career as a tenor. "It's the most important role for me, I think."

He also credits Alfredo from *La traviata* for giving him a chance to mature as an artist. "I can say, to be the right arm of Violetta, it's not so easy," he laughs. "*Traviata* is an opera for a soprano, it's not for a tenor." After performing the role at the Metropolitan Opera, the Royal Opera House, and the Berlin Staatsoper, Pirgu has learned what it means to be onstage, without necessarily being a central singing role. "This role has made Saimir a great artist, I have to say," he says with a smile.

Even among the tenorial joys of singing Verdi, Pirgu maintains great respect for the music of Mozart, and what it does for singers. Roles like Don Ottavio in *Don Giovanni* and the title roles of *Idomeneo* and *La clemenza di Tito* have solidified his opinion that Mozart's music will "save the life of singers".

Pirgu debuted at the Vienna State Opera in 2004, singing Ferrando in *Così fan tutte* under Claudio Abbado - just 22 years of age. "Down in the pit, it's one of the best orchestras in the world," he recalls. "They know exactly how to play Mozart." He has since returned to Vienna to sing Don Ottavio, and he is conscious of the responsibility he has to the style and voice of Mozart's music, particularly after having added Verdi and Puccini to his repertoire. He sees a return to Mozart as a chance to rediscover those subtler colours of sound, what he calls a "natural" use of the voice, complementing the vocal and orchestra demands which are lighter than those of later composers.

"I am quite happy that still, with all the roles I have, I can sing Mozart," says Pirgu. "It helps a lot, for anyone, not just young singers. To sing a bit of Mozart will serve their career in longevity."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490358677882/2017-03-24---With-Angela-Gheorghiu-Gheorghiu---Boheme---Liceu-barcelona.jpg.jpg)
<figcaption>Saimir Pirgu with Angela Gheorghiu in *La bohème*, Gran Teatre del Liceu.</figcaption>
</figure>

## "When you're young, you know everything."

At a younger age than many tenors, Pirgu had the opportunity to build up his professional experience with major operatic figures, on the world's most important stages. "Ten years ago, I knew more than now," he laughs, remembering his love of performing outweighing any fears or neuroses. "That's the beauty of being young. When you're young, you know everything."

When many young singers are encouraged to be safe and calculated with their early careers, Pirgu is grateful for the "sink or swim" experiences he gained in his early 20s. "Now, I realize how important it is for young people to be with the real musicians onstage," he explains. "I believe that a young, talented singer or musician, around people with experience, has a chance to be something in the future."

Though the risks are low in practicing one's craft within school or young artist productions, Pirgu feels that the benefits are equally low. "From nothing, comes nothing," he says. "That's what I learned in those years. I did things when I was not supposed to do it." In a way, he misses the carefree approach he had towards singing in these early years. "It was beautiful. Just go straight away and sing. Now, I think too much."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490275376331/2017-03-23---SAIMIR_PIRGU-Paul-Scala.jpg.jpg)
<figcaption>Saimir Pirgu, tenor. Photo by Paul Scala.</figcaption>
</figure>

"I'm very, very lucky to have started my career with wonderful conductors and singers," he says. For him, it gave him an opportunity to find his innate love and excitement for singing. "In Italian, we say 'you have an aura to sing'," he explains, adding that being an opera singer is not a job for everyone. "Your spirit, your energy, your *anima* - if you don't have this when you are young, it's quite difficult to be an opera singer."

That "aura" is what gives Pirgu his daily inspiration to continue his work, particularly when the career is trying and exhausting. "Every day, I'm very happy with what I have. Making music is the best thing you can do," he smiles. "We give emotion, we give energy to people. That's why people come and listen to us."

>Saimir Pirgu is currently singing Edgardo in [*Lucia di Lammermoor*](http://www.teatrosancarlo.it/it/spettacoli/lucia-di-lammermoor-2017.html) at the Teatro di San Carlo, Napoli. For more dates, follow Pirgu on [Twitter](https://twitter.com/saimirpirgu) and [Facebook](https://www.facebook.com/saimirpirguofficial/).
