+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-08-29T18:28:00+01:00"
lastmod = "2016-09-01T08:45:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472556957249/2016-08-30---Russell-Thomas---Dario-Acosta.jpg.jpg"
primary_image_credit = "Photo by Dario Acosta."
publishDate = "2016-09-01T08:45:00+01:00"
related_articles = ["articles/talking-with-singers-steven-cole.md","articles/talking-with-singers-christian-van-horn.md","articles/talking-with-singers-luca-pisaroni.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/russell-thomas.md"]
short_description = "He considers the impetus for professional singing a simple one, through those moments of encouragement as a teenager in school. Yet when asked why he still sings, Thomas nods to the freedom he finds onstage. &quot;I could escape my own life by trying to be somebody else. And that&#039;s the reason why I still do it now, because it&#039;s the escape from all of my own baggage.&quot;"
slug = "talking-with-singers-russell-thomas"
title = "Talking with singers: Russell Thomas"
+++

When we spoke with American tenor [Russell Thomas](/scene/people/russell-thomas/), he had just returned from his monthly environmental circuit around his Atlanta neighbourhood. "It's a once-a-month commitment to pick up trash around the corner of Atlanta where I live," explains Thomas, who joins his neighbours in their monthly pact to clean up their community. "Whenever I'm home I go out and do it."

The father of a toddler and a career taking him to stages in San Francisco, Berlin, New York, and Toronto, free time is likely a hard thing for Thomas to find. "Singers usually have no life," he laughs. "The life is preparing for the next job."

Currently, Thomas' next job is a return to the [Canadian Opera Company](/scene/companies/canadian-opera-company/) after a successful run as Don José in last season's *Carmen*, this time to sing Pollione in *Norma*, opposite [Sondra Radvanovsky](/scene/people/sondra-radvanovsky/) in the title role and [Isabel Leonard](/scene/people/isabel-leonard/) as Adalgisa. 

*Norma* at the COC marks the continuation of a fostered relationship between Thomas and both the company's General Director, [Alexander Neef](/alexander-neef-listening-to-music/), and Roberto Mauro, Director of Music and Artistic Administration.

"I am treated very well there," says Thomas. "They've taken a huge interest in me, and they've been very supportive over the years." He looks forward to spending significant time in Toronto over the coming seasons, and showing his appreciation for the company. "Pretty much every first I can give, I'm giving to [the COC] as much as I can," he says of staged role debuts he'll sing at the Four Seasons Centre.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472571431511/2016-08-30-Thomas---Carmen-MC-.jpg.jpg)
<figcaption>Simone Osborne as Micaëla and Russell Thomas as Don José in the Canadian Opera Company production of *Carmen*, 2016, photo: Michael Cooper.</figcaption>
</figure>

## "I understand him well."

"In the last three seasons, Pollione is the role that I've done the most," says Thomas, who has performed the role in San Francisco, Valencia, Los Angeles. After the run of [Kevin Newbury's *Norma* in Toronto](http://www.coc.ca/PerformancesAndTickets/1617Season/Norma.aspx) this fall, he'll follow the production to [Lyric Opera of Chicago](https://www.lyricopera.org/concertstickets/calendar/2016-2017/productions/lyricopera/norma) with Radvanovsky and [Elizabeth DeShong](/scene/people/elizabeth-deshong/) as Adalgisa.

"Each [production] is different, depending on how the director sees the production or sees the character," explains Russell of his time spent with Pollione. He admits the character - with his unsavoury treatment of the women in his life - is a difficult one for development in subsequent productions, but "one thing that I've tried to do with it is make him more sympathetic than people generally view him as." 

With the bulk of Pollione's singing placed in the first act, Thomas is left with a "very short window" in which to protray him as organically changing his mind about Norma and her self-sacrifice. "He has most of his singing in the first act, the big aria, the big trio, the duet with Adalgisa, where he's just a pig, so to speak," says Thomas with a laugh. "And then he comes back in the last 15-20 minutes of the opera, and he has to, in three or four minutes, become sympathetic."

It's not difficult to find distasteful qualities in Pollione, the Roman soldier who unknowingly fathers children with Norma, and who leaves her for another illict love with the priestess Adalgisa. With characters who make questionable decisions, Thomas is careful to remember that "the one thing you can never do is judge your character." 

Instead of deeming someone a "good" or "bad" character, he puts characters like Pollione, or Pinkerton in *Madama Butterfly*, against the circumstances of their environment. "Pinkerton, for example: the Americans would go overseas, and they would get a woman." Thomas notes that there was a marriage broker who would facilitate these unions. "So, [Pinkerton] wasn't necessarily the bad guy, he was just doing what was, I hate to say, the custom."

Though Thomas doesn't name acting as one of his strongest skills ("I don't have that technique where I can just snap my finger and turn it on."), he has learned to recognize the qualities that he has in common with in his characters. He recalls Mozart's tenor roles like Tamino and Don Ottavio to be more difficult to "grab onto," but his current repertoire offers layers-deep roles with the opportunity for common ground.

"Characters like Hoffmann and Don José and even a character like Pollione, I understand him as well," he says. "I've never been a soldier, but I've been a guy who has been been some place and had an affair with somebody that I met when I was away doing a job."

Though he doesn't share the violent past of José, Thomas admits to moments of jealousy and introversion. "In relationships, I can be as flighty as a Hoffmann, in a way, or a Duke, but I'm also also possessive as a Don José." 

## "Music saved my life."

"I'm probably one of these people that's a troubled soul," offers Thomas, when asked why he sings professionally. "Not probably, I *am* a troubled soul." 

His love of music included time spent singing in high school choirs, which is where Thomas heard his first bit of clear encouragement to pursue a career as a singer. "I was so excited about it," he remembers.

"I had a very rough childhood and grew up in a rough circumstance." Playing a role onstage was an escape for Thomas, a chance to try on another life. "Music was my saviour," he says, acknowledging the element of "cliché". "Music saved my life."

He considers the impetus for professional singing a simple one, through those moments of encouragement as a teenager in school. Yet when asked why he still sings, Thomas nods to the freedom he finds onstage. "I could escape my own life by trying to be somebody else. And that's the reason why I still do it now, because it's the escape from all of my own baggage."

>You can hear Russell Thomas in Bellini's [*Norma* at the Canadian Opera Company](http://www.coc.ca/PerformancesAndTickets/1617Season/Norma.aspx), October 6 to November 5. For details and ticket information, follow our box office links below.
