+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-02-15T14:55:00+00:00"
lastmod = "2017-02-23T11:27:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487344060465/2017-02-15---Robin-Johannsen---Tatjana_Dachsel.jpg.jpg"
primary_image_credit = "Photo: Tajana Dachsel."
publishDate = "2017-02-23T10:21:00+00:00"
related_articles = ["articles/talking-with-singers-luca-pisaroni.md","articles/talking-with-singers-othalie-graham.md"]
related_companies = ["scene/companies/deutsche-oper-berlin.md","scene/companies/bayerische-staatsoper.md"]
related_people = ["scene/people/robin-johannsen.md"]
short_description = "&quot;It&#039;s like a burning desire to connect with people,&quot; says Johannsen of her pursuit of opera. &quot;I think I do it because there&#039;s unfortunately nothing else that I can find that makes me have that feeling that I&#039;m doing what I&#039;m supposed to be doing.&quot; Not everyone finds a career that&#039;s fulfilling, let alone one &quot;where you really feel alive.&quot;"
slug = "talking-with-singers-robin-johannsen"
title = "Talking with singers: Robin Johannsen"
+++

"I originally wanted to sing all those Puccini roles, those Verdi roles," says Philadelphia-born soprano [Robin Johannsen](/scene/people/robin-johannsen/) of her early years with opera. As she gained professional experience, most notably at the [Deutsche Oper Berlin](/scene/companies/deutsche-oper-berlin/), Johannsen had a taste of the standard operatic roles for a young soprano; all the while, she received encouragement about how her voice would be well-suited to Baroque music.

"They would say, you should be a Baroque singer, you should really look at all that Handel repertoire," she recalls. "It just took me a long time to get there." Johannsen's love of early music was something she learned, in part by working with enthusiastic mentors like conductor and Baroque specialist Alessandro De Marchi. "He really taught me so many things. He sort of awakened a huge love for the music in me."

Johannsen paid attention to the feedback from her colleagues, and as she tried out Baroque repertoire, she considered it more and more. "Maybe I could do more of this," she told herself at the time. "Maybe this could be a bigger part of my life."

Aware that Baroque music is a niche market within the already niche market of classical music, Johannsen likens early music to anything else that requires some effort to understand. Now, she's grateful for the gentle nudges towards Handel, Purcell, and Rameau, and she has grown to love the music she sings. "I think it fits so well with my voice," she says. "If [early music is] something that fits so well, that makes me so happy to do, and that when I'm singing it I'm thinking, 'gosh, thank you for letting me sing this music, this feels so right', then why would I instead try to convince everybody that I'm a Gilda?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487601267449/2017-02-20---Die-Zauberflote---Vlaamse-Opera-pc-Annemie-Augustijns.jpg.jpg)
<figcaption>Robin Johannsen in *Die Zauberflöte* at the Vlaamse Opera. Photo: Annemie Augustijns.</figcaption>
</figure>

## "Baroque fans are really passionate."

Being a part of a subset of classical music means being a part of a small, passionate collective of artists and audiences. Johannsen compares Baroque music lovers to the admiration she saw while singing at the Bayreuth Festival. "I've never seen anything like that. The Wagner fans, they are hardcore," she recalls. She sang small roles like the Shepherd Boy in *Tannhäuser* and the Forest Bird in *Siegfried*, yet for Wagner junkies, there's no such thing as a small part. "They love, love, love the music, and they will wait for autographs - it doesn't matter if you're the Waldvogel or the Little Shepherd Boy."

Similarly, Johannsen finds that "Baroque fans are really passionate." Part of her work with early music means performing obscure works, some of which haven't been put onstage for centuries. "Opera houses need to sell seats, so they need to have a certain amount of programming that they know they can get audiences to," she says of the balance between discovering lost works and programming familiar favourites. "It's really fun to do things, though, that people haven't seen done for 300 years or so."

Johannsen finds freedom in those obscure works, revelling in the challenge of having no recordings or performance history from which to draw ideas. "If it doesn't exist, then you're really on your own with your team," she says. And with enthusiastic fans, the payoff for being a present-day pioneer of centuries-old music is very real. "They'll be thrilled to hear something - if it's great music - that they've never heard before."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487601281007/2017-02-20---Romolo-ed-Ersilia-%E2%80%93-Innsbruck-Festival-of-Early-Music-pc-Maurice-Korbel.jpg.jpg)
<figcaption>Robin Johannes in *Romolo ed Ersilia*, Innsbruck Festival of Early Music. Photo by Maurice Korbel.</figcaption>
</figure>

## "It's necessary to be really patient."

For many young singers, Johannsen's career is positively enviable. The American soprano gained a significant portion of her early professional experience in Berlin. "I would never have done that in a million years," she laughs in hindsight. She admits that even as a young singer, Johannsen never had a plan B. "I always knew I have to be on the stage in some way to be OK." 

She applied and auditioned for "everything that came along," including for [The Opera Foundation](http://operafoundation.org/about.html), which places select emerging American singers with their overseas partners: the Deutsche Oper Berlin, the Teatro Regio di Torino, and the Bayerische Staatsoper. Though she wasn't counting on it to work out, Johannsen soon found herself moving to Germany to start at the Deutsche Oper Berlin. "It was basically a young artist programme," she explains. "You get paid a little bit, and you do a lot of work."

She had originally planned for a single season in Berlin, yet as many young singers know, career plans rarely unfold as predicted. "When I got here, my luck started changing," says Johannsen. "I was having these really great experiences on stage." Music Director Christian Thielemann offered her a *Fest* contract, and "of course, I couldn't say I'm just going to go back home. I had to stay and follow my dreams."

Many young North American singers look to Germany as a Mecca of sorts for an operatic career; few other countries offer the same quantity of professional opera houses, and the chance to build fast and furious stage experience is a priceless learning experience. Yet Johannsen is skeptical that she would have pursued a European career without securing herself a gig first. "To just come over to Berlin and to take my chances? No, I would not have had that courage."

Johannsen calls it "brave" for young singers who do take their chances with an overseas audition tour; yet courage is only part of puzzle for beginning a career in a foreign country. "It's necessary to be really patient," she advises, referring to everything from hearing back from agents and companies, to getting visas and other paperwork in order. "It's very helpful to have someone that's on your side that really speaks German well, that can help you navigate all of that."

"A lot of people that come over leave disappointed, I'm afraid," she says. Perseverance is key, a skill that goes a long way on either side of the Atlantic. "Things will never always go your way. There will always be disappointments." In Johannsen's case, much of her success can be credited to her being open to feedback, without letting her ego take a hit. "Be willing to take the criticism, and to really look at it," she urges young singers. "It's very important, especially when you come to another country with a completely different culture in every way, you have to listen when people are giving you feedback. Some of it's true. And it's painful, but you have to look at it."

Johannsen records her work in rehearsal, which helps her find a balance between listening to the feedback of others, and being her own judge. She's not an advocate of blindly following criticism, but she finds enormous value in "just considering it, if it could be true, and how you better yourself."

Feedback is another opportunity for Johannsen to raise the bar of her own craft. "I've found that some of the greatest conductors are also very strict," she says. "They want it how they want it, And if you really believe in their talents and in their ability to bring out the best in you, you have to do things that feel like they're impossible to do. You figure out a way to do them anyway when you're working with someone really great."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487601302900/2017-02-20---Almira-%E2%80%93-Hamburgische-Staatsoper-pc-Jorn-Kipping.jpg.jpg)
<figcaption>Robin Johannsen in *Almira* at the Hamburg State Opera. Photo: Jörn Kipping.</figcaption>
</figure>

## "It's like a burning desire to connect with people."

"My earliest memories are of wanting to be onstage," Johannsen says, recalling how, as a small child, she would plan out in her head her future performing career while in the backseat of her parents' car. "I would stand on the tables at family parties and sing," she laughs. "It's something I always wanted to do."

The stage speaks to Johannsen, perhaps even more than singing itself. "I would have been happy being an actress, too," she explains. "I would have been happy doing anything where you can get up onstage or in front of a camera and just forget yourself for a little bit, and feel like you're connecting with other people in this really big way."

Her first exposure to opera came in high school, and she soon fell in love with the recordings she heard of star singers. Her passion for it grew with her first voice lessons, learning how to make those operatic sounds herself.

"It's like a burning desire to connect with people," says Johannsen of her pursuit of opera. "I think I do it because there's unfortunately nothing else that I can find that makes me have that feeling that I'm doing what I'm supposed to be doing." Not everyone finds a career that's fulfilling, let alone one "where you really feel alive."

"So many people have to do jobs that they hate," she says. Though her work comes with a few things Johannsen dislikes, she calls the music she sings "a great consolation prize." She says she can be shy, no extrovert at parties, but "there's just something magical that happens onstage, and I need that." 

[Johannsen](http://www.robinjohannsen.com/index.php/schedule-2/current-events) is currently in rehearsal to sing Fiordiligi in *Così fan tutte*, with René Jabobs and the Freiburg Baroque Orchestra, on tour across Europe and Asia in April. She'll also tour performances of Telemann's *Brockes Passion* throughout France and Poland. To stay in the loop, follow Johannsen on [Facebook](https://www.facebook.com/robinjohannsenopera) and [Twitter.](https://twitter.com/robin_johannsen)
