+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2019-11-12T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Catch Rachel Willis-Sørensen in [_Don Giovanni_](https://www.lyricopera.org/productions/2019-20/don-giovanni/) at Lyric Opera of Chicago, Nov. 14-Dec. 8."
preamble = "Lyric Opera of Chicago is gearing up for its production of [_Don Giovanni_](https://www.lyricopera.org/productions/2019-20/don-giovanni/) (Nov. 14-Dec. 8), and among the impressive cast is soprano Rachel Willis-Sørensen as Donna Anna. \n\nWillis-Sørensen has made a signature role out of Donna Anna, after singing it most recently at the Royal Opera House and the Metropolitan Opera. We spoke with the soprano about the dramatic subtleties of Anna, and the work it takes to make her music feel easy."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1573602677/media/2019/11/sqRachelWillis-SorensenOliviaRenaud_s1bs9i.jpg"
primary_image_credit = "Rachel Willis-Sørensen, soprano. Photo by Olivia Renaud."
related_articles = ["articles/tales-from-the-score-annas-innocence.md", "articles/talking-with-singers-lucas-meachem.md", "articles/spotlight-on-amanda-majeski.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/rachel-willis-sorensen.md"]
short_description = "\"I used to think that you can be exactly yourself, but what I have learned is that not everyone deserves to see you that way. Your family and close friends and some trusted colleagues can see you how you are, but it is ok to present more a guarded version of yourself until you find who is trustworthy.\""
slug = "talking-with-singers-rachel-willis-sorensen"
title = "Talking with singers: Rachel Willis-Sørensen"
youtube_url = ""

+++
## Why do you sing opera professionally?

I sing professionally because it is amazing to do something which I love doing, and make my living doing it. People say if you love what you do, you will never work a day in your life. Not every single element is pure pleasure, but the parts that are, like performing with colleagues at a world class level, performing in beautiful halls, and being able to touch people with my message…well, I can't imagine anything better.

## What kind of a woman is Donna Anna, and what are some misconceptions about her?

She is a young woman. She is noble. She is largely obedient, and she has her life set out in front of her. Her traumatic experience with Don Giovanni changes her life.

> When I first approached this character, I thought that she was such an innocent victim.

There is a lot of controversy surrounding the circumstances of this event with Giovanni. It isn't explicitly clear in the score if he really raped her, if it was some sort of assault, if she was complicit…directors often play with these questions.

I think it makes it the most dramatically interesting if she is portrayed as somewhat complicit in the events that transpire during the overture. The guilt that she then has over her father coming out of the house and being killed is stronger, and it makes her character more interesting to play. Plus, it makes her more human as people tend to be not so starkly black or white in real life.

When I first approached this character, I thought that she was such an innocent victim. She is - even if she was wanting some of this attention from Giovanni, it certainly went farther than she intended, and she is unhappy with what transpired. But, I think that it is more complicated of a situation than we think at first glance. Giovanni also leaves right after he seduces her. That could also be the issue. If she is complicit, and then he just leaves, she could also be traumatized by that. Her father is killed, which in and of itself is very difficult to deal with emotionally.

> One of the biggest challenges for me is to respect the markings in the score which require you to use less of your voice.

What are some misconceptions? I think that there are a lot of misconceptions about her relationship with Don Ottavio. The audience might see her as this prudish, ice-cold character, but I don't think that she is actually cold to him. Rather, I think it is a typical situation where she needs some support, and is asking for something really specific, and his solution is to marry her. He thinks that getting married will solve the problem right away, and he is kind of mansplaining it away. It is pretty funny - pretty typical.

It isn't that she doesn't want to love and marry him, but I think she is struggling and he also doesn't seem to acknowledge the codes in Spain that she is bound by. In that time period, she would be expected to wear black and mourn for one year, so getting married and being jolly would have actually have been unexpected. So, she asks him to wait a year. That line always draws a laugh from the audience, as it seems strange to us today.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573602684/media/2019/11/DonGiovanniMartySohlMetOpera_aehg3i.jpg){{% /md %}}

<figcaption>Rachel Willis-Sørensen as Donna Anna in Don Giovanni. Photo: Marty Sohl/Metropolitan Opera.</figcaption>

</figure>

The main, specific thing that Donna Anna asks Don Ottavio to do is to avenger her father's death. Yet, despite his promises, he continually fails to act, and proves to be rather impotent. She keeps telling Ottavio to avenge her father. Even though she told him from Act I that she knows it was Don Giovanni that killed her father, it is only after the sextet in Act II, when there is not a shred of doubt that Don Giovanni is a bad guy, and killed her father, that Don Ottavio finally seems to believe her. If we look at the relationship as having communication problems, then I think that her attitude towards him is not cold, but rather logical.

> So the misconception is that she is not cold but rather a trauma victim, and trying to deal with what happened to her.

At the end of the opera, he gets off the hook, as heaven has avenged Donna Anna (when Don Giovanni goes to hell). It is funny to me that people tend to side with Don Ottavio…I guess it depends on how she is portrayed. I would love to do a production where the audience understands that waiting a year is appropriate when dealing with the loss of her father and the trauma that Don Giovanni caused. So the misconception is that she is not cold but rather a trauma victim, and trying to deal with what happened to her.

## How does it feel to sing the role of Donna Anna, and where do you find the challenges in the music?

That is a good question. It gets easier and easier, I would say! It is certainly something that I have to warmup for well, as it sits rather high. Actually one of the biggest challenges for me is to respect the markings in the score which require you to use less of your voice. For example, she is often asked to sing _sotto voce_, and it was challenging for me to use my full instrument in a _sotto voce_ way, rather than just marking. Some tastes would prefer for Donna Anna to be sung very lightly for the majority of the role, but I don't share that opinion. I feel that it is important no matter the style, that the singer finds moments in the piece to use their whole instrument in a healthy way. I think it is healthier and more rewarding for the audience.

> She is a fiery character, and she is given some of the most beautiful music of the piece in my opinion.

The long phrases in "Non mi dir" are also a big challenge, as is the punishing tessitura in "Or sai chi l'onore." It is strange, because when you just look at the score of "Or sai chi l'onore," it doesn't look that hard, but it is a killer! You are just screaming up high and it is relentless. It is also easy to get carried away dramatically, as the text is speaking about blood and you are demanding vengeance. These emotions are not great for settled vocal technique. So these two arias present a significant challenge.

The duet with Ottavio in the beginning is also a challenge. Depending on the tempi, there aren't a lot of places to breathe. You have to do these long sections with coloratura, and you either ignore the words and take a breathe in the middle where you don't want to, or somehow sing it unsatisfyingly, because you don't have successful air to get through the whole phrase. There are some real challenges, but it is also a joy to sing her. Once I figured out how to not scream, keep my breath settled, and keep my larynx in a relaxed position instead of going up, it is a joy to sing Donna Anna. She is a fiery character, and she is given some of the most beautiful music of the piece in my opinion.

## What do I think makes something a signature role for a singer, as Donna Anna is becoming for you?

That is a great question, and thanks for the inherent compliment! I like to think of Donna Anna as a signature role because it is something that I have done in a lot of the big houses….I have done it in Vienna, the Met, Covent Garden, Houston, now I am doing it in Chicago. I am not sure if this implies that I am known for the role, or that people think of me when they hear the name of the role…? Maybe that is another level. I guess it is more likely that people would say Rachel Willis-Sørensen and think Donna Anna. I think doing the role many times successfully is a big part of this, but I don't know! I am lucky that this role sits in a way that it isn't a terrible struggle. (After a lot of hard work!)

> I wish I had known not to trust every single person.

## What do you now know about the singing career that you wish you had known 10 years ago?

Forgive me, because this is going to sound a little cynical, but I wish I had known not to trust every single person. I was really open hearted, and assumed that everyone had my best interest at heart. Consequently, I was hurt really badly - particularly as a young artist by people who were in positions of power. I think they were, unfortunately, using their power as some sort of ego trip, and I was the victim of some abusive rhetoric. It haunted me for a long time, and eventually hurt my artistry, until I was able to deal with this. So, I wish that I had known to be careful who you trust completely.

> Even the times when we feel like it isn't going perfectly, we should be looking for a way to express ourselves and feel good about what we have to say.

I also wish that I had known how important your appearance is, and that if you dress better, and put effort into how you present yourself, people will take you more seriously. I personally am much more into how someone sounds, which is, I guess, why I am a musician, but your image is certainly a part of how you are perceived. I have recently taken a greater interest in this by losing weight, and making sure I don't go to rehearsal without taking care to look my best, and it has had a profound effect on how people see me.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1573602647/media/2019/11/RachelWillisSorensen-SimonPauly_qfrxvn.jpg){{% /md %}}

<figcaption>Rachel Willis-Sørensen, soprano. Photo by Simon Pauly.</figcaption>

</figure>

I used to think that you can be exactly yourself, but what I have learned is that not everyone deserves to see you that way. Your family and close friends and some trusted colleagues can see you how you are, but it is ok to present more a guarded version of yourself until you find who is trustworthy. I wish that I had known that as a young artist.

I also wish I had known that every opportunity to sing is a gift. You never know when it will be the last time you sing! I heard about this singer getting in a car accident, and the steering wheel crushed her larynx, and she could never sing again. Sometimes we get so perfectionist that we forget to enjoy it. We should remember that singing in and of itself is the reward; that the expression of one's gift is a beautiful and positive experience every time. Even the times when we feel like it isn't going perfectly, we should be looking for a way to express ourselves and feel good about what we have to say.