+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-12-03T12:20:00-05:00"
lastmod = "2015-12-07T15:21:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449201876606/2015-12-03---Peter-McGillivray.jpg.jpg"
publishDate = "2015-12-07T14:10:00-05:00"
related_articles = ["articles/talking-with-singers-nicole-cabell.md","articles/talking-with-singers-othalie-graham.md"]
related_companies = ["scene/companies/opera-lyra-ottawa.md","scene/companies/pacific-opera-victoria.md","scene/companies/calgary-opera.md","scene/companies/opra-de-qubec.md","scene/companies/manitoba-opera.md","scene/companies/saskatoon-opera.md","scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/tapestry-opera.md","scene/companies/vancouver-opera.md","scene/companies/edmonton-opera.md","scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/peter-mcgillivray.md"]
short_description = "&quot;I came to opera a little bit later,&quot; says McGillivray, who studied English, history, and Political Science before turning his attention to singing. &quot;I think it was helpful for me to have to make the conscious decision to study this, because in the end you do decide that it&#039;s the only thing you can do.&quot;"
slug = "talking-with-singers-peter-mcgillivray"
title = "Talking with singers: Peter McGillivray"
+++

"I get mine by singing," says baritone Peter McGillivray. "I love making *eye contact* with people." 

The Saskatchewan-born singer is one of Canada's most versatile artists, taking on everything from *La bohème* to *Silent Night*, from large scale concert work to any of his ongoing recital projects. "I think that's what I do most for fun, is come up with wacky programs. I waste an inordinate amount of time on the Internet researching different connections to make between pieces, other than just the musical ones." 

He calls them "set pieces," those recitals packed with songs, but devoid of the story that McGillivray insists should be present. His own recital projects come with great titles like [*The Singin' Cowboy Cabaret*](http://petermcgillivray.com/the-singin-cowboy-cabaret/) and [*Rascals, Rogues & Rapscallions*](http://petermcgillivray.com/rascals-rogues-rapscallions/), and they attest to his time spent searching for connective arcs with lots of points of entry for listeners. "I want to be able to talk to the audience, I think that's really important. All of my recitals are, I wouldn't call them lowest common denominator, but I want to find fun ways of getting people into the repertoire." 

## Buffo roles and singing well

McGillivray is currently between productions of *Il barbiere di Siviglia* (including Opera Lyra Ottawa's [ultimate production](/opera-lyra-and-the-five-stages-of-grief/)), in what he calls the "Year of the Living Bartolo". He's no stranger to *buffo* roles, which he takes seriously despite all the fun. "The key to doing a buffo role is making every note beautiful," he says. "The sort of buffo that only sort of shouts and blusters, is uncompelling to me."

Roles like Bartolo, in any opera, are appealing to McGillivray, who loves to pair his singing with great acting and comic timing. "I didn't miss not being Figaro at all." He also spends time with characters like Sharpless in *Madama Butterfly* and Schaunard in *La bohème*. They're not quite in the *buffo* camp, but roles like these present their own potential traps, and McGillivray has learned how to spot them. "Actually the person who told me this was Paul Plishka at the Met. He said, 'you got a great voice kid, but make sure you don't stay Schaunard forever. Make sure you got some Marcellos in ya.' Which I took to mean that I was maybe going for character and the things that I find fun, maybe I was overemphasizing that and not focusing on the voice enough."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449437799153/2015-12-05---Barbiere.jpg.jpg)<figcaption>From top left: Joshua Hopkins (Figaro); Maghan McPhee (Berta); Isaiah Bell (Almaviva); Peter McGillivray (Bartolo); Giles Tomkins (Basilio), and Marion Newman (Rosina) in Opera Lyra's 2015 production of *Il barbiere di Siviglia*. Photo by Andrew Alexander.</figcaption>
</figure>

The really is a fine line between paying attention to vocal technique and sacrificing the drama. "I think we can all agree that, except for certain cases, a beautiful voice is not an effortful voice. It's an effortless voice," which for McGillivray comes from a more improvisatory approach to parts of his craft. "There are some beautiful voices out there that have a lot to say, and they've thought about every movement. I'm much more improvisational. I think anybody who sees what I do onstage knows that," he laughs. "I'm not a Xerox machine as a singer. I have to go with how I feel in the moment, I have to go with how my voice feels in the moment."

He puts it really well, and really simply: "I'm not in search of the perfect, I'm in search of the true."

## Operatic training, then and now

"I came to opera a little bit later," says McGillivray, who studied English, history, and Political Science before turning his attention to singing. "I think it was helpful for me to have to make the conscious decision to study this, because in the end you do decide that it's the only thing you can do." Many young musicians pursue post-secondary music education sort of by default, which isn't bad, but isn't always thoughtful, either. "It's not that you can't be a great singer going straight from high school to being an artist. But I think that you do need to do a little growing up to do these grown-up characters and make them relatable and make them real."

McGillivray has seen the education and apprenticeship opportunities grow and expand since his own years in university. "I mean, there are so many summer programs. Everybody's got a week-long song program, and it costs this, and you can go to Italy, and you can go to France or Austria. You can go speak German in New Hampshire for three weeks." Is that always a great thing, though? "I think it's a big problem," he agrees. "There are so many artists for less and less work." It's a problem not limited to young artists anymore; young nurses and teachers too find that their degree no longer guarantees them a job in their field. "The difference," he argues, "is that in those cases, or at least with nurses or teachers, the opportunities are expanding, where ours are actively in retreat. Which is a tough pill to swallow."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449437636586/2015-12-05---Silent-Night.jpg.jpg)<figcaption>Peter McGillivray in Calgary Opera's 2014 production of *Silent Night*. Photo by Trudie Lee.</figcaption>
</figure>

Summer programs and short-term training opportunities are only the tip of the iceberg. Universities and conservatories continue to increase their music faculty class sizes, sending graduates, often burdened with student loans payments, into a professional environment that is shrinking. McGillivray says that he doesn't know where he would be today if he hadn't won the CBC Young Performers Competition a month after graduating from university. "I won it, and I paid off all of my university debts from eight years the next week." He undoubtedly worked hard for his competition win, but it's not something that artists can count on to pay their regular bills.

"There's not enough work for them," concurs McGillivray, "and they can't all become successful vocal teachers either. So there's all this training and all these opportunities for people to pay money to sing; when does that become an issue of malpractice on the teachers' parts?" McGillivray has started to teach students himself, and he admits, "it's my retirement plan, too, so I can't criticize it forever." 

## The stuff of good opera

Live concerts are a hard sell for audiences today, and classical musicians notoriously feel the pressure. "We as artists, as classical musicians, are just as subject to the distractions that are killing live performance everywhere," says McGillivray. He sees classical musicians with a certain advantage, though, compared to pop music performers today. "They're starting to have to make the adjustment that classical musicians had to make 20-30 years ago, which is the fact that recordings are not going to sell, so you'd better have a good live show, and adjust your business model accordingly."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449437954673/2015-12-05---Moby-Dick.jpg.jpg)<figcaption>Ben Heppner and Peter McGillivray in Calgary Opera's 2012 production of *Moby Dick*. Photo by Trudie Lee.</figcaption>
</figure>

That question of the business model, in operatic terms, is now synonymous with a call for funding of new works and for artistic directors who think outside the box. McGillivray has substantial experience of his own in contemporary opera. He sang the world premieres of Juliet Palmer's *Shelter* (Tapestry Opera, Edmonton Opera) and Omar Daniel's *The Shadow* (Tapestry Opera), and the Canadian premieres of Heggie's *Moby Dick* and Kevin Putz's *Silent Night*, both with Calgary Opera. Contemporary opera can sound like a lot of different things, but McGillivray wants to know what a piece has to say. 

"I think I have a less abstract sensibility than a lot of people, who work in contemporary music more than I do. It's important, it's valuable work, we can all agree on that. That's where the creative aspect of our art is really at its highest, in terms of pushing the boundaries." A narrative story, though, what speaks most clearly to him. The answers to questions about opera's relevance and accessibilty lie "in those stories that are clear and have a narrative quality to them, subject matter that is compelling. I do think those have a future."

## Life outside of singing

*What would you do if you didn't sing for a living?* It's often a question that singers don't like to answer, but McGillivray had no qualms. "My problem has always been that I've got many plans," he says. "I sort of do what I'm interested at the time - I was into history, got a history degree. Joined a bunch of choirs, because that's the best way to meet chicks." He put off law school when he started to take his singing seriously, and going back is one of the many "Plan B" options he has in the back burner. Radio personality, professional reader of books, and artistic direction are a few more.

"I've never been myopic about singing. I just always go where my curiosity leads me. Maybe that's why I have an unduly optimistic view of life, because I know I could be happy doing lots of other things as well."

>Peter McGillivray heads west in 2016, to sing Dr. Bartolo in Pacific Opera Victoria's February production of *Il barbiere di Siviglia*, opposite baritone Clarence Frazer in the title role. For details and ticket information, follow the box office links below.
