+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = 2022-03-21T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "San Diego Opera's production of [_Roméo et Juliette_](https://www.sdopera.org/season/2021-2022-season/romeo-et-juliette) runs through April 3. "
preamble = "On March 26, tenor [Pene Pati](/scene/people/pene-pati/) makes his [San Diego Opera](/scene/companies/san-diego-opera/) debut as Roméo in Charles Gounod’s [_Roméo et Juliette_](https://www.sdopera.org/season/2021-2022-season/romeo-et-juliette) opposite soprano Nicole Cabell as Juliette. Yves Abel conducts, and director Matthew Ozawa also makes his SDO debut. Contributor Eva Cahen spoke with Pati between rehearsals:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1647735387/media/2022/03/Pene_Pati_cok7el.jpg"
primary_image_credit = "Tenor Pene Pati. Photo: Mark Leedom."
related_articles = ["articles/talking-with-singers-eleazar-rodriguez.md", "articles/talking-with-singers-christian-van-horn.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md", "scene/companies/wiener-staatsoper.md", "scene/companies/san-diego-opera.md"]
related_people = ["scene/people/pene-pati.md", "scene/people/nicole-cabell.md"]
short_description = "\"I like having the feeling that I can bring a poster home from the Wiener Staatsoper or from the Met or from the San Francisco Opera and it has his name on it rather than mine. I feel like it's a good tribute to the man who’s raised me. I also sing for my island of Samoa and I sing for the Pacific people who don't really have this opportunity.\""
slug = "talking-with-singers-pene-pati"
title = "Talking with singers: Pene Pati"
youtube_url = ""

+++
## On the San Diego Opera production of _Roméo et Juliette_

"The other productions I've done of _Roméo et Juliette_ have been very classical. This one is quite unique. It's mixing in the old school idea of restrictions of lovers versus the new school idea of things being more free these days. However, the idea is still the same. Though society has changed, the idea of this love has really not changed since it was written. I'm really excited about this production. The color palette is fantastic, and it looks like it will appeal to everybody.

"This is my first time in San Diego, my first time working with Matthew and my first time with [Nicole](/talking-with-singers-nicole-cabell/), though I've admired Nicole for a long time from a distance. She has an incredible sound and an incredible voice. I'm very much looking forward to working with her."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1647735613/media/2022/03/SDO_PenePati_rehearsal_ifplob.jpg){{% /md %}}

<figcaption>Pene Pati in rehearsal for Roméo et Juliette with San Diego Opera, 2022. Photo courtesy of San Diego Opera.</figcaption>  
</figure>

## On singing in French

"In the beginning, a lot of singers find French the most difficult to sing due to its nuances and closed and open vowels and nasal. But as you become more well-versed with the French language, you understand why the music was written in this way, because that's how they sing and how they approach their musicality. I find singing in French very natural.

"There’s a distinct difference between the Italian and French styles, but I feel like my voice is suited more and more to the French repertoire. The French style of singing is very legato, very smooth lines. If Italians say 'I love you' in an opera, it's 'I love you, I love you, I love you, I love you'. It’s very passionate and very verismo. Whereas when the French say 'I love you', it's very slow. They take into account a lot of emotions to say 'I truly love you, I want to love you'. There are differences between the two musics.

"I don't feel like I'm aggressive as an artist. I feel I suit more the romantic, slower, heavier music rather than the verismo, passionate style of Italian, though I love the Italian music. But I feel like I'm slowly merging more with the French."

## On why he sings

"The reason why I’m singing is that my father is a backyard singer, on his guitar. He always sang. The culture of Samoa is singing, singing-on the oral traditions and legends to the next person. It was very much part of my life.

"We moved to New Zealand when I was two and a half. In New Zealand, he would sing about longing to go back home. I can imagine what it’s like for an island boy, suddenly being uprooted and taken to New Zealand and not seeing the homeland again. I know that he always wanted to go around the world and sing but he didn't have the means at that time.

"Now that I've got the means, and got the education for it, and the drive, I changed my name to Pene Pati on stage when my actual name, on my birth certificate, is Darren. I've been called Pene my entire life, Pene Junior to my father who is Pene Senior. I removed Junior and just use Pene Pati. This is because I would want everybody to see that my dad eventually made it out and sang around the world, through me.

"I sing for my dad and for my mom. I like having the feeling that I can bring a poster home from the Wiener Staatsoper or from the Met or from the San Francisco Opera and it has his name on it rather than mine. I feel like it's a good tribute to the man who’s raised me. I also sing for my island of Samoa and I sing for the Pacific people who don't really have this opportunity."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1647735766/media/2022/03/PenePati_SimonFowlerParlophone_a4vok1.jpg){{% /md %}}

<figcaption>Tenor Pene Pati. Photo: Simon Fowler and Parlophone Records Ltd.</figcaption>  
</figure>

## On how he started singing and opera in Samoa

"Throughout the South Pacific, opera is nonexistent. However culturally, nothing is written down. Everything is sung to the next generation. You sing a legend and you sing a myth. You have this culture of singing, yet there's no opera. I got into classical music in New Zealand - and I actually was tricked into it because I was playing rugby at the time and they said you can get classes off if you join the school choir. I loved the school choir because I had been singing my entire life.

"As my love for music grew, I realized that Pacific people, the Polynesian cultures, are living an operatic life and they don't even know about it. When they explain what happened on Independence Day in 1952 in Samoa, they sing it to you. They don't say what happened, they actually have a song they sing to you, you learn it, and then you move on. The Pacific Islands have grown incredibly in the last ten years and people will understand that opera really is a part of their life. It's not just an art form anymore. They're going to see it as the way they’ve lived their entire life.

> "I feel like _Pagliacci_ is the perfect opera for anybody who wants to get into opera."

"I was introduced to opera because I was involved in choral music. I loved it. I was in community choirs and in the New Zealand National Choir. Someone convinced me to do classical singing at university. I thought who would do a degree in singing It would be so weird. I was doing science at the time. But I gave it a go. At the music class and I was the only Pacific Islander. I thought I was completely out of my league. I didn’t know any classical songs, nor any composers, not even Puccini nor Verdi.

"Then, instead of walking away or giving up, I thought if I do this, I can open the gateway of interest to more Pacific Islanders. I knew it would be a tough road for me. However, I thought if I could make it to the top and prove that it was possible, it would be such a win for the Pacific culture and the Pacific peoples. I pursued it purely out of wanting to prove that it was possible. During that time, I fell in love with it more and more and have introduced it to many in the South Pacific."

## On COVID

"I've been very fortunate because when everything fell in the beginning of 2020, New Zealand held out quite well. I got to go home and do concerts around New Zealand. Once the world opened again, I got to go back out and carry on. The biggest thing that I've gotten from COVID is I have now a greater sense of appreciation and of gratefulness that I'm in this pool of singers that can continue to sing. I'm not ungrateful. I'm just thankful that I'm even an artist who's singing right now, amongst thousands who were not singing.

"I feel also like people have appreciated the time off because we're always constantly moving from show to show, never taking time off to shield the voice. When they got back into singing, a lot of singers were anxious because they hadn’t sung in a while but at the same time, their voices were actually quite thankful for the rest.

> "If I could go back in time, I would love to have heard in person Beniamino Gigli."

## On artists and politics

"No one ever condones war or violence but it's such a slippery slope when we start adding politics to opera because art is very subjective and very personal. It still is something that only one person experiences and if they have a chance to share out, then OK. Even parts of _Roméo et Juliette_ are very political. To add politics on top of it makes it a very heavy load.  It really is a shame that we that we don't see art for itself and let art flourish on its own and let talent be itself.

"Though I don't condone the violence, I would understand in some strange way why Anna Netrebko wouldn't want to voice anything or why Valerie Gergiev wouldn't want to voice anything. I can understand the position they’re in, where they would be forced to denounce their country and their president. Their own families could be affected in Russia and it's a tough position. It’s tough asking them to denounce all of that or not get to share their art.

"I both support the Metropolitan Opera and at the same time, I feel it's unfair to the artists.  I just hope that one day we can just do arts and let art be that.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1647735859/media/2022/03/PenePati_SimonFowlerParlophone_2_alpqbh.jpg){{% /md %}}

<figcaption>Tenor Pene Pati. Photo: Simon Fowler and Parlophone Records Ltd.</figcaption>  
</figure>

## On his wildest operatic daydreams

"If I could go back in time, I would love to have heard in person Beniamino Gigli - something about his voice that I was very curious about. He was bridging the Italianate proper sound.  He was the first version and Pavarotti was the next, more refined, version after Beniamino.

"I would have loved to hear Corelli live. Corelli had a unique technique that has never been replicated. But of course you don’t want to replicate someone’s technique or sound. It was so unique and so big. It was nuanced. I would have loved to hear that live to see how he actually sounded.

"Also, Monserrat Caballe.  If I could have heard Monserrat Caballe in her prime, I think I would have died. I think she was such a polished singer. No one in the modern day can even get to some of her singing. It's so beautiful.

"Of the modern singers, I saw Elina Garanca’s _Carmen_ ten years ago on the Met broadcast and I fell in love with her artistry and her sound. I even went out and bought the DVD. She's a beautiful lady. I’ve joked that now that I've reached a certain level, I would love to sing just one thing with her to be able to say that I've done it.

"As I was studying, there was Diana Damrau, and now I’ve come to sing with her. We sang _Anna Bolena_ together at the Wiener Staatsoper. That was such a special feeling for me. I used to watch her on my phone as a student. To be singing on stage as her love interest blows my mind.

"I would love to sing _Pagliacci_. It’s a dream role. Because it's only an hour long, I feel like _Pagliacci_ is the perfect opera for anybody who wants to get into opera. It's not long, it has everything. It has tragedy, it has love, and it has passion. It's everything you need in an opera, condensed into one heavy dose."