+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-09-25T11:56:00-04:00"
lastmod = "2017-07-18T16:16:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443445066361/GrahamResizedSquare.jpg.jpg"
primary_image_credit = "Photo by Devon Cass."
publishDate = "2015-09-28T08:00:00-04:00"
related_articles = ["articles/interviewing-the-greats-virginia-zeani.md","articles/talking-louise-with-leslie-ann-bradley.md","articles/talking-with-directors-operas-marvel.md","articles/talking-with-singers-elizabeth-caballero.md","articles/talking-with-singers-jorell-williams.md","articles/talking-with-singers-peter-mcgillivray.md","articles/talking-with-singers-leah-crocetto.md","articles/talking-with-singers-christine-goerke.md","articles/spotlight-on-rolando-sanz.md","articles/arianna-zukerman-youve-got-to-live-your-truth.md","articles/what-oscarssowhite-can-learn-from-opera.md","articles/spotlight-on-lara-ciekiewicz.md","articles/talking-with-singers-luca-pisaroni.md","articles/talking-with-singers-christian-van-horn.md","articles/talking-with-singers-jamie-barton.md","articles/talking-with-singers-corinne-winters.md","articles/talking-with-singers-melody-moore.md","articles/spotlight-on-angel-blue.md","articles/spotlight-on-musa-ngqungwana.md","articles/spotlight-on-will-liverman.md","articles/talking-with-singers-lise-lindstrom.md","articles/talking-with-singers-christopher-purves.md","articles/talking-with-singers-keri-alkema.md","articles/talking-with-singers-audrey-luna.md","articles/sidney-outlaw-stairs-success.md","articles/talking-with-singers-elza-van-den-heever.md","articles/talking-with-singers-robin-johannsen.md","articles/talking-with-singers-chen-reiss.md","articles/a-grand-night-out-at-vancouver-operas-turandot.md"]
related_companies = ["scene/companies/nashville-opera.md"]
related_people = ["scene/people/othalie-graham.md"]
short_description = "&quot;If I&#039;m cast in something, I show up incredibly prepared, I&#039;m a very good colleague, and I do the things I can do to make it work. There&#039;s so much of it that we can&#039;t control, as you know. *So much* of it that you can&#039;t control. But I do the best that I can every day, I work really hard with the things I can control,&quot; she laughs. &quot;Which isn&#039;t a lot.&quot;"
slug = "talking-with-singers-othalie-graham"
title = "Talking with singers: Othalie Graham"
+++

"I did my training in Canada," says Canadian soprano [Othalie Graham](/scene/people/othalie-graham/), "but I've never sung in my own country. Much to the shock and surprise of many, many people, I have never ever sung in Canada. And I think a lot of people probably don't know that."

### A Canadian in America

Graham was a biology student at York University when she left to study voice with [Lois McDonall](https://en.wikipedia.org/wiki/Lois_McDonall). 
"I basically went from her basement to AVA," she laughs. "I mean really, that's exactly what happened." She stayed in the United States after graduating from the Academy of Vocal Arts. "I had a student visa, and then a work visa, and then I ended up marrying an American a few years later, and just decided to stay." 

Living in Philadelphia makes it easier for Graham to travel to gigs and auditions, but performing at home is still on her to-do list. "Definitely, I'd love to sing in Canada at some point. I come home at least once a month, so it would be great for all my Canadian family to hear me sing at some point. My mom travels with me, so that's nice."

For Canadian singers, work in American opera houses is tempting; there are more places to work than in Canada, and you don't have to fly across the Atlantic to get there. Yet, it's not as simple as winning an audition. Graham received a student visa from the Academy of Vocal Arts, which allowed for one year of professional development in the US after graduation. "You basically have a year to find a job, but a lot of the jobs say, 'well, do you have the visa to get the job?' You're right, it's a chicken and egg kind situtation; it makes it very, very difficult."

I mentioned that trope among Canadian singers, that it's easier to work way over in Europe than just next door in the United States. "Absolutely it is," says Graham. "I think it's easier for Canadians to go anywhere except the United States."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443407469557/Othalie-Graham---Turandot-2---Photo-courtesy-of-the-artist.jpg.jpg)
<figcaption>Othalie Graham as Turandot. Photo courtesy of the artist.</figcaption>
</figure>

### Big roles and good singing

Graham has spent the last decade taking on some of the most demanding roles in opera, like Turandot, Minnie (*La fanciulla del West*), and Aïda. "Turandot is the one that I *absolutely* love the most" she says. Graham's repertoire includes operatic masterpieces and incredible characters (think Elektra, Isolde), things that not every singer gets to try out. Her voice is at home in these roles, and still Graham makes a priority out of keeping things fresh from one production to another.

"Especially with Turandot, because I've done that one the most, I always look for something new. And you know, a new cast helps you find different nuances and new things in it, new directors. The director I'm [doing it with now](http://www.nashvilleopera.org/turandot/), I've done it with him a couple of times; his [production](http://www.nashvilleopera.org/turandot/) is so exciting, and it's so different, that it really helps to find something new in the character." 

So, just how *does* she feel at the end of a performance of *Turandot*? "Exhausted. But, never vocally exhausted, which is interesting." For Graham, striving for simplicity and ease is what it means to sing well. That is, singing in a way "that at the end of the show you could sing the entire show again, if you had to. So that your voice always stays youthful, and flexible and buoyant. Especially when you sing such big, demanding repertoire, the idea is always to keep that bloom and youth in your sound, and that for me is really the most important. I don't try to make my voice bigger, it's certainly more than big enough on its own; so I just try to sing as beautifully as I can all the time."

They get the great roles, sure, but large, dramatic voices are presented with plenty of temptation for too big, too soon. Graham admits to having a few roles on her resume that "maybe didn't fit the way I wanted them to, so I could have done without." She knows how difficult it can be to learn to say no, something that "is not always easy when you have a house to pay for." Yet, Graham's patience pays off onstage. "I'm fairly young in this repertoire, and *for* my repertoire, so through all the Turandots and all the other big repertoire, it's good to keep Aida and the Verdi *Requiem*, because it forces you to sing *pianissimo*, and sing high."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443407599319/Othalie-Graham---Turandot---Photo-courtesy-of-the-artist.jpg.jpg)
<figcaption>Photo courtesy of the artist.</figcaption>
</figure>

### Singer life

Othalie Graham had no misconceptions about the real life of a working opera singer. "I always sort of knew that it wasn't as glamourous as I thought. My first teacher, since she had such an enormous career, she made sure that I was aware that it's a lot of, you know, washing your underwear and hanging it on a radiator in Europe, or something." It's about weighing the huge rewards of the career with what can seem like huge sacrifices. "It's such a wonderful, amazing thing, but at the same time it's very human and can be very humbling. And sometimes it's a lonely life. Lots of holidays Skyping with your family and your husband, eating in your hotel room as you wait for performances."

But Graham considers the career a gift, one that comes with responsibility. "I'm a very spiritual person, and I believe that when you are given a gift, that is your form of prayer by performing and working on the gift. So that's why I do it, because I was given such a gift, and it's a tremendous responsibility to do the best that I can." There's a good amount of luck in a singer's career; sometimes the hard work can fall on deaf ears. "I know some incredible singers who don't get to sing professionally. So if you are the few that get to, it's an amazing, tremendous responsibility to do as much as you can to make it happen."

There was an ease and a warmth to my conversation with Othalie Graham, and the wisdom with which she spoke about her work made me eager to have her make her now-anticipated Canadian debut. Successful singers today seem to find a careful balance of level-headedness and respect for the art, and Graham still speaks with awe about her most familiar roles. "If I'm cast in something, I show up incredibly prepared, I'm a very good colleague, and I do the things I can do to make it work. There's so much of it that we can't control, as you know. *So much* of it that you can't control. But I do the best that I can every day, I work really hard with the things I can control," she laughs. "Which isn't a lot."

>Othalie Graham stars in Nashville Opera's *Turandot* beginning October 8th. After that, she heads to Mexico City to sing a concert of Wagner. For details and tickets, follow the box office links below.

