+++
author = ["authors/hannah-de-priest.md"]
categories = "Interview"
date = "2019-02-12T01:14:34+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1549934293/media/2019/02/sqNinaStemme.jpg"
primary_image_credit = "Soprano Nina Stemme. Photo: Neda Navaee."
related_articles = ["articles/la-nilsson-celebrating-birgit-nilsson-at-100.md", "articles/loc-elektra.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/nina-stemme.md"]
short_description = "She cautions that even in a prestigious YAP or ensemble studio, the opera directors are juggling many priorities and they simply want \"to get the most out of your voice right now.\""
slug = "talking-with-singers-nina-stemme"
title = "Talking with singers: Nina Stemme"
youtube_url = ""

+++
Disarmingly approachable, keen to give advice and loathe to self-aggrandize, [Nina Stemme](/scene/people/nina-stemme/) is beloved not only for her impeccable, honest artistry but for her thoughtful, deeply personal interpretations of opera's most psychologically complex heroines, including Isolde, Salome, Brünnhilde, and Elektra, which she is singing this month at the [Lyric Opera of Chicago](/stemmes-elektra-visible-in-every-wild-look-and-lurching-step/) in a long-overdue company debut.

As charmed as her career appears from the outside, Stemme is quick to challenge the commonly-held assumption that she's had anything resembling a meteoric rise. She came to study opera relatively late, graduating from the Stockholm Opera Studio at 30. While she had a string of successes early in her career as a Mozart-and-Puccini soprano, (among them, being a finalist at the 1993 BBC Cardiff Singer of the World Competition and winning the inaugural Operalia competition), her move to the dramatic repertoire that now defines her was a slow, methodical transition.

> She cautions that even in a prestigious YAP or ensemble studio, the opera directors are juggling many priorities and they simply want "to get the most out of your voice right now."

Stemme credits early experiences with Mozart and Puccini as invaluable for securing her vocal technique. Many cite Mozart coloratura as a crucial way for singers to maintain and hone their vocal agility, but Stemme points to another benefit: "Mozart phrases are _long_!" Stemme says getting the voice to move through phrases expressively is a fundamental step towards singing larger repertoire. "Puccini and Strauss are not so different," she says. "For both, if you can make sense of the vocal phrases and sing through them convincingly, that's more than half the work right there.”

In Stemme's unusually didactic official bio it is emphasized, "That she initially shied away from these staggering heights of the soprano repertoire is a noteworthy—if not the defining—characteristic of her career. Mozart's Cherubino is a far cry from Isolde and Turandot, a leap only few have mastered. Nina Stemme made the leap successfully by taking the time a development of this kind requires."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549934452/media/2019/02/NinaStemmeNedaNavaee2.jpg){{% /md %}}

<figcaption>Soprano Nina Stemme. Photo: Neda Navaee.</figcaption>

</figure>

Indeed, the criticality of an introspective, self-disciplined approach to artistic growth was a theme throughout our conversation. "When you're offered a job, a contract, whatever," says Stemme, when asked about advice for young singers, "never say yes right away. Count to ten." Even if the opportunity seems too good to pass up, take the time to "think and _feel_."

> Stemme says she has sought out therapy a couple times over the course of her career, "in order not to stand in my own way."

This advice has guided her throughout her career, especially at one oft-mentioned highlight: when she was offered her first Isolde by Glyndebourne, which was mounting _Tristan und Isolde_ as its first-ever Wagner production. Before accepting, she thought: "What do I need to do this?" and the answer revealed itself: two and a half years of dedicated study. Glyndebourne acquiesced and Stimme spent that time immersing herself in the role of Isolde, taking train rides to study with trusted coaches and readying herself for a major debut.

It was, she said, the ideal way to learn a major part. The role of Elektra, (which she has performed to great acclaim in New York, Berlin, Vienna, and now Chicago), she learned in less desirable circumstances, "fitting it in between jobs."

Over the course of our chat, Stemme was eager to emphasize the importance of figuring out exactly what you need as a musician and asking for it. It's not a skill young singers are encouraged to develop; instead we're often taught that we are infinitely replaceable (a strange, sad way to motivate burgeoning talent). Increasingly, the industry is built on the backs of apprentice artists who are offered glimpses of glory (covering stars or sharing the stage in comprimario roles), but are rarely encouraged to consider their careers as long trajectories.

For young singers today who face daunting pressure to be fully formed "products" or "brands" by the time they graduate college, the idea of taking two and a half years "off" is surely an agitating one. A role offer (even if it’s too big or just not the right role), might be accepted injudiciously by a singer feeling the pressure to appease a company’s top brass and cram a season chock full to keep pace with the competition. It's an unfortunate dilemma that Stemme acknowledged: an undeniable surge of young talent has led to a raising of the "general level" of music-making, "but at the same time, singers are so afraid of being sacked they won't share their true feelings, \[even\] if they're having a hard time."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549581135/media/2019/02/NinaStemme2ELEKTRALyricOperaofChicago.jpg){{% /md %}}

<figcaption>Nina Stemme in Elektra, Lyric Opera of Chicago, 2019. Photo: Cory Weaver.</figcaption>

</figure>

It's an ominous trend another Swedish dramatic soprano, Birgit Nilsson, took aim at when she established her foundation and its unique approach to spending down its endowment: a one-million dollar prize awarded approximately every three years. With no strings attached to its significant sum, the Birgit Nilsson Prize is singular in the field of classical music. One of its named goals is to "motivate young artists...to take a long term perspective in building their careers."

The only moment in our chat that Stemme turned visibly circumspect was at the mention of the Nilsson Prize, which she was awarded in 2018, the year of Nilsson’s centenary. Stemme isn't yet speaking publicly about her plans for the money—indeed, she said that due to her busy singing schedule, she simply hasn't yet had the time to consider its possibilities. A quick look at her calendar shows an intimidating six months of Strauss, Wagner, and Puccini (with a couple gala concerts as well).

> "At the same time, singers are so afraid of being sacked they won't share their true feelings, \[even\] if they're having a hard time."

I’ll end this piece with one of the more direct and spontaneous recommendations Stemme made. Shared in the context of advice for young singers (but equally valuable for any person in any field), Stemme was clear and firm: "get to know yourself." Therapy, Stemme says, can be an invaluable tool. While she acknowledged that especially in the U.S., securing mental healthcare can be complicated and financially burdensome, its benefits are manifold. Stemme says she has sought out therapy a couple times over the course of her career, "in order not to stand in my own way." Certainly, the stresses and expectations of an operatic career are peculiar - the pressure to be always "on," lots of traveling, flitting in and out of different characters, plus long stretches of time spent in isolation, away from close friends and family. And then there's the omnipresent knowledge that it's all built on the shifting sands of a fundamentally unreliable resource: a human voice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1549934572/media/2019/02/NinaStemmeNedaNavaee.jpg){{% /md %}}

<figcaption>Soprano Nina Stemme. Photo: Neda Navaee.</figcaption>

</figure>

When talking about her own start in the professional singing world, Stemme says she realized early on that, "It was only me who could be responsible for my own development." She cautioned that even in a prestigious YAP or ensemble studio, the opera directors are juggling many priorities and they simply want "to get the most out of your voice right now." That is, they aren’t always in a position to consider your long-term development or even vocal health. At the end of the day, Stemme says it's not about what someone else says your fach is, or what you’re told you "should be" singing.

Her advice? Find your niche and "sing what suits you. After all, a singing bird has to be happy to sing well."