+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-04-15T20:25:00-04:00"
lastmod = "2018-04-16T11:25:00-04:00"
preamble = "Angolan tenor [Nelson Ebo](/scene/people/nelson-ebo/)'s upcoming role is one that hits particularly close to home. Next month in Heartbeat Opera's new adaptation of Beethoven's [*Fidelio*](https://www.heartbeatopera.org/fidelio) (**May 3-13**), Ebo sings Stan - or Florestan, in the original libretto - the black activist who is wrongfully incarcerated. Ebo, born during the [Angolan Civil War](https://en.wikipedia.org/wiki/Angolan_Civil_War), has seen injustice in his own life; he lost friends and family to illness and violence before leaving Angola to pursue singing in Spain.\n\nEbo spoke with us about being \"the loudest one\" of a family of 16 children, his early love of The Three Tenors, and what he has in common with Stan in this special *Fidelio*."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523838097842/sqNelsonEbo.jpg.jpg"
publishDate = "2018-04-15T21:00:00-04:00"
related_companies = ["scene/companies/heartbeat-opera.md"]
short_description = "&quot;My desire for singing was within me when I was born. My father loved to sing and when I was a child I was always the loudest one (out of the 16 of us). I sang in my church choir and found a way to formalize my love of singing. When I was a bit older, I was given a cassette tape of the Three Tenors and started imitating them.&quot;"
slug = "talking-with-singers-nelson-ebo"
title = "Talking with singers: Nelson Ebo"
+++

## How do you approach a role like Stan, an adapted version of a character from Beethoven's *Fidelio*?

As with any role that I sing, I think the first important step is to look for ways that I can identify personally with the character I am going to portray. For *Fidelio* I must work to uncover and connect with Stan's personality, past experiences, desires, virtues and vices and place myself within them. The character must come alive in me as I sing his story to give justice to both Beethoven's and Ethan's visions for this opera. I am finding that I am able to connect with Stan in many ways, for example in struggling through systems of oppression and injustice. Growing up during a civil war that was fought literally on my doorstep, I remember feeling that there was no freedom, that I was imprisoned within my own life. Like Stan, I felt shackled down by the lack of freedom and yearned for the time when peace and justice would be had. 

## How does Beethoven/Ethan Heard's storytelling about political prisons and war compare to your own experience in Angola?

Growing up in Angola during the civil war was a difficult reality. I have vivid memories of needing to run away when the military came so that I wasn't taken as a child soldier. War was a part of my everyday life. My parents were a part of the war efforts, many of my siblings fought and died during the war. The atmosphere was one of oppression and fear, where you were not able to move freely, speak out, or act out. Within the war, our nation was divided. As with many nations that have experienced civil war or internal uprising, you ended up being forced to confront your brothers and sisters just as Stan confronts Rocco, his "brother". I relate to the experience Stan has in seeking truth yet being oppressed because of it, being face to face with those who oppose you, and desiring the closeness and love of your family. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523838277644/KellyGriffinNelsonEbo.jpg.jpg)
<figcaption>Nelson Ebo with soprano Kelly Griffin, who sings Leah/Leo in Heartbeat Opera's upcoming production of *Fidelio*.</figcaption>
</figure>

## How were you discovered as a singer, and why did you choose to emigrate to pursue formal training?

My desire for singing was within me when I was born. My father loved to sing and when I was a child I was always the loudest one (out of the 16 of us). I sang in my church choir and found a way to formalize my love of singing. When I was a bit older, I was given a cassette tape of the Three Tenors and started imitating them. I eventually went on to sing at a local venue to support for my family as we were very poor.  Someone who used to go to the restaurant liked my singing and believed I could make a career out of it. He helped me find some sponsorship to study in Spain. 

Since then I have been able to study in Italy, Germany and the US and sing in many other places around the world. However this was not a very easy journey as my family remained in Angola and I was unable to see them for 12 years. I now live in the US with my wife and our son.

## What do you know about the singing career now that you wish you knew 10 years ago?

10 years ago I would have just moved to the US to begin my studies here. 

Something I would like to tell my past self is to study the entire role, not just focus on arias. It is easy and fun to prepare arias, but understanding and preparing the entire role within the opera, as well as the composer and his story, helps greatly when giving meaning and life even to that one aria. 

## Why do you sing professionally?

I sing because I love it. Ever since I knew what being an opera singer meant, it was my dream. I had the vision of the great Maestros Domingo, Pavarotti, and Carreras in my mind and I wanted to become like them, but now I want to become the great "me". I feel the presence of my parents and my siblings who have passed away with me as I sing, it is almost as if everything else is muted and I am surrounded by my family. They give me strength to persevere.  I desire to continue in this career to honor them and the sacrifices they have made for me to pursue this career, including agreeing to let me leave Angola.

>Ebo sings Stan in Heartbeat Opera's [*Fidelio*](https://www.heartbeatopera.org/fidelio), running May 3-13 at Baruch Performing Arts Center. For details and tickets, [click here.](https://www.heartbeatopera.org/fidelio)
