+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-03-16T22:13:00-04:00"
lastmod = "2018-03-18T21:38:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521252761254/sq---cropped-ncraighead-8241.jpg.jpg"
primary_image_credit = "Photo: Dahlia Katz."
publishDate = "2018-03-18T21:38:00-04:00"
related_articles = ["articles/talking-with-singers-luca-pisaroni.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/neil-craighead.md"]
short_description = "If he could go back and give himself some advice, however, Craighead would add in some encouragement. &quot;I would tell myself that I was on the right track,&quot; he says. &quot;I had a lot of the right instincts and a lot of the right tools given to me, but I just needed to trust them.&quot;"
slug = "talking-with-singers-neil-craighead"
title = "Talking with singers: Neil Craighead"
+++

Among the paths taken by young Canadian opera singers, bass-baritone [Neil Craighead](/scene/people/neil-craighead/)'s was one of the most coveted. "I was extremely fortunate," he says of his quick transition from an undergraduate degree at the University of British Columbia, to Opera NUOVA - a rite-of-passage Canadian summer opera program - and beginning four influential years as a member of the Canadian Opera Company's Ensemble Studio program. 

Craighead's was a swift, dense trip from one of Canada's top-ranked music schools, straight into Canada's operatic network of conductors, directors, voice teachers, and fellow young artists. "I got into pretty much the best possible place I could to get training," he says of the Ensemble Studio, where he gained the skills and professional experience that built the foundation of his pursuit of opera. "The investment they made in my development was huge," he says of the COC and General Director Alexander Neef. "I'm going to be forever indebted to them."

## "Take advantage of your age."

Craighead's "ride the wave" philosophy in his early professional life was one of following opportunities; though his four years at the COC might have prolonged the tough transition period between school and work for longer than many of his colleagues, he wasn't immune. "The wave eventually stopped after Ensemble, and that's when you have to make tough decisions."

There's some irony in Craighead's early exposure to the top tiers of Canada's opera industry. As a bass-baritone, he is among the young singers who have to employ huge amounts of patience, honing his craft while he waits for the biology of his instrument to catch up with his ambition. But Craighead has always been comfortable playing the long game. "I'll get mine at the end of my career," he says with a laugh.

In the meantime, "Take advantage of your age, because you're not going to be eligible for everything forever." Now in his 30s, Craighead calls it one of his few regrets that he didn't enter certain high-profile competitions or audition for summer programs before he outgrew the age limit.

Other notable changes since he began his professional life are Craighead's wife and two children. Traveling for contract work is invigorating, but inevitably becomes more difficult when it's put against time spent away from family. "Contracts away are more stressful, just harder on everybody," Craighead says, admitting that he has turned down work that would have kept him on the road for months at a time. 

In other cases, he brings his family with him, like he'll do for his upcoming performances in [*Carmen* at Opéra de Québec](http://www.operadequebec.com/programmation/carmen-bizet/) and his role debut as [Scarpia in in Opera on the Avalon's *Tosca*](http://operaontheavalon.com/tosca/). "It's either that, or I'm not going to see [my family] for two-thirds, three-quarters of the year, and that's just not an acceptable option," Craighead says. "You need an incredibly supportive partner if you're going to be a professional singer with a family."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521252642771/tito1.jpg.jpg)
<figcaption>Neil Craighead as Publio and Rihab Chaieb as Sesto in the Ensemble Studio Performance of the Canadian Opera Company’s production of *La clemenza di Tito*, 2013. Conductor Daniel Cohen, director Christopher Alden, set designer Andrew Cavanaugh Holland, costume designer Terese Wadden and lighting designer Gary Marder. Photo: Michael Cooper.</figcaption>
</figure>

## "Learn how to breathe properly."

"I'd love to give my 10-years-ago self a voice lesson," Craighead laughs. "God, the things I could save myself time and trouble with."

It's easier for him to see now, after working with several teachers, that there are things are best left to time and repetition. Other skills - like extending lung capacity and breath control - come out of being pushed beyond his comfort zone. "You always think you're using the most [amount of air], and there's usually extra to be found," says Craighead. "Sometimes you amaze yourself, when someone forces you to push past your limits."

He has found his limits pushed most recently by Jason Howard, the Welsh-born baritone with whom Craighead studied while he was most recently in Toronto. Craighead is big on the try-anything-once philosophy, especially when it comes to working with a new teacher. That means a good, honest try, despite any unease or scepticism. Still, it's a two-way street between teacher and student. "Try everything once, but don't indulge everyone," he advises. 

Craighead's helpful lessons with Howard - a similar voice type to his own - are also the result of timing. There's a skill to being a student, and it's often true that students and teachers are not always ready for each other. Craighead's work with voice teachers like Wendy Nielsen, Marlena Malas, and Tim Noble have set him up well to hear the specific advice - the murky topic of "cover", for example - from Howard.

If he could go back and give himself some advice, however, Craighead would add in some encouragement. "I would tell myself that I was on the right track," he says. "I had a lot of the right instincts and a lot of the right tools given to me, but I just needed to trust them."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521252655507/neil-lep.jpg.jpg)
<figcaption>Neil Craighead as Leporello in *#UncleJohn* with Against the Grain Theatre, 2014.</figcaption>
</figure>

## "YouTube is an incredible resource."

One of the irreplaceable learning opportunities of Craighead's time as a young artist at the Canadian Opera Company was sharing the stage with industry professionals. Though no longer considered a "young artist", he returned most recently to the COC to sing Count Ceprano in *Rigoletto*, spending time in close quarters with baritone Roland Wood in the title role. "Some of the best experience you can get is being four or five feet away from someone as they're singing 'Cortigiani' in your face," he says of Wood's rave-review earning portrayal of Verdi's jester.

Craighead loves to watch a singer's technique, observing the minutia in the faces of his onstage colleagues. And when he can't watch, he listens, with his Kenwood KD-44R record player, recently acquired at an estate sale. The Neil Diamond album that came with it marked the start of his rapidly growing vinyl collection. "I own probably ten or eleven different copies of *Tosca*," he smiles. "Some I own for the Tosca, some I own for the Scarpia, some I own for the conductor."

He used to stick to one satisfactory recording of the operas he listened to, but Craighead has now become a master of comparison. "I listen to recordings much more critically." Among his 10+ recordings of *Tosca*, for example, he listens for choices made by different singers and conductor, and even the variances between recordings made by the same artists at different points in their careers.

Craighead's style of critical listening has never been easier to adopt. "YouTube is an incredible resource," particularly for those who like to go down the rabbit-hole of suggested videos. A single aria is a digestible way to start, choosing one artist as a springboard to other singers' interpretations. "Just click on them and listen to their version," says Craighead. "What is it that you find more thrilling about one version compared to another?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521252663724/ncraighead-8275.jpg.jpg)
<figcaption>Neil Craighead, bass-baritone. Photo: Dahlia Katz.</figcaption>
</figure>

Honing critical listening skills, even in young people, is part of how appreciative opera audiences are fostered. Craighead, through his work in youth outreach opera at the COC, and with his own family, knows that there's effort involved in getting young people used to the sound of classical music, and that exposure to something like opera doesn't happen through osmosis.

"The point of outreach isn't necessarily to get people to be opera singers, but it's to get people interested in music and the arts." Craighead takes seriously the task of creating an audience for opera in the decades to come, and enjoying the fringe benefits of arts education along the way. "If we let the kids just become zombies to Spongebob and Katy Perry," he says, "we've lost."

For Craighead, the arts education he had, from singing in choirs to focused operatic training, has given him the gift of a career he truly loves. His job description as a singer, going over a scene multiple times, working out musical problems, "I don't consider that strenuous."

"I don't consider it work when I have to go to a rehearsal," he says. "Opera is just a good time."
