+++
author = ["authors/eva-cahen.md"]
date = "2018-09-25T16:53:00-04:00"
lastmod = "2018-09-25T18:55:00-04:00"
preamble = "Morris Robinson, the American bass, is appearing as the Grand Inquisitor in [*Don Carlo*](https://www.laopera.org/season/1819-season-la-opera-season/don-carlo/) by Giuseppe Verdi September 22, 29, October 4, 7, 11, and 14 and as Parsi Rustomji in [*Satyagraha*](https://www.laopera.org/season/1819-season-la-opera-season/satyagraha/) by Philip Glass October 20, 27, November 1, 4, 8, and 11 at the LA Opera."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537916014869/sqMorrisRobinsonrig_2568pr-KenHowardLAOpera.jpg.jpg"
primary_image_credit = "Morris Robinson as Sparafucile in LA Opera's 2018 production of Rigoletto. Photo: Ken Howard/LA Opera."
publishDate = "2018-09-25T18:55:00-04:00"
short_description = "&quot;At the age of 29, I auditioned for the Choral Arts Society in Washington where I sang some of the pieces I did in high school. Norman Scribner, the director for many years of the Choral Arts Society sat with his mouth open and told me there weren&#039;t many people who could make a sound like that.&quot;"
slug = "talking-with-singers-morris-robinson"
title = "Talking with singers: Morris Robinson"
+++

### On singing

I sing because my first love has always been music, and then sports. I wanted to be a drummer and a football player but not a singer. My mother made me audition for the chorus in high school. It was then that I realized God had given me the gift of making a very resonant sound that not a lot of people could make. I did a lot of classical music then but after, I stepped away from singing because I wanted to play football. 

At the age of 29, I auditioned for the Choral Arts Society in Washington where I sang some of the pieces I did in high school. Norman Scribner, the director for many years of the Choral Arts Society sat with his mouth open and told me there weren't many people who could make a sound like that. 

My mother told me years ago that when God gives you a gift, you have to use it. I've been blessed with this gift and not only does it fall in line with my first love, music, but it also comes with a lot of responsibility. This is not something that is given to everyone. It is my responsibility, my calling, to utilize my gift, display the blessings of God and display the gifts He has given me. It is my responsibility to be a good steward of that gift so that I use it to bring happiness in people.

### On preparing simultaneously for two very different operas at the LA Opera

It takes a lot of discipline and drive. I'm not foreign to the idea of being double-cast and doing two different things from two different composers in two different styles and two different languages. Usually they're in the languages I customarily sing in - Italian, German, English, Russian, Latin - but for that other language to be Sanskrit and to sing in Sanskrit in a Philip Glass score, it is incredibly difficult. 

*Don Carlo* feels like a walk in the park at this point. People think the Inquisitor is an easy role because it's one big scene and just a couple of other appearances, but that one scene requires the singer to display everything in the bass voice. At this point, even that scene is easy. 

Singing Philip Glass and in Sanskrit is like taking something that's really hard already - the musical score - and complicating it exponentially with a language that is incredibly hard to sing in. People sometimes don't think singers are intelligent, that we just sing, but it takes a degree of aptitude and discipline to pull this off. I'm doing it but it's very hard. It's the hardest thing I've ever done.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537916059532/MR1-LawrenceBrownlee.jpg.jpg)
<figcaption>Morris Robinson, bass. Photo by Lawrence Brownlee.</figcaption>
</figure>

### On discipline

I find the discipline to do this from what I learned throughout life. I can attribute it to the military academy, the Citadel, where I was a Cadet and I had to be very disciplined to get through the curriculum, the military training, and play sports. I can also attribute it to athletics because it takes discipline to prepare mentally and physically for a game. I also attribute it to the discipline of being a musician, of having to buckle down and turn off the television to learn the score. 

In a nutshell, all those factors come into play. At some point it becomes a lifestyle and you know when you have to crank it up. Los Angeles is a wonderful city and I love going to the beach and to rooftop bars and hanging out, but that has been reduced to a minimum because I'm sitting around studying *Satyagraha* and rehearsing *Don Carlo* simultaneously. It's a testament to all the things that have played a role in helping me develop the disciplinary techniques I'm using now.

### On his playlist

I listen to a lot of Robert Glasper. I listen to a smorgasbord of hip hop. Drake is an example. My top five on my playlist is 2 Chainz, Migos, Future, and Kendrick Lamar. I listen to a lot of gospel as well. My favorite gospel artist right now is Trey McLaughlin, also a Georgia boy.

### On comparing opera and football

It's not a fair comparison but there are some similarities to both that I enjoy. One is the spotlight. I'm never going to be the star of the opera because I'm the bass, but I do enjoy the pre-game, sitting in my dressing room and I enjoy walking out on stage and commanding the stage. 

Because I'm a bass, I get to play the same type of role as a ball player. I go out and I command attention because as a bass, I'm the one in a position of authority. If I walk out as Sarastro, everyone is singing my praise before I walk out and then they listen to what I am saying. If I walk out as Ramfis, I'm the high priest sentencing people to death. If I walk out as the Grand Inquisitor, even the King bows down to me. Everyone listens to me. In the scene in Act IV, they're terrified. In Zaccaria's first scene in *Nabucco*, he is energizing the people. In *Satyagraha*, in my first aria, I'm angry and I get everybody in a rage because of all the atrocities. These types of roles feed into my testosterone-laden ego, which makes me want to be the guy. 

I [continue to] watch football non-stop. I hate it that opera happens during football season. Saturday rehearsals interfere with College Football, Thursday rehearsals interfere with Pro Football. I've told everyone that they can't contact me and get my full attention on Thursday nights because of the NFL, Saturday because of College Football, Sunday again because of the NFL, and Monday because of Monday Night Football. I'm only available on Tuesday and Wednesday.

### On role models

I'm singing with one right now. It's Ferruccio Furlanetto. [I just posted about him on Facebook](https://www.facebook.com/morris.robinson.927/posts/10156000908977989). He is one of my idols and I have looked up to him for years. In fact, when I was learning *Don Carlo*, I listened to a recording with Ferruccio Furlanetto and James Levine. Sam Ramey was the Inquisitor. Sam Ramey is another one of my idols. I've been blessed to perform with both of them now.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537909606360/MorrisRobinsondc_37a0913_pr-CoryWeaverLAOpera.jpg.jpg)
<figcaption>Morris Robinson as the Grand Inquisitor and Ferruccio Furlanetto as King Philip II in LA Opera's 2018 production of *Don Carlo*. Photo: Cory Weaver/LA Opera.</figcaption>
</figure>


### On a memorable emotional moment on stage

Porgy was a role I thought that I never would do, but I got an opportunity to sing it at La Scala. It was my first time. I have a love interest in that show and that's something I never have as a bass because we usually don't play those types of roles. 

I was able to work with Kristin Lewis, who to me is the most incredible Bess ever. Anytime I sing that role I want to sing it with her. She is a wonderful international soprano from Arkansas, but she lives in Austria and sings at the Vienna Staatsoper and other European opera houses. The emotional freedom and generosity she displayed really took me to another level. It allowed me to connect differently to this character. 

I play a lot of strong-willed characters and I was able to be just as strong willed but also vulnerable with my emotions. It was a wonderful experience professionally. I appreciated her professionalism and she helped me a lot. I enjoyed the level of commitment emotionally. I'm now trying to incorporate that into all my characterizations. That time I was able to really discover some new things and it was very rewarding. I'm looking forward to playing those types of characters even more now. 

### On next career steps

I'm singing a lot of the things that I always wanted to sing and I'm singing them in a lot of places. At this point, there are certain venues and houses where I would like to take what I already sing. That would help fulfill my sense of accomplishment if I could sing the roles I sing in LA, Houston, Dallas, and Philadelphia, at the Metropolitan Opera, at Covent Garden, and in La Scala, and Vienna.

I'm also being offered to sing the Wagner repertoire and I've stepped into that a little bit. I sing Fasolt in *Das Rheingold*, and I love that role because it is so Italianate but I'm not yet ready to delve deep into the Wagnerian repertoire. I may need a few more years. My calendar is now full all the way through 2020 and looking into 2021.

>For more with Morris Robinson, follow him on [Twitter](https://twitter.com/MorrisDRobinson) and [Facebook](https://www.facebook.com/Morris-Robinson-Bass-186893621369511/).
