+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = "2018-05-26T14:03:00-04:00"
lastmod = "2018-05-26T17:56:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527361948406/237edit.jpg.jpg"
primary_image_credit = "Arielle Doneson."
publishDate = "2018-05-26T17:56:00-04:00"
related_articles = ["articles/verdis-tragedy-in-jest.md","articles/michael-fabiano-the-profound-effect-of-artsmart.md","articles/talking-with-singers-adela-zaharia.md"]
related_companies = ["scene/companies/los-angeles-opera.md","scene/companies/royal-opera-house.md"]
related_people = ["scene/people/rolando-villazon.md"]
short_description = "&quot;We&#039;re in an era where things need to be tried. We can&#039;t just do the same. That&#039;s the argument against the model in America sometimes, where we just do traditional opera productions for the sake of doing them traditionally because no one wants to see anything different. That to me is not an acceptable answer.&quot;"
slug = "talking-with-singers-michael-fabiano"
title = "Talking with singers: Michael Fabiano"
+++

*[Michael Fabiano](/scene/people/michael-fabiano/) will be singing the Duke of Mantua in [Rigoletto at the LA Opera](/verdis-tragedy-in-jest/) in three performances from May 27 to June 3 in a production conducted by Matthew Aucoin.*

### On playing the Duke in *Rigoletto* in this #metoo moment 

We have to be clear that this is art and art is not reality. The title is hundreds of years old and the story is many hundreds of years old. 

Considering the year we're in, there are considerations artists can make in their performance that allow a character like the Duke to come alive without it becoming overzealous and overwrought with too much sexism, or something that destroys the intent of the character. 

It almost misses the point to suggest that there's a #metoo thing. The Duke often talks about the desire for love.  In his second act aria, "Parmi veder le lagrime",  there is nothing about abusing or taking advantage of women. It's quite the opposite. It gives the sense that he's lonely. Even in real life, when people are lonely, they play the field.

The Duke can be handled in a way that is not villainous but rather a guy that is just hungry for something that he doesn't have. He can be dark and he can definitely be over hungry, and that can make him dirty in a way. But I don't think calling him a villain is appropriate because he never kills anybody. In [the version here (at the LA Opera)](/verdis-tragedy-in-jest/), he never abuses anybody. There are other productions of *Rigoletto* that I've done where it's clear that the Duke has done treacherous things. 

It's a trap, in this day and ago, to make an artist answer for whether he or she should sing the Duke because it's someone counter to the #metoo movement, saying don't do the opera if you believe in #metoo. But we can adjust our ideals, be respectful of our environment, and still play the character by going for what matters. What matters is that this guy desires love. We go from there as the roots of the tree.

I've been in over 10 productions of *Rigoletto* and I've seen many ways of playing the Duke. I've had to play him as a drug addict where in every scene I was in I did a different drug, shooting up, snorting coke and getting high. There was everything that could make the Duke lascivious in some way. There are different ways to peel a potato. That was one way. Another way was [David McVicar's way](/the-price-of-vengeance-rigoletto-at-roh/) [at the Royal Opera House in December 2017 and January 2018], which was very dark and feudal, and very heavy and wrought with sex, lust and dirt. It was quite effective but there were moments in it I just didn't want to be part of considering the age and moment we're in. In this version, I'm never taking advantage of a woman on stage.

### On the [ArtSmart program](/michael-fabiano-the-profound-effect-of-artsmart/), of which Michael Fabiano is a founder, and which aims to offer quality music education to under-served students

We serve three schools right now and next year we're going to serve 12, a huge increase. It's quite an undertaking to be able to serve 200 children with free one-on-one voice lessons every single week of the school year. It's a big responsibility and we're delivering it. We're very proud of the success we've had so far.

Many of the mentors have effectively taken a child who was on the verge of dropping out of school. We were able to convince them to stay in school and to get their grade point average up. Our mentor would tell them if they are interested in a performing career, people would be less interested in a dropout. At the same time these kids have gained confidence. 

A mentor, Heather Phillips in Philadelphia, has noticed students in her studio that have taken huge leaps, have been cast in shows, and been accepted to universities when no one expected them to do so after one year of training. That's a testament to her diligence and hard work.

We're introducing operatic literature to these children. We start them off singing whatever they like but we train them classically. We're seeing that some of the kids are immediately becoming interested in opera when they didn't even know what it was about initially. 

We're in a world right now [in opera] where we should be additive and not multiplicative. We should be concerned about adding people who were not interested before to the base of citizens and patrons that love our art form and not about multiplying them. 

The kids from New Jersey went to see the Discovery Orchestra and heard some classical music and operatic literature, and then all the kids wanted to sing "O mio babbino caro" and similar arias. If you lead people to opera and show them what a wonderful thing it is, most people are going to see it's incredible. They never realized 80 instrument could sound that good together and a voice could sing over it. Instead they were used to hearing a piano and a woman with an airy voice at a microphone. When you shift their paradigm, the openness happens.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527362010899/222edit.jpg.jpg)
<figcaption>Michael Fabiano, tenor. Photo by Arielle Doneson.</figcaption>
</figure>

### On different ways of appreciating and thinking about opera

In China, opera is usually very appreciated. The phenomenon in China right now is that on date nights young people en masse are coming to large concert halls being built all over the country to watch Beethoven's 5th and Rachmaninoff's 3rd. It’s something they didn't have in the last generation, when their parents didn't talk about it because it was banned. Now that they have it, it's huge.

In Japan, and in South Korea in particular, there's also deep appreciation of cultural activities from the West. Those countries still buy records. They participate in going 100% full frontal in the arts.

Europe and America are a different paradigm. In Europe generally, the arts are state sponsored. Presenters can do whatever they want on stage and they're not held accountable, and I'm not saying this lightly. People in Europe don't have a board or private donors to respond to so they can be avant-garde and present whatever they would like. If they sell a theater only 25%, they're not going to be on the chopping block. Whereas if that happened in America, they know they would not be able to return to the theater. We are in a private sponsored world here. 

I don't want to render a judgment on [which way makes opera more accessible].  I've done some incredible productions in Europe produced by avant-garde directors and I've been in some terrible productions.

We're in an era where things need to be tried. We can't just do the same. That's the argument against the model in America sometimes, where we just do traditional opera productions for the sake of doing them traditionally because no one wants to see anything different. That to me is not an acceptable answer. People make the point that we haven't moved and evolved as a society, that we're going to lose audiences if we just do the same-old-same-old.  It's like with snail mail and email, or email vs other forms of communication. If you do it one way only, the base of people is going to stop using it. It's Marketing 101. It also applies to opera. 

There has to be a big change in mentality of what it means to present the work. I did a production of *Carmen* in Aix-en-Provence [in 2017] by Dmitri Tcherniakov where Don José was asked by his wife to go to a mental therapy center. The premise was that the couple was having emotional chaos and they were on the verge of divorce. The wife wants to get her husband more invigorated and have him love life more. The clinic is paid to teach emotion to this guy who lacks emotion. Over the course of the opera, we see a decline in this man's persona. Ultimately, he wants to kill Carmen violently because he's fallen in love with someone he can't have. Except at the end of the opera, Carmen doesn't die because he kills her with a blunt knife. The person who is ruined is not Don José but the woman who plays an actress playing Carmen because she realizes she was complicit in ruining a man's psychological health.

The young audience in Aix-en-Provence went bananas for it because they could relate to the personalities they were seeing on stage, people who are addicted to their phones and who are zonked out of life. They connected.

There are going to be other tries and some will work and others won't, but you have to give it a try. 

### On using social media and technology

If you don't use social media and technology now, you’re losing sight of the curve. It's a must.

I use it vociferously. I use Instagram. I post one-minute videos of myself. In Facebook Live videos I show people the back of the stage and the front of the stage. I show what it's like when I'm getting dressed, where I'm going, what I'm eating. People want to know and be part of the experience. It's reality TV. That's the new world we're in. While it's important to have the mystique people often talk about in opera, we're not in a year where it exists anymore and that's the reality the older generations have to accept, or they have to move on. We are in a period where the public needs, not just wants but needs, to be part of the process in order to want to pay to come. If we tell them no, they're not going to pay, which means we won't have opera. 

I don't accept the argument that artists just need to do their art and that's it. People can be multi-taskers and people can learn how to compartmentalize. I run an organization, I fly planes as a private pilot, and I have run other companies in my life. I do multiple things. To say I cannot dedicate an hour of my day to social media is just not acceptable in this world.

### On milestones and future roles

I don't think about milestones. I just think about what's in front of me. I've sung in the major theaters around the world except for Vienna and Munich and those debuts are coming. I think more in terms of artistry and not in terms of milestones. That would involve ego and I don't want to go there. 

I do however believe in planning and goal setting for roles that I would like to sing. *Un Ballo in Maschera* is one of those. It's coming very shortly, in two years, at the Metropolitan Opera. 

I used to think [about where my voice might be years from now] but in the last couple of years I've changed my mind because there are certain singers whose voices stay the same for very long periods of time. It's not that they don't have their technical challenges that may require retuning but they stay in the same repertory for their whole career. Alfredo Kraus only sang roughly 20 roles. He didn't veer outside of the lyric tenor role. I don't want to put barriers around whether I'll sing something 20 years or 10 years from now or not. I don't think it's responsible of me to do that.

>Michael Fabiano sings the Duke in LA Opera's production of [*Rigoletto*](https://www.laopera.org/season/1718-Season/rigoletto/) May 27-June 3. For details and tickets, [click here.](https://www.laopera.org/season/1718-Season/rigoletto/)
