+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-03-15T16:56:00+00:00"
lastmod = "2016-03-16T10:16:00+00:00"
preamble = "Next month, Canadian soprano [Meghan Lindsay](/scene/people/meghan-lindsay/) is heading back to a familiar stage: Toronto's Elgin Theatre, where [Opera Atelier](/scene/companies/opera-atelier/) houses its productions of early opera. Their upcoming production of [Mozart's *Lucio Silla*](http://operaatelier.com/season/15-16-season/lucio-silla-apr-7-16-2016/) comes to Canada for the first time, after going up at the [Salzburg Festival](/scene/companies/salzburg-festival/) and [Teatro alla Scala](/scene/companies/teatro-alla-scala/). With Kresimir Spicer in the title role, and stellar sopranos [Mireille Asselin](/scene/people/mireille-asselin/) and [Peggy Kriha Dye](/scene/people/peggy-kriha-dye/), Lindsay takes on Giunia, a role that's full of \"lots of high notes, lots of coloratura!\"\n\nWe chat with Lindsay about singing old operas, pre-performance yoga, and \"finding value between contracts.\""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458062919957/2016-03-12---Meghan-Lindsay.jpg.jpg"
primary_image_credit = "Photo by Jennifer Toole."
publishDate = "2016-03-16T08:00:00+00:00"
related_articles = ["articles/he-saidshe-said-alcina-at-opera-atelier.md","articles/mireille-asselins-phone-call-from-the-met.md"]
related_companies = ["scene/companies/opera-atelier.md"]
related_people = ["scene/people/meghan-lindsay.md","scene/people/peggy-kriha-dye.md","scene/people/mireille-asselin.md"]
short_description = "&quot;To me, the most rewarding thing about a singing career is the relationships you form. I love the fact that music is another language that we can explore and play with. I really enjoy practicing and find that part of the process very gratifying. There&#039;s something very meditative in doing something every day and knowing that each day, there are going to be different challenges and changes to my situation, in my voice, in my interactions.&quot;"
slug = "talking-with-singers-meghan-lindsay"
title = "Talking with singers: Meghan Lindsay"
+++

## What kind of person is Giunia? What have you discovered about her in Mozart’s music?

Giunia is a noble woman with a wild amount of resolve and strength. Her father is dead and her lover gone, leaving her alone to defend her dignity against Lucio Silla, one of Rome's most notorious dictators. She is fiercely loyal and I love that about her. She would choose death over a betrayal of her family and lover.

Giunia's writing is probably the most virtuosic writing for the voice that Mozart ever composed. He was only 17 when he composed *Lucio Silla*, and though he didn't yet have the finesse that he later acquired, you can hear the origin of many great operas in this music. There are many musical parallels to famous Mozart women: Donna Anna, Konstanze, Elettra. It's very dramatic writing, lots of high notes, lots of coloratura!

## Through your work with Opera Atelier, what do you think remains "relevant" or contemporary in these centuries-old operas?

This is an issue near and dear to my heart. I do a lot of volunteer music outreach between contracts and am often asked this. 

My answer is that opera isn't always relevant. Sometimes, if we seek to make something as exotic as opera relevant by finding parallels to modern life, we hit a wall. Instead, I choose to focus on how can we make our art more socially inclusive - more accessible and interesting to the community at large. Classical music becomes relevant to any given community by connection and communication. This connection can happen in so many different capacities - through a relation to the storyline, through the sheer experience of hearing live music, through a direct relationship with the performers. I believe that performers have a degree of creative responsibility when it comes to making our music relatable. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458061648558/2016-03-15---Alcina-Opera-Atelier-Zinger.jpg.jpg)
<figcaption>Meghan Lindsay in the title role of Opera Atelier's *Alcina*. Photo by Bruce Zinger.</figcaption>
</figure>

## What have you found are the most rewarding aspects of a singing career? What are the most difficult?

To me, the most rewarding thing about a singing career is the relationships you form. I love the fact that music is another language that we can explore and play with. I really enjoy practicing and find that part of the process very gratifying. There's something very meditative in doing something every day and knowing that each day, there are going to be different challenges and changes to my situation, in my voice, in my interactions.

I think there are the most common challenges - choosing how and when to navigate relationships and family, and finding a healthy balance between being home and being away. For me, the greatest difficulty lies in finding value between contracts. I think that is why I have devoted my 'off time' to community-minded ventures. 

## Do you have any "bucket list" roles you’d like to sing in your career (realistic or otherwise)?

I've been really lucky to have crossed many roles off of that list: Donna Anna and [Alcina](/he-saidshe-said-alcina-at-opera-atelier/) were dream roles that I recently had a chance to perform. I'm curious to explore some of the lesser known Rossini operas and *bel canto* roles. I would also love to sing Lucia and one day, Norma.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458061746261/2016-03-15---Lindsay---Freischutz---Zinger.jpg.jpg)
<figcaption>Meghan Lindsay as Agathe in Opera Atelier's production of *Der Freischütz*. Photo by Calum Agnew.</figcaption>
</figure>

## Do you have any pre-show rituals or routines?

Not really. I try to keep a performance day as similar as possible to any other day. Eat a lot, go for a walk, do some yoga, sing!

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/n3fO6oH9i4Y" frameborder="0" allowfullscreen></iframe>
</figure>

>Opera Atelier opens Lucio Silla at the Elgin Theatre on April 7th. For details and ticket information, follow our box office links below.
