+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2021-09-14T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For more with Matthew Anchel, follow him on [Instagram](https://www.instagram.com/matthewanchel/), [TikTok](https://www.tiktok.com/@matthewanchel?), or visit his [website](https://www.matthewanchel.com/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1631552282/media/2021/09/MatthewAnchel_dbliqr.jpg"
primary_image_credit = ""
related_articles = ["articles/talking-with-singers-othalie-graham.md", "articles/talking-with-singers-luca-pisaroni.md"]
related_companies = ["scene/companies/manhattan-school-of-music.md", "scene/companies/los-angeles-opera.md", "scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/matthew-anchel.md"]
short_description = "\"What I think happens a lot, is that you have people who are maybe more stereotypically attractive in thin bodies, who maybe have medium voices — not the best voices in the world.\" These singers are well promoted, Anchel says, and they get opportunities to work with opera's best. \"So they get really good at singing, even though maybe their voice isn't that amazing.\""
slug = "talking-with-singers-matthew-anchel"
title = "Talking with singers: Matthew Anchel"
youtube_url = ""

+++
By anyone's account, American bass [Matthew Anchel](/scene/people/matthew-anchel/) is having a stellar 2021-22. He's settling in for a New York-based season, a string of contracts with The Metropolitan Opera that include covering in [_Die Meistersinger von Nürnberg_](https://www.metopera.org/season/2021-22-season/die-meistersinger-von-nurnberg/) and [_Don Carlos_](https://www.metopera.org/season/2021-22-season/don-carlos/), and making his mainstage debut in Laurent Pelly's production of [_Cendrillon_](https://www.metopera.org/season/2021-22-season/cinderella/), sharing the stage with Isabel Leonard, Emily D'Angelo, and Stephanie Blythe.

"I love working at the Met so much," Anchel says. He acknowledges the more unsavory news stories about the Met, "But I have only ever been treated with professionalism and respect whenever I work there."

This season will be Anchel's Met debut, but not his first season spent at the company. Since 2013, he has covered bass roles in _Die Zauberflöte_, _The Exterminating Angel_, _Der Rosenkavalier_, and more. He even sang in the the Metropolitan Opera Children's Chorus at age 6. For Anchel, the Met is synonymous with opera's history, and should always be a place to put up works from the traditional canon.

> "It's really this most the most amazing feeling if you learn how to sing with ease."

"They have this enormous proscenium stage," Anchel says, contrasting the Met's output with the wave of small and scrappy opera companies, producing black-box-inspired chamber opera. "I think it's important that if we're going to keep doing this art form, there are institutions that do opera the way it was meant to be done."

It struck me in our most recent conversation, that Anchel has one of the healthiest relationships with his singing that I've observed in a professional singer. His devotion to the art form is clear, even hereditary, if we point out that he was born and raised in Manhattan's Upper West Side, to two opera singer parents, Julia Heyer and David Anchel.

And it's not just nature, but lots of nurture. Anchel's path is almost classic: a performing arts high school, the Manhattan School of Music, LA Opera's Domingo-Thornton Young Artist Program, the Metropolitan Opera National Council Auditions, and private lessons with Trish McCaffrey. As a result, he's arrived, prepared, at that crucial moment of a 30-something bass's career where the instrument catches up to the demands of opera's most coveted low-voice roles.

And for all his skill and operatic pedigree, Anchel has that thing that evades so many professional singers: balance. If you surveyed a slice of his social media following — either  the 16,000 people who follow him on [Instagram](https://www.instagram.com/matthewanchel/), or better yet, his 831,000 followers on [TikTok](https://www.tiktok.com/@matthewanchel?) — the majority would likely vouch for Anchel's sound advice as their ["TikTok Gay Best Friend"](https://www.instagram.com/reel/CRg-9FZHSMb/?utm_source=ig_web_copy_link). Dating woes, [makeup queries](https://www.instagram.com/reel/CQrCBy2HS6V/?utm_source=ig_web_copy_link), and certainly some [miniature singing lessons](https://www.instagram.com/reel/CSZ-3WtHtg0/?utm_source=ig_web_copy_link) — Anchel has the time and expertise for all of it, and has even picked up a solid line-up of students through his online presence.

<figure data-type="image">{{% md %}}<blockquote class="instagram-media" data-instgrm-captioned data-instgrm-permalink="https://www.instagram.com/reel/CSUgv1GnOmh/?utm_source=ig_embed&utm_campaign=loading" data-instgrm-version="13" style=" background:#FFF; border:0; border-radius:3px; box-shadow:0 0 1px 0 rgba(0,0,0,0.5),0 1px 10px 0 rgba(0,0,0,0.15); margin: 1px; max-width:540px; min-width:326px; padding:0; width:99.375%; width:-webkit-calc(100% - 2px); width:calc(100% - 2px);"><div style="padding:16px;"> <a href="https://www.instagram.com/reel/CSUgv1GnOmh/?utm_source=ig_embed&utm_campaign=loading" style=" background:#FFFFFF; line-height:0; padding:0 0; text-align:center; text-decoration:none; width:100%;" target="_blank"> <div style=" display: flex; flex-direction: row; align-items: center;"> <div style="background-color: #F4F4F4; border-radius: 50%; flex-grow: 0; height: 40px; margin-right: 14px; width: 40px;"></div> <div style="display: flex; flex-direction: column; flex-grow: 1; justify-content: center;"> <div style=" background-color: #F4F4F4; border-radius: 4px; flex-grow: 0; height: 14px; margin-bottom: 6px; width: 100px;"></div> <div style=" background-color: #F4F4F4; border-radius: 4px; flex-grow: 0; height: 14px; width: 60px;"></div></div></div><div style="padding: 19% 0;"></div> <div style="display:block; height:50px; margin:0 auto 12px; width:50px;"><svg width="50px" height="50px" viewBox="0 0 60 60" version="1.1" xmlns="https://www.w3.org/2000/svg" xmlns:xlink="https://www.w3.org/1999/xlink"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g transform="translate(-511.000000, -20.000000)" fill="#000000"><g><path d="M556.869,30.41 C554.814,30.41 553.148,32.076 553.148,34.131 C553.148,36.186 554.814,37.852 556.869,37.852 C558.924,37.852 560.59,36.186 560.59,34.131 C560.59,32.076 558.924,30.41 556.869,30.41 M541,60.657 C535.114,60.657 530.342,55.887 530.342,50 C530.342,44.114 535.114,39.342 541,39.342 C546.887,39.342 551.658,44.114 551.658,50 C551.658,55.887 546.887,60.657 541,60.657 M541,33.886 C532.1,33.886 524.886,41.1 524.886,50 C524.886,58.899 532.1,66.113 541,66.113 C549.9,66.113 557.115,58.899 557.115,50 C557.115,41.1 549.9,33.886 541,33.886 M565.378,62.101 C565.244,65.022 564.756,66.606 564.346,67.663 C563.803,69.06 563.154,70.057 562.106,71.106 C561.058,72.155 560.06,72.803 558.662,73.347 C557.607,73.757 556.021,74.244 553.102,74.378 C549.944,74.521 548.997,74.552 541,74.552 C533.003,74.552 532.056,74.521 528.898,74.378 C525.979,74.244 524.393,73.757 523.338,73.347 C521.94,72.803 520.942,72.155 519.894,71.106 C518.846,70.057 518.197,69.06 517.654,67.663 C517.244,66.606 516.755,65.022 516.623,62.101 C516.479,58.943 516.448,57.996 516.448,50 C516.448,42.003 516.479,41.056 516.623,37.899 C516.755,34.978 517.244,33.391 517.654,32.338 C518.197,30.938 518.846,29.942 519.894,28.894 C520.942,27.846 521.94,27.196 523.338,26.654 C524.393,26.244 525.979,25.756 528.898,25.623 C532.057,25.479 533.004,25.448 541,25.448 C548.997,25.448 549.943,25.479 553.102,25.623 C556.021,25.756 557.607,26.244 558.662,26.654 C560.06,27.196 561.058,27.846 562.106,28.894 C563.154,29.942 563.803,30.938 564.346,32.338 C564.756,33.391 565.244,34.978 565.378,37.899 C565.522,41.056 565.552,42.003 565.552,50 C565.552,57.996 565.522,58.943 565.378,62.101 M570.82,37.631 C570.674,34.438 570.167,32.258 569.425,30.349 C568.659,28.377 567.633,26.702 565.965,25.035 C564.297,23.368 562.623,22.342 560.652,21.575 C558.743,20.834 556.562,20.326 553.369,20.18 C550.169,20.033 549.148,20 541,20 C532.853,20 531.831,20.033 528.631,20.18 C525.438,20.326 523.257,20.834 521.349,21.575 C519.376,22.342 517.703,23.368 516.035,25.035 C514.368,26.702 513.342,28.377 512.574,30.349 C511.834,32.258 511.326,34.438 511.181,37.631 C511.035,40.831 511,41.851 511,50 C511,58.147 511.035,59.17 511.181,62.369 C511.326,65.562 511.834,67.743 512.574,69.651 C513.342,71.625 514.368,73.296 516.035,74.965 C517.703,76.634 519.376,77.658 521.349,78.425 C523.257,79.167 525.438,79.673 528.631,79.82 C531.831,79.965 532.853,80.001 541,80.001 C549.148,80.001 550.169,79.965 553.369,79.82 C556.562,79.673 558.743,79.167 560.652,78.425 C562.623,77.658 564.297,76.634 565.965,74.965 C567.633,73.296 568.659,71.625 569.425,69.651 C570.167,67.743 570.674,65.562 570.82,62.369 C570.966,59.17 571,58.147 571,50 C571,41.851 570.966,40.831 570.82,37.631"></path></g></g></g></svg></div><div style="padding-top: 8px;"> <div style=" color:#3897f0; font-family:Arial,sans-serif; font-size:14px; font-style:normal; font-weight:550; line-height:18px;"> View this post on Instagram</div></div><div style="padding: 12.5% 0;"></div> <div style="display: flex; flex-direction: row; margin-bottom: 14px; align-items: center;"><div> <div style="background-color: #F4F4F4; border-radius: 50%; height: 12.5px; width: 12.5px; transform: translateX(0px) translateY(7px);"></div> <div style="background-color: #F4F4F4; height: 12.5px; transform: rotate(-45deg) translateX(3px) translateY(1px); width: 12.5px; flex-grow: 0; margin-right: 14px; margin-left: 2px;"></div> <div style="background-color: #F4F4F4; border-radius: 50%; height: 12.5px; width: 12.5px; transform: translateX(9px) translateY(-18px);"></div></div><div style="margin-left: 8px;"> <div style=" background-color: #F4F4F4; border-radius: 50%; flex-grow: 0; height: 20px; width: 20px;"></div> <div style=" width: 0; height: 0; border-top: 2px solid transparent; border-left: 6px solid #f4f4f4; border-bottom: 2px solid transparent; transform: translateX(16px) translateY(-4px) rotate(30deg)"></div></div><div style="margin-left: auto;"> <div style=" width: 0px; border-top: 8px solid #F4F4F4; border-right: 8px solid transparent; transform: translateY(16px);"></div> <div style=" background-color: #F4F4F4; flex-grow: 0; height: 12px; width: 16px; transform: translateY(-4px);"></div> <div style=" width: 0; height: 0; border-top: 8px solid #F4F4F4; border-left: 8px solid transparent; transform: translateY(-4px) translateX(8px);"></div></div></div> <div style="display: flex; flex-direction: column; flex-grow: 1; justify-content: center; margin-bottom: 24px;"> <div style=" background-color: #F4F4F4; border-radius: 4px; flex-grow: 0; height: 14px; margin-bottom: 6px; width: 224px;"></div> <div style=" background-color: #F4F4F4; border-radius: 4px; flex-grow: 0; height: 14px; width: 144px;"></div></div></a><p style=" color:#c9c8cd; font-family:Arial,sans-serif; font-size:14px; line-height:17px; margin-bottom:0; margin-top:8px; overflow:hidden; padding:8px 0 7px; text-align:center; text-overflow:ellipsis; white-space:nowrap;"><a href="https://www.instagram.com/reel/CSUgv1GnOmh/?utm_source=ig_embed&utm_campaign=loading" style=" color:#c9c8cd; font-family:Arial,sans-serif; font-size:14px; font-style:normal; font-weight:normal; li_7px; text-decoration:none;" target="blank">A post shared by M A T T H E W A N C H E L (@matthewanchel)</a></p></div></blockquote> <script async src="//www.instagram.com/embed.js"></script>

{{% /md %}}

</figure>

But the source of it all — be it Anchel's impressive social media output, or his first-rate singing — lies in body positivity.

"I really try not to be insulting," Anchel laughs, pointing out the irony of his YouTube series, [_Angry Fat People_](https://www.youtube.com/watch?v=YkK1yfGGja4), which he started in 2018 with his friend and fellow singer, Tracy Cox. "I try to be as sympathetic as possible, so that someone who might be triggered by some of the things that I'm talking about can actually just listen and not just instantly turn off."

Within the opera world, the idea of _prima la voce_ comes up against the same problem that has, until extremely recently, plagued the more mainstream performing arts: only thin bodies can be used to tell stories. And as a devourer of his content myself, I can say that Anchel's take on body positivity is equal parts awesome-bear-hug and thought-provoking-lightbulb-moment.

"What I think happens a lot, is that you have people who are maybe more stereotypically attractive in thin bodies, who maybe have medium voices — not the best voices in the world." These singers are well promoted, Anchel says, and they get opportunities to work with opera's best. "So they get really good at singing, even though maybe their voice isn't that amazing."

"Then, you have fat singers, who maybe have these unbelievable voices, and never get better at singing, because they're not given the opportunities that the thin person was given to improve, and then become, you know, this amazing artist."

<figure data-type="video">{{% md %}}<iframe width="1010" height="568" src="https://www.youtube.com/embed/nWwdpsPakd0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>

It all reminds me of that other big conversation that surrounds the classical performing arts, about privilege. It takes a certain kind of exposure (read: good schools with music program, parents with an interest in classical music) and money (read: private lessons with the best teachers) to appreciate opera, let alone pursue it professionally. And it's sad to consider that even among the thousands of incredible singers out there, we're only able to hear from those who have cleared those early hurdles.

"I think that opera is like, probably 10 to 20 years behind everything," Anchel says. "It's so funny that opera still stuck in like the early 2000s, where was like I think was sort of the height of sort of like, you know, blonde, good looking thin people. And then the culture has changed a little, and opera is just always a little bit behind. So, hopefully it catches up and then appreciates the diverse community it has and features them in shows."

He may be amused at opera's cultural lag, but for Anchel, singing is one of life's great pleasures. "When you're doing it, well, it feels good," he says. "It's addictive, you love the vibration in your body. You love like the release of it, it's really this most the most amazing feeling if you learn how to sing with ease."

<figure data-type="video">{{% md %}}<iframe width="1010" height="567" src="https://www.youtube.com/embed/IguNgVATlW0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>

A self-proclaimed overthinker, Anchel's onstage psychology is well-honed and drama-free. His go-to image is a big barrel (his sound) and a tiny bird sitting on said barrel (his text). "I always try and bring like two ideas onstage with me," Anchel says, preferring these days to think of singing dark, and forward. "For whatever reason that was working for me because the darkness kept me from spreading. And the forward it wasn't that I was singing in my nose. It was that the foreword energy of like, say the words, don't be in your head, don't place, don't like try and create a sound."

And a bit like that balance he strikes between singing, teaching, and TikTok-ing, Anchel responds most to voices that gather together all of life's extremes. Good singing, he says, is "Dark and bright, released and held, open and closed, and deep and high. I think when a singer finds the balance of all those things, it's really exciting."

During the pandemic, Anchel had a revelation about leading roles — an evasive thing for many basses — and what's on his wish list of characters to perform in his career. With his friends, Anchel did dramatic Zoom readings "of all the things I ever wanted to do." Blanche in _A Streetcar Named Desire_, Cleopatra in _Caesar and Cleopatra_, Eleanor of Aquitaine in _The Lion in Winter_, all the goodies.

"What I learned," he says of his foray into leading-lady-land, "is playing roles like that is really hard. I was so exhausted by the end of that reading."

Now, answering my question about his bucket-list roles to sing, Anchel has new criteria. "Dream roles now — which is so silly — would be to play a deliciously campy villain on a sci-fi show. I just think that would be the most fun thing ever."

> "Women in my life have always supported me... and I feel like I'm there for them."

Anchel strikes me as a singer who gets it. He gets the work required to step anywhere near the Met stage, gets the Game of Donors, gets the niche place opera has in the mainstream world. And as a result, he fits the bill of a modern opera singer: an unquestionable instrument, a balanced professional life, and a hunger to use his notoriety to put good back into the world.

"I think on TikTok, 95% of my followers are women, which is crazy when you think that's like probably 700,000 or so people," Anchel muses. "Women in my life have always supported me. And I think the women that follow me, a lot of them are people who are want a connection, like a friendship connection, and I feel like I'm there for them."

And I'm here for him, in this clip of him singing Banquo's aria from Verdi's _Macbeth_:

<figure data-type="video">{{% md %}}<iframe width="932" height="523" src="https://www.youtube.com/embed/LZ_m1ox0kes" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>