+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-11-12T14:31:00+00:00"
lastmod = "2016-11-14T09:36:00+00:00"
preamble = "Italian baritone Massimo Cavalletti has sung on virtually every major stage from New York to Dubai, yet his roots lie in the real heart of Italian opera. Like Giacomo Puccini, Cavalletti was born in Lucca, Italy, and the beginnings of his professional career were in Milan, in the Academy at La Scala.\n\nThis month, he returns to The Metropolitan Opera to sing in Franco Zeffirelli's iconic production of *La bohème*, opposite Kristine Opolais as Mimì, and Piotr Beczala as Rodolfo; Cavalletti has sung both Marcello and Schaunard at the Met, and this run of performances includes his 100th as Marcello.\n\nCavalletti gave us a thoughtful interview about his relationships with his teachers, his audiences, and his heritage."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478961209132/2016-11-12---Massimo-Cavalletti.jpg.jpg"
publishDate = "2016-11-14T09:07:00+00:00"
related_articles = ["articles/talking-with-singers-daniel-okulitch.md","articles/barihunks-jack-michaels-we-are-in-a-golden-age-of-baritones.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/massimo-cavalletti.md"]
short_description = "&quot;I am also happy to come from a family of farmers, from the land that has given and still gives me my cultural and historical roots as well as an attachment to the values of family, homeland and faith, which in many cases are at the foundation of opera itself.&quot;"
slug = "talking-with-singers-massimo-cavalletti"
title = "Talking with singers: Massimo Cavalletti"
+++

## What sort of history do you have with *La bohème* in your own career so far?

*La bohème*! It's basically been my life so far. I made my Teatro alla Scala debut as Schaunard in 2005 working with Maestro Franco Zeffirelli; being the youngest member in the cast, I was afraid I wouldn't be up to their level and I was very nervous. I remember I worked intensely with Marco Gandini to prepare my character before the Maestro's arrival, and I kept repeating my Act I entrance when Schaunard comes in the attic with money and food. 

Then the day came when we actually rehearsed on stage at the presence of the Maestro. I was very anxious and jumpy; I saw him as soon as I opened the door, threw the coins on the table and started to sing. After a couple of phrases he stood up, interrupted the rehearsal, came towards me and said: "I was told that the Schaunard is a very young man, and that I should be indulgent with him because he is at his very first stage experience... well, I am telling you now: don't think about anything, just sing and let us enjoy this beautiful voice of yours!"

I remember I got so touched by this gesture and from that moment on it was a piece of cake. He autographed my score of *Bohème* that I still use; since then I have sung over 130 performances of the opera as Schaunard and Marcello. I have plenty of anecdotes about *Bohème*, but my first time at La Scala, working with a living legend of international theatre, is one memory which will always remain in my heart.

## What was it like to study and begin your career in major historical opera centers like Milan and Lucca?

I am fortunate to have been born in the birthplace of great composers such as Puccini, Catalani, Boccherini. Lucca has always been a cradle of culture, music and art. I studied there for three years and then I found myself in a big city, Milan, which gave me the opportunity to perfect my training thanks to my admission to the Teatro alla Scala Academy, and to make my first experiences in what is undoubtedly the opera house par excellence. 

I was lucky to have studied with outstanding teachers who passed on to me their experience and helped me to be a real artist. I'd like to mention above all Luciana Serra, with whom I studied at the Academy and who still teaches me to this day. Also, Leyla Gencer, who has a special place in my heart for her great passion and love for opera and dedication to young singers, to whom she gave all of herself like a mother. In my life I have met many other great teachers and singers, and I have always tried to capture some of their art. I have certainly had opportunities that perhaps other young singers were not given, but I made important decisions when I chose to be a Fest artist in Zurich, and gradually grew step by step in the study of my roles.

It is very fortunate to have been born and and able to study in Italy, where one inhales the history of opera. As an Italian I can thoroughly and consciously appreciate the growth process of operatic writing, the Italian language and tradition. 

I am also happy to come from a family of farmers, from the land that has given and still gives me my cultural and historical roots as well as an attachment to the values of family, homeland and faith, which in many cases are at the foundation of opera itself.

## What do you find is unique about Italian opera audiences?

Italian audiences have always been and still are the most critical and reactive in the world. When you sing in an Italian opera house, whether it is one of the most prestigious or a regional one, it's easy to stumble upon harsh critics that are deeply tied to the operatic tradition of that particular theatre. There still are numerous opera-goers who started to attend performances in the '50s, and this gives them the opportunity to make comparisons between opera how it is today and how it was yesterday. Those who crowd the "loggione" (gallery, or stalls) are usually cultured people who do not give their judgment as a gut reaction, but truly listen to the quality of the performance. There are however cases where they get carried away by their emotions during a performance that they don't consider up to their standards, but in 90% of cases they judge according to the tradition of that particular opera house.

Even the audiences of smaller regional houses and local musical associations always have a well-defined idea regarding singing, or how a specific opera should be sung, and they don't shy away from criticizing or simply abstaining from clapping. However, I would like to add that a success in Italy feels bigger than anywhere else because to pass unscathed or even better  be applauded in Milan, Naples, Venice, Turin, Palermo, Florence or Rome is a sign of true unequivocal success.

## Based on your own experience, how would you compare audiences in Europe versus in Asia?

Asian, and particularly Japanese audiences have a high respect for artists. They know everything about the singers performing in their theatres, follow them as it used to happen in Europe or America in the 1960s through the 1980s, know their voices and own complete collections of their performances. They love CDs and DVDs and show a lot of enthusiasm for live performances. 

I've never heard any criticism or any booing in Japan. The Japanese always clap but reserve ovations only on those who they believe they are truly worthy of them, and they are thrilled when they attend performances of European or American guest artists. 

China has beautiful theatres and great productions, but they have not yet fully formed an idea of what Western opera truly is. In any case there are a lot of opera-goers and big financiers and sponsors, which will certainly lead to a nationalization of opera. 

I've not yet been to South Korea, but considering the vast flow of Korean singers and musicians I believe that opera and music must play a very important role in their lives. 

The Middle East is experiencing the birth of opera. There are new opera houses in the countries of the Arabian peninsula, and I have sung in Muscat and Dubai. There, the audience knows opera very well, as they mostly come from Europe or America where they have learned to love opera, know when and where to applaud and have already formed their own taste and never openly criticize an artist. 

When you sing in Asia the atmosphere is more relaxed and serene, and the audience makes one feel at ease behaving as if they were "the fourth wall" of the stage, so that the show breathes together with them and you can smell the excitement in the air.

## What do you wish you knew about singing 10 years ago?

Thank you for asking this question. I can say that things have changed in ten years: changes that in the past took a whole generation to happen, now take ten years or less. Now social media and platforms as well as globalization have sped up everything to the extreme. Distances have been eliminated and at the same time have become impossible to fill. 

Today, the tendency is to start from the top tier opera companies in major roles. If they don't work their way up the ladder through professional work in small houses or smaller roles, many young artists shoot to fame very quickly, only to find it hard to remain at the top.

Sometimes careers are over in the blink of an eye, and this happens because this "market" is always full of alternative options, constantly looking for the new "One". Excluding those artists who have reached maturity and fame and continue their career following the old time-honored rules, the market is always clamoring for a new name rather than the quality and experience of artists who have been working hard and built their careers over the years.

## Why do you sing professionally?

I am fortunate to have been singing at a professional level for over ten years, and each and every day I work hard to improve my singing and keep up my professional reputation. Singing must have a well-grounded base of work and study. Superficiality is unacceptable: in order to sing opera at a high level, intense concentration - as well as devoting your life to your voice and work - is crucial.

When I was 15, or even 20, I would have never in my wildest dreams imagined I would have been in this fantastic profession and that I would be going around the world trying to touch people with my voice. But even since I discovered my voice, I've always tried to reach into people's hearts, and I think I am successful at it because I have a large following both in the opera houses and on the social platforms. They care for me and support me with their friendship.

So much has changed today: appearance and the ability to sell tickets become much more important and, without generalizations, are often favoured over the vocal quality of an artist. But I always strive to satisfy my own artistic needs, and to educate new generations to recognize what is "beautiful" in life, and to pursue the cultural interests which morally elevate mankind. I would never be able to be a classical singer without this message in my heart.
