+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-19T14:33:00+01:00"
lastmod = "2016-10-22T09:36:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477049283442/2016-10-21---Marina-Rebeka-Janis-Deinats.jpg.jpg"
primary_image_credit = "Photo by Jãnis Deinats."
publishDate = "2016-10-21T13:00:00+01:00"
related_articles = ["articles/spotlight-on-amanda-majeski.md","articles/talking-with-singers-nicole-cabell.md","articles/talking-with-singers-christine-goerke.md","articles/talking-with-singers-daniela-mack.md","articles/talking-with-singers-jnai-bridges.md","articles/talking-with-singers-anna-caterina-antonacci.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/marina-rebeka.md"]
short_description = "Though the Metropolitan Opera is no small test of a singer&#039;s nerves, Rebeka found singing in her home town of Riga to be a daunting task. &quot;The feeling with singing at home was always very complicated,&quot; she says. Rebeka&#039;s professional career began in Germany, and when she sang at home, the pressure to prove herself seemed great. &quot;Singing for family and friends, on one hand, it&#039;s great; on the other hand, it&#039;s like, &#039;OK, let&#039;s see what she has learned abroad.&#039;&quot;"
slug = "talking-with-singers-marina-rebeka"
title = "Talking with singers: Marina Rebeka"
+++

"It's a different feeling," says Latvian soprano Marina Rebeka, of her return to the Metropolitan Opera. "It's much more calm, much more on the ground."

Rebeka is in the middle of a run of Rossini's [*Guillaume Tell*](http://www.metopera.org/Season/2016-17-Season/guillaume-tell-rossini-tickets/) at the Met, where she sings the role of Mathilde. The production by Pierre Audi is the same in which she made her role debut in Amsterdam in 2013. Still, Rebeka took advantage of the month-long rehearsal process in New York. "I knew the production already, but it was important because I got this chemistry with my colleagues." Onstage chemistry, plus the spatial differences between the stages in Amsterdam and New York ("The stage is smaller in the Met," Rebeka adds), add enough novelty to keep her on her toes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477049328154/2016-10-21---Marina-Rebeka-backstage-as-Mathilde.jpg.jpg)
<figcaption>Marina Rebeka backstage as Mathilde. Photo by Catherine Pisaroni.</figcaption>
</figure>

"It's really a big house. Everything is happening there, lots of celebrities," says Rebeka of working at the Met. Her debut at the company was as Donna Anna in *Don Giovanni*, with a stellar cast that included Ramón Vargas, Mariusz Kwiecień, [Luca Pisaroni](/talking-with-singers-luca-pisaroni/), and Barbara Frittoli. "The first time is always very emotional," Rebeka recalls of her first musical rehearsal, amid star singers at an historical opera house. "I was almost trembling, it was so emotional, such a big responsibility."

Though the Metropolitan Opera is no small test of a singer's nerves, Rebeka found singing in her home town of Riga to be a daunting task. "The feeling with singing at home was always very complicated," she says. Rebeka's professional career began in Germany, and when she sang at home, the pressure to prove herself seemed great. "Singing for family and friends, on one hand, it's great; on the other hand, it's like, 'OK, let's see what she has learned abroad.'"

Now, Rebeka finds that the hometown stress has eased. "This feeling changed, and now I really love singing there," she says. This season, she makes two role debuts in Riga, first as Maria Stuarda, and then as Marguerite in *Faust*. In recent years, Rebeka has become a recognizeable name in Riga. She notes that Latvian people have a subtler way of showing their fandom, but it's no less welcome. "They wish you health, they wish you success. You feel constantly that people follow you, that people like you."

## "It's a good way to switch off your head."

For most singers, working at home is a rare luxury, and Rebeka has learned to carve out a routine wherever she goes, to keep herself physically and mentally healthy. "The tricky thing is the airplane, obviously," she says. "Especially if you travel from US to Europe and back." Rebeka makes use of common singer tricks, like tea with ginger, lemon water, essential oils, and steaming. "I don't like taking too much medicine, because I think the body should have its own defenses."

Since she rarely sleeps on planes, Rebeka uses the travel time to study for upcoming roles. Often, she's months ahead of schedule with her studying. "I study it and I pull it apart, and I forget about it, kind of." When she returns to the score nearer to her deadline, she finds that the role often settles into her mind, subconsciously. "I don't know how to explain it, it's kind of cooking in me," she laughs.

Like many singers, Rebeka knows the value of exercise, yet she's no gym rat. In New York, she takes walks in the rare pockets of green space ("'Fresh air' could be considered Central Park."), and she loves to dance. "Dance, for me, is much better than a gym," she says. "I use my time, when I am in the US, to go to the [Fred Astaire Dance Studio](https://www.fredastaire.com/) at 72nd and Broadway." The break from opera, Rebeka finds, is great for her body and her soul. "You cannot think about singing or whatever, because you are busy thinking about your body," she says. "It's a good way to switch off your head."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477049383563/2016-10-21---2-Marina-Rebeka-Janis-Deinats.jpg.jpg)
<figcaption>Photo by Jãnis Deinats.</figcaption>
</figure>

## "Love at first sound."

When Rebeka was thirteen, her grandfather introduced her to opera. "I said, 'what is opera?' and he said, 'you're going to see.'" Together, they saw Bellini's *Norma*; "At the first break, I said, 'I want to sing this, and I want to be an opera singer!'"

Rebeka describes it as "love at first sound," and a feeling of "magic" that started strong at a young age, without ever really fading. "It's something inside which makes you so excited," she says. That excitement has remained since Rebeka's transition from listener to singer. Her Italian debut was as Norma in Trieste, the same theatre in which Callas famously sang the notorious *bel canto* role. Beginning with the awe of hearing Bellini's iconic Norma, "after 23 years, I did it."

Of course, it's a simplified version of Rebeka's tough road between studying voice, and beginning her professional career. One of the largest hurdles was the struggle to find an agent. "That's one of the reasons why really great singers, really great voices, who are finished their studies, they cannot get onstage." Rebeka made good impressions in her own auditions, yet opera houses were unwilling to hire her without representation, and ironically, without enough professional experience.

"Everybody treats you as a beginner," she says. Jobs are scarce and underpaid, and companies often take advantage of the eagerness in young, aspiring opera singers. "The beginning of the career is really, really stressful, and not everybody can get through it."

A good mix of realistic thinking and optimistic drive is what Rebeka advises for young, aspiring singers. That, and taking care of one's body. "Take care of your knees," she says, somewhat surprisingly. "Especially if you are doing soprano rep, where you have to faint," she explains, citing roles like Lucia di Lammermoor and Violetta in *La traviata* as common culprits. "You have to be rally careful about yoru knees. There may be falls which are not good for your meniscus."

"Save your knees, and save your voice. And save your nerves," she laughs.

## "You should be able to give more."

"Before I was singing, I was working as an interpreter," says Rebeka, who speaks five languages. If she didn't sing for a living, she's confident she could put her skills in communication and organization to good use. An expert on looking for travel deals and decent accommodation, arts administration is an avenue that holds some interest for her. 

And like many working singers, the idea of teaching isn't far from Rebeka's mind. She sees teaching as a great responsibility, and she insists that she'd do her homework before allowing young singers to trust her with their voices. "I'm a very big perfectionist, I would need to go through all the styles," she says. Everything, from language skills to the stylistic differences between singing Bach and singing Puccini, falls under the duties of a good teacher. Of course, technique is always important, but Rebeka feels that, "you should be able to give more."

Giving more applies to Rebeka's career as a performer, too. "It's not just about earning money and doing your job well," she says. "If it were about that, I would just sing *Traviata* and Donna Anna, and that's it."

"There are much more interesting, difficult things to face, where you grow as an artist, and a singer, and as an actor."

>[Guillaume Tell](http://www.metopera.org/Season/2016-17-Season/guillaume-tell-rossini-tickets/) runs at the Metropolitan Opera until November 12. For more with Marina Rebeka, [follow her on Twitter.](https://twitter.com/marinarebeka)
