+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-04-12T00:18:00+01:00"
lastmod = "2016-10-07T14:57:00+01:00"
preamble = "<p>\n\tCanadian soprano <a href=\"http://luciacesaroni.com/index.html\" target=\"_blank\">Lucia Cesaroni</a> is one of my favourite singers to hear, and she happens to be equally delightful offstage as well as on. She was even nice enough to give me a heartfelt and honest interview about her life as a singer. She talks about connecting with different types of artists, learning to be her own producer, and about how she found out that singing was just the thing for her.\n</p>"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428794013158/Lucia-Photo-by-Kelly-Semkiw-1-1_Fotor.jpg.jpg"
primary_image_credit = "Kelly Semkiw"
publishDate = "2015-02-16T14:18:00+00:00"
related_articles = ["articles/cesaroni-isis-osiris-new-opera.md","articles/in-review-isis-and-osiris.md"]
related_companies = ["scene/companies/pacific-opera-victoria.md"]
related_people = ["scene/people/lucia-cesaroni.md"]
short_description = "Canadian soprano Lucia Cesaroni is one of my favourite singers to hear, and she happens to be equally delightful offstage as well as on. She was even nice enough to give me a heartfelt and honest interview about her life as a singer. She talks about connecting with different types of artists, learning to be her own producer, and about how she found out that singing was just the thing for her. "
slug = "talking-with-singers-lucia-cesaroni"
title = "Talking with Singers: Lucia Cesaroni"
+++

<h2>Why do you sing?</h2>
<p>
	I think a big part of the reason I sing is because of my dad's history with singing. He came to Canada as a young, 16-year old Italian immigrant post-war, and ended up taking singing lessons (he had a beautiful tenor voice), with Dr. Vinci, who was also Mary Morrison's teacher, and Lois Marshall's teacher, and Jon Vickers' teacher.
</p>
<p>
	He and my mom used to always go to the opera, and the symphony and the ballet. They took me to <em>Tosca</em> when I was 8, which they later admitted may have been a little much for an 8-year old, what with the murder, the suicide, the jumping off of buildings, and love affairs. But I was addicted from then on.
</p>
<p>
	I think it started with a love of the theatre more than the music, and that led me into singing. It started with this imaginary play-acting world that I was so enamoured of. I think it grew into a love of theatre and a love of exploring other people, the world from different points of view, especially through the amazing women characters I get to play. Now, at 31, I sing because it feels really good. A lot of the times it's that simple, I'm happy to say. I will always love the theatrical, larger-than-life aspect of it, but it's so gratifying when it's going well, and a note feels like it has infinite potential. That reverberation, physically, emotionally, spiritually, is what keeps me coming back every day, I guess.
</p>
<p>
	Often the people who are coming to the opera for the first time, my friends who I drag but then they love it, I ask what their impressions were, and so much of what I enjoy is someone describing the power that opera can have, and just the power of the human voice, acoustically, can have on someone. And someone who may not have the vocabulary to explain specifically what they mean, they're always able to convey how meaningful it is and how individually it touches them. And that's so cool.
</p>
<h2>What do you call good singing?</h2>
<p>
	Good singing to me is well-executed, free, <em>bel canto</em> technique. In my experience, that is what matters to me the most.
</p>
<p>
	So that means a sustainable healthy way of singing that follows what the body naturally wants to do, and creates the possibility for stamina and a sustained career arc. More specifically, I talked earlier of a note can have infinite potential, so when I feel I am singing well, or, sometimes, more surprisingly, wonderfully, when I'm in an opera and I can see that it's going well for the singer, I know that they have the ability to improvise, to really express whatever organic impetus may come to them, because their mechanism is free and open, and able to in a split second adjust to their emotional need and their dramatic impulse. The voice is free to respond.
</p>
<p>
	There's a sense that that vibration has the ability to open and relax, and allow the audience to feel and experience what that sound, not just the scene and the costumes and the dramatic situation, but that sound makes them feel things too. That's good singing.
</p>
<p>
	<br>
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428794158343/Photo-by-Kelly-Semkiw-1_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/oGZeVuq97tFch0O1ZNN7aurgAEFTBLU1itZN-MIFarz_25We18HYUDpHpWY1viQyamfCnTWKSAHnqVv7WnnHPfll9LM" src="http://lh3.googleusercontent.com/oGZeVuq97tFch0O1ZNN7aurgAEFTBLU1itZN-MIFarz_25We18HYUDpHpWY1viQyamfCnTWKSAHnqVv7WnnHPfll9LM=s1200"></a><figcaption>Photo: Kelly Semkiw</figcaption></figure>
<h2>What do you wish you knew about singing 10 years ago?</h2>
<p>
	It takes longer than you think. It's a slow, often unrewarding process. Whatever that end point is, short-term or long-term, it requires a lot of alone time, actually. I remember in undergrad thinking "Oh those poor pianists and violinists, they have to sit in those practice rooms for 6 hours a day." And of course physically a singer can't do that, you'll hemorrhage.
</p>
<p>
	It takes longer. Patience: everybody tells you "patience", now I understand why. It takes a long time for your voice to start maturing and start doing what you <em>know</em> is in there.
</p>
<p>
	I would want myself to know that you need a really good support system. I'm very fortunate to have that. It's so important in a business that requires that you constantly put yourself up for rejection. Academically, you think you understand that, as a 20-year old, but now, you understand by experience. Having that support system has been invaluable, and so important. A lot of my friends have no interest in the opera world whatsoever, and I think that's actually really healthy. I would tell myself, make sure you have lots of different kinds of friends, singers, non-singers, instrumentalists, accountants, whatever. But then I'd also tell myself to marry a singer, which I will do in a few months!
</p>
<h2>What's it like "crossing over" from the opera world into other genres?</h2>
<p>
	I think with regard to my varied experience, the most fun I've ever had onstage was in <em>West Side Story</em>. I would love to to more of that, I guess we're calling it "legit musical", stuff. I learned really what it is that musical theatre actors, dancers, singers, do every day, and it's astounding. We are such sad little delicate flowers of opera singers, you know, when you see what they're capable of. They're there earlier than everybody, and they leave later than everybody else. I grew as a performer because of that experience, and watching them and their commitment to not only their dancing and singing, but their acting. "can we try this again", and they would improv, sort of, not that they would exactly leave the script, but they would really do the scene differently the second time. That kind of freedom was really inspiring to see, and it's actually inspired me to want to work with dancers.
</p>
<p>
	One of my other projects that's made me grow as an artist has been working with The In-Set. It's Jennifer Nichols, and Justin Di Bernardi, and Tyler Gledhill, and Adrian [Kramer], and myself, and Maika'i Nash as our pianist. We really are inspired by how dance can serve to underscore and highlight emotional highs and lows in vocal music, that perhaps an opera singers, with the demands of our vocal repertoire, can't always do. Bring a new emotional colour or idea that's difficult to express, maybe, with the voice always. Dancers try stuff all the time. "I don't know, let's just try it", and it's definitely loosened me up, and it's been fun.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428794198846/Lucia-Maria-in-West-Side-Story-with-Vancouver-Opera-3_Fotor-697x1024.jpg"><img data-resize-src="http://lh3.googleusercontent.com/zhz1naQcalKvksYS0hA4btiLE0nYPamksEQbOHHkKW8v6DVhtDuFU9duffcrWx0fnKRuRMfWvbBroSBTVBdRNtGTPr8" src="http://lh3.googleusercontent.com/zhz1naQcalKvksYS0hA4btiLE0nYPamksEQbOHHkKW8v6DVhtDuFU9duffcrWx0fnKRuRMfWvbBroSBTVBdRNtGTPr8=s1200"></a><figcaption>Lucia Cesaroni (Maria) and Colin Ainsworth (Tony) in Vancouver Opera's <em>West Side Story</em>, 2011.</figcaption></figure>
<h2>What have you learned on the job that you didn't learn in school?</h2>
<p>
	Learning how to produce a concert or a series, etc., is a whole other thing. I think that conservatories and music schools, universities, in whatever guise, do amazing work and I had an excellent experience. But I think there are a few areas that now aren't being taught, that need to be taught, that are maybe only recently relevant. And I think first and foremost is how to be your own producer: how to market the series, how to brand yourself, how to collaborate and network with artists.
</p>
<p>
	We're put in these streams in school, so you hardly ever see instrumentalists, or the jazz musicians, you know, even those we're in the same building all the time. That's what I've learned, how great it is to be able to genre-bend, and start looking at, whether it's musical theatre or jazz or dance, especially modern dance, I think, works so well with the recital format.
</p>
<p>
	So I think young musicians really need those skills. I didn't learn it until this point in my career, and I'm glad I did. But I think a course to that effect would be so valuable to young singers.
</p>
<p>
	I wonder what would happen if from 18 years old that seed is planted, and a whole generation of musicians from that age see how possible that is, and in fact, how necessary that is.
</p>
<h2>What would you do if you didn't sing professionally?</h2>
<p>
	I didn't sing for a year. So, I tried doing other things. I was a fundraiser, I worked in Development with the National Ballet, I worked in PR for a couple of a different organizations, the Toronto Summer Music Festival was one of them.
</p>
<p>
	I learned a lot about a lot of different things. I wouldn't do anything else, because I did do other things. I am a singer. Re-choosing it, re-affirming why I want to sing and be a part of this industry was the best decision I've ever made. It's way more fun now, after having lived in other sectors, and experienced day-to-day what that would be like. If you'd asked me a few years ago I would have said, "Oh, I don't know, probably PR, maybe fundraising."
</p>
<p>
	Now, it's singing all the way.
</p>
