+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-03-10T15:52:00+00:00"
lastmod = "2016-03-14T09:48:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457626705916/2016-03-10---Pisaroni.jpg.jpg"
primary_image_credit = "Photo: Catherine Pisaroni."
publishDate = "2016-03-14T09:15:00+00:00"
related_articles = ["articles/talking-with-singers-nicole-cabell.md","articles/talking-with-singers-othalie-graham.md","articles/talking-with-singers-christian-van-horn.md","articles/talking-with-singers-corinne-winters.md","articles/in-review-maometto-ii.md","articles/what-weve-learned-by-talking-with-108-opera-singers.md","articles/talking-with-singers-lise-lindstrom.md","articles/talking-with-singers-russell-thomas.md","articles/talking-with-singers-keri-alkema.md","articles/sidney-outlaw-stairs-success.md","articles/talking-with-singers-eleazar-rodriguez.md","articles/talking-with-singers-christian-bowers.md","articles/talking-with-singers-brian-jagde.md","articles/talking-with-singers-elza-van-den-heever.md","articles/talking-with-singers-george-gagnidze.md","articles/barihunks-jack-michaels-we-are-in-a-golden-age-of-baritones.md","articles/talking-with-singers-scott-hendricks.md","articles/talking-with-singers-angela-gheorghiu.md","articles/talking-with-singers-robin-johannsen.md","articles/talking-with-singers-anna-caterina-antonacci.md","articles/talking-with-singers-zachary-nelson.md","articles/talking-with-singers-giles-tomkins.md","articles/spotlight-on-iain-macneil.md","articles/talking-with-singers-andrea-care.md","articles/talking-with-singers-neil-craighead.md","articles/talking-with-singers-thomas-hampson.md"]
related_companies = ["scene/companies/the-santa-fe-opera.md","scene/companies/the-metropolitan-opera.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/luca-pisaroni.md"]
short_description = "Pisaroni is quick to note that, &quot;all operas are difficult to cast.&quot; Still, the coloratura bass-baritone Maometto is a notable departure from Rossini&#039;s fast-moving mezzos and tenors. &quot;I could lie to you and say &#039;oh yeah, I love it, it&#039;s easy&#039;,&quot; he laughs. &quot;It&#039;s very difficult because it requires everything from you. There are low notes, high notes, coloratura, long phrases, legato, it&#039;s really challenging, all of it.&quot;"
slug = "talking-with-singers-luca-pisaroni"
title = "Talking with singers: Luca Pisaroni"
+++

Italian bass-baritone Luca Pisaroni knows how to make the most of three days off. After finishing a performance of *Le nozze di Figaro* at The Metropolitan Opera, he grabbed a few hours worth of sleep, and hopped on a plane with his wife, Catherine, and their two dogs, Tristan and Lenny (after Bernstein, of course), for some much-needed rest in Miami. He had been battling an annoying cold for a few weeks, yet he hasn't missed a show. "You know, I'm a bass-baritone, I'd rather die than cancel," he quips.

Mozart's Conte Almaviva is one of Pisaroni's signature characters, and soon he'll head to the Canadian Opera Company to perform what has become another notable title role, in Rossini's opera seria *Maometto II*. David Alden's production of this lesser-known work went to [Santa Fe](/scene/companies/santa-fe-opera/) in 2012, "and it was the highlight of the summer".

"I saw it for the first time, *Maometto*, in 1994," says Pisaroni. "I saw it at La Scala with Sam Ramey, and I remember I fell in love with the role immediately." In North America, non-comedic Rossini operas are decidedly rare. "Sometimes you wonder if theatres should be more courageous," he muses. "Instead of giving the usual suspects, you know, to try something else, because you can never know what people like and what they don't."

The piece is likely not easy to cast, the first of several challenges being the search for a bass-baritone who can sing this tough role. Pisaroni is quick to note that, "all operas are difficult to cast." Still, the coloratura bass-baritone Maometto is a notable departure from Rossini's fast-moving mezzos and tenors. "I could lie to you and say 'oh yeah, I love it, it's easy'," he laughs. "It's very difficult because it requires everything from you. There are low notes, high notes, coloratura, long phrases, legato, it's really challenging, all of it."

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457795718518/2016-03-12---Maometto-1.jpg.jpg)<figcaption>Luca Pisaroni as Maometto II. Photo from *Maometto II* (Sante Fe Opera, 2012) by Ken Howard.</figcaption>
</figure>

Pisaroni loves a challenge, and Maometto is a role that draws on his experience singing Baroque opera and *bel canto*, yet with all of its influences, Rossini's opera is unique. "When you sing *bel canto*, there is no coloratura; there are these long phrases, legato. When you do Baroque, there is never any legato, at all. So it's something in between that requires both."

Obscure Rossini aside, there's a degree of rarity when it comes to a bass-baritone voice with the ability to move. Pisaroni agrees, and finds some explanation in the common expectations of low male voices. "When you are a bass, bass-baritone, people are expecting a certain sound, a certain kind of singing," he says. A rich, booming sound is a must-have for a bass-baritone in a leading role, yet many of the characters they play are older men, villains, personalities that don't often warrant coloratura. 

"Throughout history, the voice of the bass has to be this dark sound, and this powerful sound. You cannot have both," insists Pisaroni. "You cannot have this incredible, powerful sound, this incredible legato, and then ask somebody to do coloratura; it's just physically impossible." The balancing act is a tricky one, yet Pisaroni focuses on the simplest solution, and that's keeping his voice malleable and healthy. "I always thought I wanted to keep my voice as young, as fresh as I can," adding that he considers it a great compliment when someone notices youth and agility in his sound. 

Pisaroni dismisses the idea that singers are born with the gift of coloratura, making it easy for him to get practical about developing this kind of "niche" technique. 

"[Coloratura] is something that I always wanted to have, and I worked on it."

## On the road

With an enviably busy singing career comes the less enviable task of balancing the present with the future. "I always say being a singer is kind of like suffering from a split personality, because you're actually performing a role, while you're learning something completely different." Pisaroni has a handful of performances left in New York, and between shows and quick trips to Miami, he's constantly looking ahead. "While you're performing, the next day after the show, you're probably looking at a score of something completely different, that maybe is a completely different style."

On top of revisiting *Maometto II*, he heads to [Los Angeles](http://www.laphil.com/tickets/mozart-part-requiem-miserere/2016-05-19) to sing in Arvo Pärt's *Miserere*, with Gustavo Dudamel and the LA Philharmonic, and he sings his first Méphistophélès in Gounod's *Faust* at Houston Grand Opera in October.

Pisaroni echoes a common sentiment among working opera singers. "I believe that being an opera singer, the voice counts for only 20%. And then there is 80% that is discipline; there is imagination, personality, charisma, so many things that have nothing to do with the voice. One of these is really being able to balance the preparation. It's tough, it's really tough."

He hates to show up ill-prepared for a gig, so he finds himself a support system wherever he works. "It happened only once that I didn't know three pages of an act, and I felt so embarrassed that I said to myself, 'this will never happen again'. So I tend to prepare things very much in advance." Pisaroni has a voice teacher that he trusts, "but I'm unable to see her as much as I would like to, because I don't have the luxury to take a month off and go and prepare every time."

"So, I have incredibly good coaches. In New York I have people I work with, with Toronto the head coach of *Maometto* is somebody I know, and I'll work on something else." It's not about recruiting help to learn his music, but it's about having an objective set of ears in the practice room. "I always say to young singers, you need somebody to listen to you because what you hear of your own voice is not what the public hears. You need somebody from the outside who judges if it's good or not."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457795889082/2016-03-12---Luca-Dogs.jpg.jpg)<figcaption>Luca Pisaroni with rapt audience Tristan and Lenny.</figcaption>
</figure>

## "The Dog-Walker"

Of course, an on-the-road routine isn't just about finding time to practice. "The only routine that I have is that I'm a slave to my dogs," laughs Pisaroni. He's "not a morning bird at all", but he always makes time to walk Lenny and Tristan (so named "because he was quiet until he was a few months old, and then he started barking at everything that moved, and so we definitely said he's a tenor, but with a personality as huge as his, he must be a Wagnerian one."). 

"I need half an hour to realize I'm alive," [*cue the sympathetic laugh between interviewer and interviewee*] "and take the time to get from the bed to the kitchen where I can prepare my espresso. After that I need to walk the dogs, and it takes almost an hour." There's another walk after rehearsal, and yet another after Pisaroni puts in some practice time. "I'm a slave, you know."

Lenny and Tristan  travel with him all the time, much to the delight of his colleagues. "The best is when I can actually take them to the opera house." We wondered if he had asked the Canadian Opera Company about bringing his canine companions to the Four Seasons Centre, and Pisaroni is hopeful. "They are very quiet, and they stay in my dressing room," he vouches. "They love the dressers, the make up artists, they love being around people. When I sang in Chicago they came, and everybody loved having them around. I would come in the stage door, Lenny would make the rounds to every dressing room, saying hi to everybody. It's really fun."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457795803732/2016-03-12---Lenny-Tristan.jpg.jpg)<figcaption>l-r: Lenny and Tristan. Photo by Catherine Pisaroni.</figcaption>
</figure>

## The big question

Singing professionally is one of those careers that comes with a lot of conscious choices; there's no simple answer to the question, "why do it?", and Pisaroni agrees. "It's difficult to explain and yet it's very simple. I sing because for me, singing is like talking for everyone else. I could not imagine myself without being able to sing."

He calls it "this incredibly twisted thing about my personality", the fact that he's a shy, but can't get enough of being onstage. He admits that the life of a singer is challenging at times, and the audience only sees the final result. Still, "all the hard work and all the failure are completely forgotten when you go onstage. You do something, and you hear that you connect with the audience for a moment; it's an amazing feeling."

"When people say, 'is opera relevant?' I say, 'hell yeah it is.'" Pisaroni was an "opera nerd" even before he became a singer, but he insists that opera requires no homework or experience for a listener to be amazed. "You don't have to know anything about this art form to be touched, mesmerized, and wowed by it, absolutely not. You just need to be open, to be amazed."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457795758829/2016-03-12---Maometto-2.jpg.jpg)<figcaption>Luca Pisaroni as Maometto II. Photo from *Maometto II* (Sante Fe Opera, 2012) by Ken Howard.</figcaption>
</figure>

"There's nothing more rewarding than doing something funny onstage and have 3000 people laugh," he says, with a smile in his voice. "That's like a drug for me."

We asked him, does it ever become simply another day at work? "I could never see this as a job, never. It's a calling, not a job. Even the day that I have a cold, and the last thing I want to do is perform, the moment I'm onstage, I say, 'this is the best thing ever, and I'm so happy I'm here'."

>Maometto II runs at the Canadian Opera Company's Four Seasons Centre April 29 to May 14. For details and ticket information, follow our box office links below.
