+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-08-20T18:44:00+01:00"
lastmod = "2016-08-22T09:42:00+01:00"
preamble = "American soprano Lise Lindstrom spends her time onstage with some of opera's most extraordinary women, like Turandot, Salome, Elektra, and Brünnhilde. Her 2016/17 season is no different, starting with *Turandot* in September at the [Wiener Staatsoper](http://www.wiener-staatsoper.at/Content.Node/home/spielplan/Spielplandetail.en.php?eventid=963266177), followed by a [*Ring Cycle* at Opera Australia](https://opera.org.au/melbourne/ring-cycle) in November.\n\nWe spoke with Lindstrom about the enviable roles she sings, and how she stays healthy enough for a *Ring Cycle* on the road."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471715184961/2016-08-21---Lise-Lindstrom.jpg.jpg"
primary_image_credit = "Photo: Lisa-Marie Mazzucco."
publishDate = "2016-08-22T09:42:00+01:00"
related_articles = ["articles/talking-with-singers-christine-goerke.md","articles/talking-with-singers-othalie-graham.md","articles/talking-with-singers-luca-pisaroni.md"]
related_companies = ["scene/companies/wiener-staatsoper.md","scene/companies/opera-australia.md"]
related_people = ["scene/people/lise-lindstrom.md"]
short_description = "&quot;I sing because I couldn&#039;t NOT sing.  There was nothing else I was particularly good at or interested in, so thank heaven it worked out!  I am truly an artist at heart, and the joy I feel when being able to express myself through my voice is absolutely unparalleled.&quot;"
slug = "talking-with-singers-lise-lindstrom"
title = "Talking with singers: Lise Lindstrom"
+++

## Your current roles are full of headstrong women - do you have any of these roles with which you have a particular connection?

Not only do I feel hugely grateful to sing these amazing, headstrong women - but outside of their murderous intentions, I manage to deeply connect to each of them.  At this moment, I am preparing Brünnhilde, and therefore I feel a particular affinity for her and her journey.

## How would you describe the difference in singing a role like Turandot, compared to Elektra, Brünnhilde, and Salome?

All of these roles have different temperaments, and therefore require different body and mental energy.  

Turandot is an aggressive sprint of a role - but in Italian, so attention must be paid to the art of *bel canto* and Puccini's intention of her vocal lines.  There is real beauty in Turandot, but is it a lyric role?  Absolutely not.  But if the singer isn't comfortable with the tessitura and aggressive nature of the role, it is a killer.  

Salome is a spoiled, willful, and seductive young woman so her physical and vocal energy is quite different from the cold Turandot. Additionally, I typically do the Dance of the Seven Veils, which makes the stamina issue of Salome something to take into consideration.  Salome never leaves the stage, sings and acts all night, does a taxing 11 minute dance, and then sings the final 25 minutes of the opera which are the most vocally demanding.  

Elektra is another nonstop, powerful sing that is relentless from the beginning until the end as well.  However, with Elektra, the singer must have the ability to be sweet and beautiful 3/4 of the way through the opera.  And of course, still maintain enough physical energy to soar over the huge orchestra to the end.  

Brünnhilde is the more lyric of all of these roles.  The *Ring* operas are long, no doubt, but Wagner's pacing of stage time is brilliant.  Her character is also the most human, so her emotional/philosophical journey is potentially the most complicated and fulfilling.  Basically, the *Ring Cycle* is Shakespeare set to music.  All of these roles require pacing, and knowledge of one's instrument and body in order to manage the huge demands.

## Are there any roles that you've not yet sung that are on your wish list?

I am dying to sing Isolde and Fanciulla. Fingers crossed!!! :-)

## How do you maintain your routine and health while you're on the road so much? What advice do you have for aspiring singers about this part of the career?

Being on the road is a *whole* other thing for us - and mostly it's trial and error.  Some people bring their families, dog, or friend along to keep them company as this life can be extraordinarily lonely and isolating.  I don't.  I travel by myself and just try to build friendships along the way. 

There just isn't a "one size fits all" method of coping.  I try to eat healthily on the road and off, get plenty of sleep and exercise, and do things that make me happy outside of work and rehearsals.  Luckily, I travel to amazing places and therefore I never run out of things to see and do.  And of course, a good night in watching Netflix isn't so bad either.  

My advice is talk to other singers, see how they handle it and try for yourself.  It's tricky, and lots of people run into trouble trying to cope on the road.  

## Why do you sing for a living?

I sing because I couldn't NOT sing.  There was nothing else I was particularly good at or interested in, so thank heaven it worked out!  I am truly an artist at heart, and the joy I feel when being able to express myself through my voice is absolutely unparalleled.  

I love the environment of collaboration, and I love the challenges of the work.  It's a 24/7 kind of lifestyle full of a myriad of challenges, but I can't imagine anything else more fulfilling.

>For more with Lise, follow her on [Twitter](https://twitter.com/liselindstrom), and catch the [live stream of her Turandot](http://www.staatsoperlive.com/en/live/353/turandot-2016-09-04/#tab_0), September 4 at Wiener Staatsoper 7pm.
