+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-10-16T20:47:00-04:00"
lastmod = "2018-10-17T12:28:00-04:00"
preamble = "Hungarian baritone [Levente Molnár](/scene/people/levente-molnar/) is joining the Hungarian State Opera as it makes its U.S. debut at Lincoln Center's Koch Theater, October 30 to November 11. The HSO will present four operas by Hungarian composers, including Ferenc Erkel's *Bánk bán*, in which Molnár will sing the title role.\n\nErkel, the 19th-century composer, conductor, pianist, and past Music Director of the Hungarian State Opera, is dubbed the \"father of Hungarian grand opera\". His *Bánk bán*, considered a national opera of Hungary, is certainly obscure in North America; the HSO's current production by Attila Vidnyánszky will mark an important introduction of the opera to American audiences.\n\nWe spoke with Molnár about the intense character of Bánk bán, and the significance of bringing a major piece of his Hungarian culture across the Atlantic."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539789158851/sqmolnar_levente.jpg.jpg"
primary_image_credit = "Levente Molnár, baritone."
publishDate = "2018-10-17T11:29:00-04:00"
related_articles = ["articles/talking-with-singers-matthew-polenzani.md", "articles/talking-with-singers-gyula-nagy.md"]
related_people = ["scene/people/levente-molnar.md"]
short_description = "&quot;I have learnt a lot but there is still a lot to learn. The most important thing I&#039;ve learned is that the calling is not only about professionalism and talent. Many other factors also play a role in the career of a professional singer, some of which might be harmful to the art itself.&quot;"
slug = "talking-with-singers-levente-molnár"
title = "Talking with singers: Levente Molnár"

+++
### Why do you sing, particularly in the field of opera?

First and foremost, because of a love for the art form. When a person doesn't really love opera, I always feel that they don't know the genre well enough, and just haven't yet found what will give them a real cathartic experience. I didn't use to know opera either until a lovely teacher of mine got me acquainted with it. For this I am eternally grateful to her. I already had a good singing voice as a child and took part in folk song competitions. I loved singing; it gave me something other subjects like the sciences never could. Singing connected me to the world and to God. It gave me a certainty, an answer to the question of who I am, where my path lies in this vast forest of life where we have to make choices every single second.

## What kind of person is Bánk bán?

Bánk, first of all, is a man of strength and character. These are his most important attributes and what allow him to come across as a heroic figure. At the same time, he is a victim, just like in a Greek tragedy. He is trapped by enormous feelings that no man could bear. The love for his homeland and the sanctity of the family… the destruction of these sacred things force him to constantly choose. He is faced with dilemmas that are unknown to ordinary people, who only experience them through this tragic hero - watching aghast as they imagine what they would do in his place. He is a character of deep integrity, the kind of person we all hope we are or at least strive to be.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539789177647/bank_ban1_photo_by_attila_nagy.jpg.jpg)
<figcaption>
Levente Molnár in the title role of *Bánk bán*, Hungarian State Opera. Photo: Attila Nagy.</figcaption>
</figure>

### Why do you think Erkel's works are not well-known in North America? How does it feel to bring *Bánk bán* to the U.S. where this opera is virtually unknown?

To expand on what I said before, about needing the right knowledge and a moving experience to fall in love with opera, our job as artists is to make it known and give the opportunity for such an experience. While there are distinctly Hungarian aspects to *Bánk bán*, these are elevated to a universal dimension just like in Greek or Shakespearean tragedies. The emotional intensity, the sense of destiny, the attachment to home… it's all important and universal, such that this music can be touching to everyone. The story is richly written, exploring many different emotional levels with clear characterization; we as artists only have to convey them; this is our task. Now we are taking an important step in bringing *Bánk bán* to a wider audience. It's an honor to be able to bring to the U.S. this opera that has become so emblematic - like a monument - in Hungary.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539789187593/bank_ban2_photo_by_attila_nagy.jpg.jpg)
<figcaption>
Levente Molnár in the title role of *Bánk bán*, Hungarian State Opera. Photo: Attila Nagy.</figcaption>
</figure>

### What do Hungarian audiences value in opera? How does it differ from the Italian, German, or American traditions?

That's difficult to answer and not something I've really thought about yet. I think that the level of audience engagement from the performer's standpoint can vary as much as the quality of different productions varies from the audience's point of view. Perhaps the freshness and unfamiliarity of *Bánk bán* in the U.S. will make the story, as it unfolds on the stage, especially gripping to American audiences. However, I have also experienced very sincere, touching reactions at home. I love my audiences, and I love to be loved. It's very nice when such a relationship can blossom, and I don't wish to offend anyone by making distinctions. I only hope we can make American audiences love this production of *Bánk bán*, our national opera that is so important to us. This tragedy - our tragedy - deserves to be known by the whole world, and it's one way that we as Hungarians can show the place and relevance of our culture nowadays, our history and our calling.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539789196086/bank_ban4_photo_by_attila_nagy.jpg.jpg)
<figcaption>
Levente Molnár in the title role of *Bánk bán*, Hungarian State Opera. Photo: Attila Nagy.</figcaption>
</figure>

### What do you know now about the singing career that you wish you knew 10 years ago?

I have learnt a lot but there is still a lot to learn. The most important thing I've learned is that the calling is not only about professionalism and talent. Many other factors also play a role in the career of a professional singer, some of which might be harmful to the art itself. Ten years ago I used to think that the sanctity of art guides everyone. Now I know it is true only for a few. I wish I had known that earlier. I could have chosen projects and collaborators more from the heart than from the brain.

>For a full line-up of Hungarian State Opera and Hungarian National Ballet at Lincoln Center, October 30-November 11, [click here.](https://davidhkochtheater.com/Season-Tickets/18-19-Season/Hungarian-State-Opera-New-York-tour-2018)