+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-05-23T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "[_Don Carlo_](https://grangeparkopera.co.uk/whats-on/don-carlo/), starring Leonardo Capalbo in the title role, runs at Grange Park Opera from 6- June to 9 July."
preamble = "Italian-American tenor Leonardo Capalbo is in an enviable spot, as a tenor in demand for roles like Duca (_Rigoletto_), Alfredo (_La traviata_), and Rodolfo (_La bohème_). Next month, he steps into the title role in Verdi's [_Don Carlo_](https://grangeparkopera.co.uk/whats-on/don-carlo/) in Jo Davies' production at Grange Park Opera.\n\nCapalbo spoke with us about his ongoing love affair with singing, and how he uses varied repertoire to keep him in top vocal shape."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1558633515/media/2019/05/sqLeonardoCapalbo.jpg"
primary_image_credit = ""
related_articles = ["articles/talking-with-singers-matthew-polenzani.md", "articles/talking-with-singers-lucas-meachem.md", "articles/talking-with-singers-christopher-purves.md"]
related_companies = ["scene/companies/grange-park-opera.md"]
related_people = []
short_description = "\"I will not play Carlo as a wounded bird. He may lament the many things which he has lost in life, but his cries are not in vain.\""
slug = "talking-with-singers-leonardo-capalbo"
title = "Talking with singers: Leonardo Capalbo"
youtube_url = ""

+++
## Why do you sing professionally?

Singing and I have had an epic and ongoing love affair for years. I am deeply committed to the success of our relationship!

In all seriousness, those of us who make professional careers are very fortunate. We are obliged to continue the detailed cultivation of our skills so that we remain viable. I wholeheartedly love to make music. I cherish the moments I spend on the stage.

Singing can be a form of sorcery when you get it right. Why wouldn't I chase after magic?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558633577/media/2019/05/2756ashm_241LEONARDOCAPALBOASISMAELE-ROH.jpg){{% /md %}}

<figcaption>Leonardo Capalbo as Ismaele in Nabucco, ROH. Photo: Catherine Ashmore.</figcaption>

</figure>

## What kind of a man is Verdi's Don Carlo?

Don Carlo is a Byronic man in an otherwise sterile and stoic universe. The path towards his emergence as a man of stability, purpose and duty is littered with grief and tribulation. Shortly before meeting his end, Carlo realizes the potential for inner greatness that others had seen within him. His only true friend, Rodrigo, had counseled him to fight for the Flemish uprising and to become the benevolent ruler of Spain that his own father Filippo had not been.

Elisabetta is ultimately able to admire Carlo as well as love him. In the last scene of Schiller's play, Carlo explains to Elizabeth, "One rapid night has winged the tardy progress of my years and prematurely ripened me to manhood." He is finally able to release his grip from hers and say farewell only because he has come to understand that his life's purpose is to redeem his people and lead them forward. Yes, he suffers, but through decisive action Don Carlo develops into something bigger than he would have imagined for himself.

I will not play Carlo as a wounded bird. He may lament the many things which he has lost in life, but his cries are not in vain. He is very realistically depicted as a man who is coming of age. Don Carlo is not a victim. He is beautifully human.

>"The seemingly diverse roles work to enhance each other."

Verdi's musical adaptation of the Schiller drama is respectful and thoughtfully composed. The vocal writing vacillates between music of a nostalgic or dreamlike quality and ferociously dramatic declarations. Carlo's music is a raw and honest account of the progress of a reluctant hero. I'm interested in building a vocal and theatrical interpretation of Verdi's Don Carlo that uses the gorgeous long melodic phrases to resonate as purposeful strategic planning rather than self indulgent despair.

It is important to me to find the way in which to make the large vocal leaps, for example, have emotional impact and thrust, as dictated by Verdi, but to also use them to drive the narrative forward. This monumental score must be respectfully delivered to ensure that we hear the inner psychology that Verdi has written for each of these characters. This turbulent, complex and intensely emotional story is his own, but doesn't take away from the psychological and emotional development of the man himself.

## How have you maintained your technical comfort with roles like Alfredo and Duca, while taking on heavier work like Don Carlo?

It has been essential for me to maintain and strengthen my technique which is based in a bel canto tradition. In this way, the seemingly diverse roles work to enhance each other. I have discovered that by releasing my voice with greater efficiency, it has taken on far more size and power, but also facility in the upper register. 

The increased _squillo_ in my voice has coincided with an overall darkening of my sound. It seems almost paradoxical to describe it, but in practice there truly is a synergy; like one hand washing the other. 

>"Carlo's music is a raw and honest account of the progress of a reluctant hero."

I think it shows that there is not one technique for one kind of repertoire and a separate technique for another. There is just a single technique that allows any voice to reach its maximum potential. 

So I will continue to sing the lyric parts mixed in with the _lirico spinto_ parts. I have several more Ducas next season interspersed with more Don Carlos, Don José and Osaka in Mascagni's _Iris_. I will continue to sing the higher lyric parts which require dexterity because it only helps me to sing the more dramatic roles with greater ease. I look forward to adding to my repertoire.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558633664/media/2019/05/LaBoheme_Baden-Baden_2017.jpg){{% /md %}}

<figcaption>Leonardo Capalbo as Rodolfo with Zarina Abaeva as Mimì in La bohème, Festspielhaus Baden-Baden. Photo: Andrea Kremper.</figcaption>

</figure>

## What singers do you admire? How much do you aim to emulate their technique?

I love voices that have power and poetry. I hear something important in the singers of several generations ago like Enrico Caruso, Giacomo Lauri-Volpi and Beniamino Gigli. They had individuality, a strong connection to the lightest edge of their voices as well as the ability to unleash heroic tones of generous proportions. Flexibility was a fundamental component of their singing. 

>"But remember: do not rely solely on talent to see you through. The onus is always upon the artist to deliver."

These tenors were not influenced by recorded sound as we are in the contemporary world. I think this has led to a predominance of compressed sounds in singing. I don't think placement as a technical device is healthy or helpful. I believe in releasing the voice through coordination of breath pressure and airflow in balance with the proper muscles throughout your body. 

Each of the singers I named sang roles of a much wider range than is common now. They used their voices with great tonal variety and attention to detail. They sang with honesty. These are the qualities of their singing that I emulate in my own.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558633786/media/2019/05/LeonardoCapalboasCavaradossiandKellyKaduceasToscainToscaatMinnesotaOpera.jpg){{% /md %}}

<figcaption>Leonardo Capalbo as Cavaradossi with Kelly Kaduce as Tosca in Tosca, Minnesota Opera. Photo: Dan Norman.</figcaption>

</figure>

## What do you know now about the singing career that you wish you knew 10 years ago?

You have to humbly be the captain of your own ship by never allowing others to control your future. Stay focused on your own personal goals. Don't wait for things to happen, but actively and systematically create your ideal future. Be your own advocate. Show people what you want, what you can do, and what you want to be. But remember: do not rely solely on talent to see you through. The onus is always upon the artist to deliver.

## If you didn't sing for a living, what would you do instead?

If I didn't sing and act (I do not believe in separating the two), I would likely have become a lawyer. Arguing a case in court is a theatrical performance after-all. I would have done well in that arena. 

In addition to performing, I'd like to begin to direct opera and theatre. I have plenty of imagination and I'm not afraid to take a stand on an issue (another useful tool for a lawyer). 

Collaborating with other artists and moving them towards my artistic vision could prove fruitful for me and maybe them too. Ultimately, the audience will be the judge.