+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-01-04T17:02:00-05:00"
lastmod = "2016-01-05T10:39:00-05:00"
preamble = "American soprano [Leah Crocetto](/scene/people/leah-crocetto/) is a Cardiff BBC Singer of the World (2011), a Metropolitan Opera National Council Audition Grand Finals Winner (2010), a former Adler fellow at San Francisco Opera, and this season, she made her [Metropolitan Opera](/scene/companies/the-metropolitan-opera/) debut as Liù in Franco Zeffirelli's iconic production of *Turandot*. In the spring, she heads to the [Canadian Opera Company](/scene/companies/canadian-opera-company/) to sing Anna in Rossini's *Maometto II*, a role she's reprising in David Alden's production, originally at [Santa Fe Opera in 2012](http://www.nytimes.com/2012/07/31/arts/music/a-rossini-masterwork-ahead-of-its-time.html).\n\nBetween performances of *Turandot*, Leah Crocetto took the time to chat about singing Rossini, traveling a whole lot, and how all the hard work pays off."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451944928176/2016-01-05---Leah-Crocetto.jpg.jpg"
primary_image_credit = "Photo: Fay Fox"
publishDate = "2016-01-05T09:00:00-05:00"
related_articles = ["articles/talking-with-singers-nicole-cabell.md","articles/talking-with-singers-othalie-graham.md","articles/paul-appleby-telling-stories-at-wigmore-hall.md","articles/talking-with-singers-anna-devin.md","articles/in-review-maometto-ii.md","articles/talking-with-singers-brian-jagde.md","articles/talking-with-singers-ekaterina-semenchuk.md","articles/talking-with-singers-anna-caterina-antonacci.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/the-metropolitan-opera.md","scene/companies/san-francisco-opera.md"]
related_people = ["scene/people/leah-crocetto.md"]
short_description = "American soprano Leah Crocetto is a Cardiff BBC Singer of the World, a Metropolitan Opera National Council Audition Grand Finals Winner, a former Adler fellow at San Francisco Opera, and this season, she made her Metropolitan Opera debut as Liù in Franco Zeffirelli&#039;s iconic production of Turandot."
slug = "talking-with-singers-leah-crocetto"
title = "Talking with singers: Leah Crocetto"
+++

## What was it like to have your Metropolitan Opera debut this season? How did you anticipate you would feel? 

Having my Met debut was a surreal experience. I have dreamed about that moment since I was a little girl, and to be standing up there in front of that gold curtain was literally a dream come true!

I didn't really anticipate anything. I had no idea what the audience's reaction would be or how I would feel and to be completely honest, it was kind of all a blur! I just remember feeling so much joy when I was finished and taking my bow. I also had around 90 friends and family in the audience, so that helped!

## You get some of the most coveted soprano roles in opera. Do you have any significant connections with any in particular?

I love the music that I get to sing, so much! I always find something in myself that I can use to connect with each character. For me, my dearest heroine is Desdemona, perhaps because she is the one I have played the most. But there is something so ideal about her and so strong and pure. She certainly is not a wimp. She isn't a wet blanket, as so many singers portray her. She fights for love and for herself to the bitter end. I identify with that.

In the same way, Anna Erisso, my character in *Maometto II* is also this way. Her loyalty is at the core of who she is. And her love for family and duty to her country is something she holds very dear. She dies of her own volition. Our ending in the David Alden production is very profound. David is brilliant at finding the core of the piece and the role.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451952562323/San-Francisco-Opera-Luisa-Miller-Image---Cory-Weaver---Resized.jpg.jpg)<figcaption>Leah Crocetto in the title role of San Francisco Opera's production of *Luisa Miller*. Photo: Cory Weaver.</figcaption>
</figure>

## What do you find different about singing Rossini, compared to your Verdi and Puccini roles?

People hear Rossini and they automatically think "high E's and Rosina in *Barber*", but his serious repertoire is quite on par with early Verdi and Mozart. The coloratura formulations are definitely all Rossini though. The characters are deep and heroic, much like my Verdi characters. Vocally it's the most healthy singing I could ever dream of doing! It feels like a massage on my vocal folds. 

I approach each role the same way. What can I bring to this role, with my voice? I don't pay attention to what people "expect" to hear. I play the roles the way I play them, I sing them the way I sing them, not the way someone else has done before me or what tradition "suggests". And I have an excellent team that guides me along the way.

## How do you manage so much time on the road? Do you have any travel or suitcase routines?

Life on the road is quite difficult at times, but it's also the most rewarding aspect of the job! I get to see places that I never would have had I not become an opera singer. I am very close with my family, so FaceTime, Skype, and my iPhone help a lot with that. 

My only "must-pack" items are a candle and my sweet little Maltese, Ernie! He's a 7lb ball of fluff and love!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451952488060/Leah-Crocetto-and-Ernie---Image-by-Fay-Fox---Resized.jpg.jpg)<figcaption>Leah Crocetto and Ernie. Photo by Fay Fox.</figcaption>
</figure>

## It’s no secret that it’s tough to be an opera singer. Why do you do it, and what do you love most about it?

I love that! It's "no secret!" I think it isn't a secret in the opera world, but outside of our little world, it's sometimes viewed as a breeze job. I mean, I get to play pretend on a stage for a living, right? But there is definitely a lot more that goes into it than the final outcome that the audience sees, as you know. 
I do this job because I must. It is my calling and my passion. God bestowed upon me this incredible gift that I have a responsibility to nurture and share with others. I truly believe that. 

The payoff is the woman who comes to your dressing room crying because something you did connected so deeply with her that she couldn't contain it. Or being told that you made another person forget their problems for a night. It's also amazing when I have the opportunity to reach out to the community. 

One of the most incredible experiences I have ever had is working with the incredible advanced students at the San Francisco Girls Chorus. I love working with the next generation of singers. I think my job is a gift, and one that I am so thankful for! 

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/p5fZG0LZqvw" frameborder="0" allowfullscreen></iframe>
</figure>
