+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-09-03T14:40:00+01:00"
lastmod = "2016-09-16T09:11:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472910053353/2016-09-03---Keri-Alkema-Dario-Acosta.jpg.jpg"
primary_image_credit = "Photo by Dario Acosta."
publishDate = "2016-09-16T08:00:00+01:00"
related_articles = ["articles/talking-with-singers-nicole-cabell.md","articles/talking-with-singers-christine-goerke.md","articles/talking-with-singers-othalie-graham.md","articles/talking-with-singers-luca-pisaroni.md","articles/talking-with-singers-rene-barbera.md","articles/in-review-tosca-at-eno.md","articles/in-review-tosca-at-the-coc.md","articles/talking-with-singers-jennifer-rowley.md","articles/steps-forward-for-operas-women-tosca-at-pbo.md"]
related_companies = ["scene/companies/english-national-opera.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/keri-alkema.md"]
short_description = "&quot;I was really hoping my voice was going to drop so I could sing the big Verdi mezzo girls,&quot; Alkema remembers. But instead, the natural change in her voice led her to higher rep. &quot;I kind of walked into that in a natural way.&quot;"
slug = "talking-with-singers-keri-alkema"
title = "Talking with singers: Keri Alkema"
+++

"I've been looking forward to it for a while," says soprano [Keri Alkema](/scene/people/keri-alkema/) of her upcoming season, which includes singing the title role in three different productions of *Tosca*. Her first will be directed by fellow Tosca-veteran, Catherine Malfitano, at [English National Opera](https://www.eno.org/whats-on/tosca/) beginning October 3. "I'm really excited about all three productions for different reasons. I love [Tosca], so I think it'll be fun, and I love the challenge of portraying her different ways." 

After her 13-show run at ENO, Alkema will reprise Tosca in Paul Curran's production at the [Canadian Opera Company](http://www.coc.ca/PerformancesAndTickets/1617Season/Tosca.aspx), and then Andreas Kriegenburg's at [Oper Frankfurt](http://www.oper-frankfurt.de/de/spielplan/tosca/?id_datum=348#date), both in the spring of 2017.

Alkema loves Tosca's strength and her tendency to be fiercely opinionated. "I also think that there is a vulnerable side to her," she adds, "which makes her jealous." A female archetype of sorts for Puccini, Tosca is what Alkema deems "an iconic character," and she sees commonalities with Mimì in *La bohème*. "I think [these] women are just such strong beings, with strength of love and passion while trying to do what is right."

She couldn't be happier to take on the role. She laughs, "I still think, 'Oh my God, can somebody pinch me? Did I really just start rehearsals for my first Tosca?'"

When it comes to a role that is quintessentially Italian, how does Alkema find it to sing Tosca at the strictly-English ENO? Thought she admits to some initial hesitation, "a coach friend of mine said, 'Yeah, but how much better will you actually really know this role, because you're singing it in your native tongue?'" Looking ahead at the Italian productions later in her season, Alkema now agrees, "that was a really cool way of looking at it."

Perhaps not surprisingly, what she does find unnerving about singing an English *Tosca* is the short bit of spoken dialogue after *that scene* with Scarpia. She's perfecting her English accent for that moment, and she laughs, "I'm going to be in a hundred coachings for this."

Alkema enjoys a calendar filled with roles that most sopranos covet, like Donna Elvira (*Don Giovanni*), Amelia (*Un ballo in maschera*), and Vitellia (*La clemenza di Tito*). In fact, Mimì was her first Puccini role as soprano, after a shift from mezzo repertoire roughly 6 years ago that began with Donna Elvira in a critically acclaimed [Christopher Alden](/talking-with-directors-christopher-alden/) production of *Don Giovanni* at New York City Opera.

"I was really hoping my voice was going to drop so I could sing the big Verdi mezzo girls," Alkema remembers. But instead, the natural change in her voice led her to higher rep. "I kind of walked into that in a natural way."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473964491776/3016-09-15---Alkema-Tito---Cooper.jpg.jpg)
<figcaption>Alkema as Vitellia, with Isabel Leonard as Sesto, in *La clemenza di Tito*, Canadian Opera Company, 2013. Photo by Michael Cooper.</figcaption>
</figure>

While still working as a mezzo, Alkema covered Donna Elvira in Washington, and she found it a difficult sing. A few years later, her coach suggested she revisit "Mi tradì quell'alma ingrata," Elvira's big aria. "And I was thinking, 'Are you kidding me? This is brutal.' I did it, and it was easy." Later, she sang Amelia's aria from *Un ballo in maschera* for Marilyn Horne, who heard the ease of the role in Alkema's voice, and gave her an additional (and significant) go-ahead. 

Easy though it may feel, Alkema still discovered the pressure of singing high notes. "I didn't understand why tenors and sopranos always seemed so stressed out all the time. Because, you know, mezzos and baritones are always having a good time," she laughs. She acknowledges the heightened pressure to have gorgeous high notes, but chalks it up to a task best accomplished with technique. "Once you figure out the exact placement of those notes, then you're fine."

"It was one of those forks in the road," Alkema explains. "Do you do it? Do you take the chance of people not buying it?" Yet she went ahead with a "life is short" mentality, and "luckily people liked it!"

Now, she freely admits, "I'm just really enjoying being a soprano!"

"Music has been a part of my life since I was 5," says Alkema, who studied piano before seriously pursuing voice. She recalls a teacher advising her to make the switch to singing, saying, "No, honey, I think you're a better singer than you are a pianist."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473964557170/2016-09-14---Alkema-Otello.jpg.jpg)
<figcaption>Alkema as Desdemona in *Otello*, Teatro Municipal de Santiago, 2014.</figcaption>
</figure>

Alkema navigates her singing career with the constant pursuit of the "next level." When her voice changed, she took advantage of the challenge, thinking, "OK, can I actually sing this soprano rep? What soprano rep can I sing?" It's a simple, yet malleable way of making decisions about what she sings, and one that allows her the technical foundation to enjoy her time in each roles. 

Laughing, Alkema recalls the ongoing conversation she has with her manager. "If you see the writing is on the wall - that my career is over - before I do, you just call me and say the words 'real estate' and hang up the phone." Even if she were no longer a singer, Alkema has endless interest in the industry. "I'd love to be in arts administration, help with casting and other industry things," she says. "I just love the entirety of the business, not only being onstage, but how it all works, how it comes together, how they keep getting people in seats."

It's a hypothetical "what if" scenario, but Alkema's ease and positivity are rare among singers who consider a career change. "I've met singers who are just die-hard, and they say, 'Oh my God, my life would be over if I didn't sing!' And I think to myself, 'Are you kidding me? Life is so amazing, and there are 5000 other interesting things to do.'"
