+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-26T19:19:00+01:00"
lastmod = "2016-11-03T12:06:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477843983238/2016-10-30---Kate-Lindsey---Rosetta-Greek.jpg.jpg"
primary_image_credit = "Photo by Rosetta Greek."
publishDate = "2016-11-03T12:06:00+00:00"
related_articles = ["articles/talking-with-singers-gyula-nagy.md","articles/songbird-the-debut-album-from-layla-claire.md"]
related_companies = ["scene/companies/royal-opera-house.md","scene/companies/the-metropolitan-opera.md","scene/companies/washington-national-opera.md","scene/companies/seattle-opera.md","scene/companies/salzburg-festival.md"]
related_people = ["scene/people/kate-lindsey.md"]
short_description = "&quot;One of the most challenging things on stage is to really, really open yourself up and give,&quot; she says. Singers often feel a responsibility to do well, to move an audience, and as a result, it&#039;s easy for the body to give in to pressure. &quot;We can either play it safe, because we&#039;re just not sure what the support is like, we may not feel like we have enough breath under us, so we can play it safe, maybe not go for that pianissimo,&quot; Lindsey explains of taking risks onstage. &quot;It&#039;s really hard to do that in front of thousands of people when your heart&#039;s pounding.&quot;"
slug = "talking-with-singers-kate-lindsey"
title = "Talking with singers: Kate Lindsey"
+++

"It's really rare to be working somewhere and be able to sleep in your bed at night," says American mezzo-soprano [Kate Lindsey](/scene/people/kate-lindsey/), who has been based in London for the last three years. She's currently in rehearsal for [*Les contes d'Hoffmann*](http://www.roh.org.uk/productions/les-contes-dhoffmann-by-john-schlesinger) at the [Royal Opera House](/scene/companies/royal-opera-house/), in which she'll sing Nicklausse/The Muse opposite Vittorio Grigòlo (7-24 November) and Leonardo Capalbo (28 November and 3 December) as Hoffmann and [Thomas Hampson](/scene/people/thomas-hampson/) as the Villains.

"I'm really grateful when that happens," says Lindsey of her hometown gigs. "I will try to enjoy it as much as possible before it all changes." Beginning in the new year, her schedule includes singing Sister Helen Prejean in *Dead Man Walking* at [Washington National Opera](/scene/companies/washington-national-opera/), Cherubino in [Vienna](/scene/companies/wiener-staatsoper/), Nicklausse/Muse in [Los Angeles](/scene/companies/los-angeles-opera/), and concert performances of Canteloube's *Chants d'Auvergne* in Paris.

Nicklausse is one of Lindsey's signature roles; indeed, her performance in Bartlett Sher's 2009 production of *Hoffmann* at the Metropolitan Opera was a major turning point in the mezzo's career. Though it's still one of her bread-and-butter roles, Lindsey appreciates some novelty each time she takes on Nicklausse and The Muse. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477844671881/Lindsey---Hoffmann---Muse---Elise-Bakketun.jpg.jpg)<figcaption>Lindsey as The Muse in Seattle Opera's *Les contes d'Hoffmann*, 2014. Photo by Elise Bakketun.</figcaption> 
</figure>

"That's the interesting thing in particular about this opera, is that there are many choices," she says, referring to the multiple versions of Offenbach's score, in which music is added and deleted, lines redistributed among the characters, and the acts can be re-ordered. "There's always something that I have to learn to add into it or take out, or keep myself from singing certain lines, because it's not my line anymore," she laughs.

With any role, though, it's an active task for a singer to keep it fresh both for the audience and for themselves. "I really have to be on myself about finding new things within it," Lindsey agrees. 

## "There are many artists who live in that realm."

"I've always found the productions most interesting where Nicklausse and the Villains use each other," she says. "Both parts of that psychological make-up use each other as a way of bringing [Hoffmann] back to his art." She likens it to the classic tableau of the angel on one shoulder - being Nicklausse, the voice of reason - and the devilish Villains on the other.

"I feel like Nicklausse and the Villains are both things that are part of Hoffmann's conscience, that have been created by him," says Lindsey, who understands well an artist's struggles with the demons of self-doubt. "Even as an artist, it's that voice inside of you that says, 'you'll never be able to do this.' But there's that other part of you that's saying, 'but you *can* do it...love yourself, be gentle.'"

Often found close to self-doubt is the demon of substance abuse, something which affects the alcoholic Hoffmann. "There are many artists who live in that realm," says Lindsey, citing examples like Amy Winehouse and Kurt Cobain. "It's an interesting thing to examine. To a certain point, that's the axis off of which they create, within in their destructive pattern. But if they go too far, obviously there is no more creation, there is no more art."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477844708674/2016-10-30---Lindsey---Ariadne---Elise-Bakketun.jpg.jpg)<figcaption>Lindsey as the Komponist in Seattle Opera's *Ariadne auf Naxos*, 2015. Photo by Elise Bakketun.</figcaption>
</figure>

Even success can hinder an artist's ability to work, particularly with the same motivation and freedom as their fans expect. "They have such a desire to create, and then all of a sudden they sort of explode onto the scene," says Lindsey. "I feel a lot of sympathy for that, because the pressures happen so quickly." It's something familiar to opera singers, too; once the public hears of their skills, the pressure to maintain and improve is huge.

Connected to the pervasiveness of opera-related social media, Lindsey finds an example in recordings, whether they're informally done on a listener's phone, or at the scale of the Met's *Live in HD series*. "From one persective, it's really exciting, because there's just so much stuff out there. But the pressure..." Lindsey has no issue with the concept of disseminating opera to as many listeners as possible, yet at the same time, "it's really refreshing to be in a house for an evening when it's just between you and the people that are sitting in the seats right there."

She recalls the few nights during her 2009 run of *Les contes d'Hoffmann* at The Metropolitan Opera, where there were no live broadcasts, and no microphones placed on the stage; there was a distinct sensation of freedom among the cast, and "that is always a really special performance."

## "So much of it is mental."

Even with her experience on the world's major stages, and in the world's movie theatres, Lindsey is still conscious about what's difficult about singing. "One of the most challenging things on stage is to really, really open yourself up and give," she says. Singers often feel a responsibility to do well, to move an audience, and as a result, it's easy for the body to give in to pressure. "We can either play it safe, because we're just not sure what the support is like, we may not feel like we have enough breath under us, so we can play it safe, maybe not go for that *pianissimo*," Lindsey explains of taking risks onstage. "It's really hard to do that in front of thousands of people when your heart's pounding."

It's a thoughtful pursuit for Lindsey, who spends time practicing that openness, what she calls "being really gentle with yourself." More introverted by nature ("I get my energy from quiet time"), Lindsey understands how the psychology of singing can be harder to master than excellent vocal technique. "I think that's the difference between the people that really do well in the work, and the people that struggle, because so much of it is mental." 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477844816738/Dido_and_Aeneas_2015_Kate_Lindsey_Balthasar-Neumann-Chor%20und-Solisten%20-%20Salzburg%20-%20Monika_Rittershaus.jpg.jpg)<figcaption>Lindsey as Dido, with the Balthasar Neumann Chor, in *Dido and Aeneas*, Salzburg Festival, 2015. Photo by Monika Rittershaus.</figcaption>
</figure>

Now, Lindsey approaches risk with the understanding that her career - in its current state - is temporary. "This is a limited time offer - this whole career, singing these roles - it's not going to be forever," she says. "It's really about enjoying what we got while we got it." That mindset makes the risk seem less dangerous, and allows her to say, "Well, fuck it, I'm here and I'm going to try it," and gives Lindsey some freedom from the "other noise."

## "We should be our own best friend."

The natural ebbs and flows of the voice are exactly that, and Lindsey likens singing to her yoga practice. "There are days when just being in the pose, holding the pose, everything feels creaky, I'm really in my head, the body feels heavy. It's like the machinery is a little bit out of whack." On other days, the poses flow. "I'm not thinking about it so much. I'm just there and I'm not fighting it," explains Lindsey. That, she says, is comparable to a great night of singing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477844808165/2016-10-30---Lindsey-Annio---Met---Ken-Howard.jpg.jpg)<figcaption>Lindsey as Annio in The Metropolitan Opera's *La clemenza di Tito*, 2013. Photo by Ken Howard.</figcaption>
</figure>

"There's no determining necessarily when and how it's going to happen," she adds, with a refreshing calmness that's rare when it comes to what's often beyond a singer's control. Lindsey is comfortable taking charge of her own artistry, without reliance on the opinions of others. "At the end of the day, we are our own best friend. And we should be our own best friend, really." Instead of feedback and permission from others, trusted mentors though they may be, Lindsey is a big advocate of checking in with herself. "It's hard to be able to trust ourselves, if we don't know how we do it without the feedback of other people," she says. "Being our own teacher is equally as important as having teachers."

Perhaps it's that mindset that allows Lindsey to stay simple and content about her career as a singer. "I feel really fortunate that I've been able to make a career of it," she says, noting that singing would be in her life, paycheque or not. 

"I can't imagine doing anything else."

>Les contes d'Hoffmann runs at the Royal Opera House from November 7 to December 3. For details and tickets, [click here.](http://www.roh.org.uk/productions/les-contes-dhoffmann-by-john-schlesinger)
