+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-12-20T15:53:00-05:00"
lastmod = "2016-12-21T17:14:00-05:00"
preamble = "Greek mezzo-soprano [Karolina Pilou](/scene/people/karolina-pilou/) is gearing up for a milestone in her career, kicking off 2017 with a debut at [The Metropolitan Opera](/scene/companies/the-metropolitan-opera/) as Berta in Rossini's *Il barbiere di Siviglia*. Pilou spoke eloquently about what a Met debut means to her, about the small and mighty opera companies that make up New York's scene, and working within a contemporary - and visually focused - opera industry."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1482267696265/2016-12-20---Karolina-Pilou.jpg.jpg"
primary_image_credit = "Photo by Etrange-Amour."
publishDate = "2016-12-21T15:36:00-05:00"
related_articles = ["articles/bronx-opera-50-years-counting.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/loftopera.md"]
related_people = ["scene/people/karolina-pilou.md"]
short_description = "&quot;The idea that one person doing the casting can assess what the thousands of people from different cultures and walks of life in a diverse audience will find attractive or not, is still a puzzle to me. We tell the most fascinating and outrageous stories to audiences, but don&#039;t give them enough credit that they can believe a short and overweight tenor or a plus size soprano can be the object of desire in many given opera productions.&quot;"
slug = "talking-with-singers-karolina-pilou"
title = "Talking with singers: Karolina Pilou"
+++

## What do you anticipate most about your debut at the Met?

Just one thing? This is the most exciting time in my life and every day that goes by, I think of one more reason to be ecstatic about this moment! Needless to say, stepping out on that stage for the first time knowing just how many extraordinary artists have given us iconic renditions of opera's most beloved characters on that very stage, I know will be a very special moment. On a more personal level, this is a culmination of a 17-year long effort that included lots of sacrifice, unpredictable obstacles, disappointments, and more rejection than one can imagine. 

I consider myself extremely lucky that throughout the run of the show I will have so many of the special people in my life travel from three different continents to come and share this milestone with me. I am beyond excited to get the chance to express my gratitude in person to these people who have been there for me, championing me, even in the times when all I had going for myself was the seemingly farfetched dream of one day singing at the Met. This gives me as much joy and sense of fulfillment as the Met debut itself!

## What has been your experience with smaller New York-based companies and organizations? What does the New York scene look like outside of the Met?

It's interesting how these difficult times in the world of art and opera in particular have catapulted us into the bright future of our art form, which I think lies in the smaller organizations. In just a short few years we have seen gems such as [LoftOpera](/scene/companies/loftopera/), [Heartbeat Opera](/scene/companies/heartbeat-opera/) and [Bare Opera](/scene/companies/bare-opera/) adding to the already existing breadth of what New York City's opera producing community had to offer with long standing opera warriors such as the [Harlem Opera Theater](/scene/companies/harlem-opera-theater/), [Vertical Player Repertory](/scene/companies/vertical-player-repertory/), the [Martina Arroyo Foundation](http://www.martinaarroyofdn.org/), [Center for Contemporary Opera](/scene/companies/center-for-contemporary-opera/), [Chelsea Opera](/scene/companies/chelsea-opera/), and [Bronx Opera](/scene/companies/bronx-opera/), to mention only a few. 

The truth is that there is something for every taste today - from contemporary opera, to companies who focus on reviving long lost or rarely produced scores, to a full drag queen opera show! 

I have had the joy of working with a couple of these organizations and these experiences have been very important to my development. When I sang with The Martina Arroyo Foundation's Prelude to Performance in the summer of 2014 for instance, I had gone four years without performing a role. I was in that awkward stage as a larger voice trying to get my technique together and I was no longer young enough to be part of the top tier summer programs that offered performing opportunities in a full production setting that are affiliated with a large opera House or prestigious Festival. My resume had a huge gap and I was very overweight at the time. Martina Arroyo came along and I had the most wonderful summer performing again. I learned a lot and was able to gain my confidence back. 

Then I got to work with the company that I would happily call home forever — LoftOpera. Loft is the epitome of what opera needs to be about. They offer a mix of contemporary approaches by performing in cool venues with great, sexy productions on a budget together with a solid sense of what opera really is about (great voices and great music!) When I performed with Loft in the Verdi Summer Sessions concert in September 2015, I saw an audience full of young people, and opera newbies. This makes it all worth it! Passing on the glorious art form and the love for it to the next generation and giving  more people the experience of transcendence from the rough and wild to the heights of our human capacity is priceless. 

## What advice do you have for singers who are pursuing their careers far away from home?

Don't lose track of why you do it. You sing (I hope) because you love it. Being abroad away from your support system, struggling to make it in a field where there are no guarantees and you are only as good as your last performance, is way tougher than most people can fathom. It is sometimes very easy to forget that you sing because you love to sing and not because of any career opportunities that may or may not be at the end of the tunnel. I would also encourage singers pursuing careers far from home to nurture their friendships and bonds with important people in their lives no matter how far away they are. 

That kind of love that one gives and receives from their family and friends is what makes this journey possible. What would be the point of achieving all of your professional goals and having your dreams come true if you have no one to celebrate them with?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1482267772881/2016-12-20---Pilou.jpg.jpg)
<figcaption>Photo by Etrange-Amour.</figcaption>
</figure>

## As singers, there are often many rejections on the way to big career milestones. What has your experience with this been like and how do you think it has helped shape you today?

It would be fair and accurate to say that my path so far has been mostly rejections and about ten to fifteen "yeses" at the most. I have spent far too long focusing on all the opportunities that weren't given to me, and it was only when I started focusing on the few people and organizations that supported me and gave me a chance, that things started happening for me. 

For a long time I was resentful of how long it has taken me to get anywhere professionally and I was truly living in fear that I wasted "the best years of my life" trying to pursue a career that was not going to work out for me. Now I see that I wasn't ready to handle a career back then, even though I was convinced to the contrary!

Most importantly, however, the difficulties of my path have made me the strong, resilient, focused and surprisingly patient person that I am today. If I could handle waiting on the "opera bench" for 17 years before being given a chance to play, I am pretty confident I have enough resilience for anything else I may want to accomplish in life. Every single one of my rejections was a gift, and it took changing my perspective to be able to recognize that. 

Furthermore, because of having gone through so many professional rejections and having had a harder path, I have become much more grateful for even the smallest opportunity to perform. I can't imagine that singers who started a major career in their mid-20s could feel as much joy and fulfillment from singing a "secondary role" in their 30s as I do right now. There is something so special about getting something you have fought and longed so hard for.

## In an industry that is often based on a particular look, how do you feel this has affected your approach to preparing your body both physically and mentally for a particular role?

This is a hot subject for many, including myself! There is definitely pressure to look a certain way nowadays and one can choose to give in, to let it affect them, ignore it and deal with the repercussions or choose to take it into consideration without necessarily agreeing with it. While I understand that looking a certain way today is a requirement for a career, I also am aware that this idea more often than not implies that being thin or fit equals being attractive and vice versa, which is simply not the case. The idea that one person doing the casting can assess what the thousands of people from different cultures and walks of life in a diverse audience will find attractive or not, is still a puzzle to me. We tell the most fascinating and outrageous stories to audiences, but don't give them enough credit that they can believe a short and overweight tenor or a plus size soprano can be the object of desire in many given opera productions. 

Having said that, I have recently dropped five dress sizes, and while this wasn't motivated by my ambition for my singing career, it makes me better equipped to deal with the physical stress of my job. I want to be around and physically in great shape to make the most of the next few decades of my life on and off the stage. And I can't deny that it's nice to walk into an audition room and know that my resume is no longer instantly put on the "character mezzo" pile!

## Do you have any "bucket list" roles that you'd like to sing in future seasons?

How long do we have?! It is a very long and diverse list but at the very top are for sure Amneris and Azucena. I could sing Zita until the end of time because she is the most fun character ever. I can't wait to sing Fricka, Princess de Bouilion (*Adriana Lecouvreur*), Giovanna Seymour (*Anna Bolena*), Dalila, but also Orfeo, Arsace (*Semiramide*), Tancredi and Isabella (*Italiana in Algeri*), Cassandra (*Les Troyens*), Herodiade and last but not least, Clytemnestra (I can't wait to sink my teeth into that role when I am older, I think it will be my absolute perfect fit!) 

## Why do you sing professionally?

I have tried to intellectualize the answer to this question many times. The most direct answer I have come up with is that I am deeply moved by being part of something so much larger than myself that has been composed hundreds of years ago and performed thousands of times, that is still alive and knowing that I am part of "recreating" it — bringing a character to life one more time as I see her through my eyes — and yet still being aware that after this very performance, the same moment can never be recreated again. The energy of many people being in the moment together in the search of truth, of meaning and even of perfection, and the sense that there is a chance by being the perfect vehicle for the composer's vision that you may give someone in the audience exactly what they needed this day, THAT is pure magic, and is why I sing professionally.  
