+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-11-12T13:58:00-07:00"
lastmod = "2016-07-15T12:15:00-06:00"
preamble = "[Jorell Williams](/scene/people/jorell-williams) is a baritone based in New York City, back home after a busy summer with Santa Fe Opera's Apprentice Program, singing in productions of *La fille du régiment*, *Rigoletto* and the world premiere of Jennifer Higdon's *Cold Mountain*.\n\nI first met Jorell in rainy St. John's, NL, while he was singing Schaunard in *La bohème*. We had a summer of great conversations about the realities of the opera industry, and so he has been on my must-interview list ever since. We spoke over Skype about some big topics, like being an African-American baritone in the United States, the decline of the operatic superstar, and helping people \"go somewhere that's not reality\" with his singing.\n\nYou can hear Jorell Williams sing Haydn's *Creation* with the Geneseo Symphony Orchestra on November 22nd (free admission, 3pm, Wadsworth Auditorium, Geneseo, NY), at Handel's [*Messiah*](http://www.branfordmessiah.org/index.html) with the Branford Chorale on December 20th (5:30pm, First Congregational Church, Branford, CT)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447424077771/2015-11-13---Jorell-Williams.jpg.jpg"
publishDate = "2015-11-13T07:55:00-07:00"
related_articles = ["articles/talking-with-singers-othalie-graham.md","articles/what-oscarssowhite-can-learn-from-opera.md","articles/talking-with-singers-bryan-register.md","articles/spotlight-on-diego-silva.md","articles/spotlight-on-will-liverman.md","articles/sidney-outlaw-stairs-success.md","articles/talking-with-singers-jnai-bridges.md","articles/cycles-of-my-being-this-is-their-story.md","articles/talking-with-singers-john-holiday.md"]
related_people = ["scene/people/jorell-williams.md"]
short_description = "Jorell Williams is a baritone based in New York City, back home after a busy summer with Santa Fe Opera&#039;s Apprentice Program, singing in productions of La fille du régiment, Rigoletto and the world premiere of Jennifer Higdon&#039;s Cold Mountain."
slug = "talking-with-singers-jorell-williams"
title = "Talking with singers: Jorell Williams"
+++

"If I were sitting behind the table listening to people audition, what I'm used to is the drop the needle effect. You close your eyes and you listen to what the voice is doing. You're not looking at anyone, you're not looking at a photograph, you're not looking for anything else except what the voice does."

Williams has sung his fair share of auditions, so maybe it's not surprising that his would-be method echoes the mythology of opera bosses throughout the decades. Canada's late Richard Bradshaw was known for closing his eyes and listening hard to each voice he heard; this voice-first approach is still held and practiced with a sort of old-world reverence. But it's not the reality of today's opera biz that Williams knows. "I think there is a huge gap in between what we're trying to do, and what is actually happening."

## The blurred line

There's the ubiquitous (yet vague) list of physical criteria that singers must meet in order to be considered for a role; Williams insists there's yet another layer when he walks into an audition. "There's the color palate, or the color wheel as I like to call it, where it's, 'I don't know if I can put this African American male with this Caucasian woman...because the world may not be ready to see that on a frequent basis.'" He acknowledges singers like Lawrence Brownlee, Eric Owens, and Morris Robinson, but adds, "the day of Paul Robeson and Lawrence Winters are behind us. As a baritone, my direction was pulled from their artistry and inspired me to continue to open doors that are frequently closed. The journey continues...When will the community embrace an African American baritone along with his counterparts? It's time to be celebrated and it's long overdue."

I echoed Williams' question back to him, and he assured me he didn't have an answer. "I think people dance around it or sugar coat it, as if it's an artistic casting based on somone's voice colour. 'We can't cast this person, their voice doesn't match up with this person's.'" For all his lack of real answers, Williams has seen a decade-long slice of the operatic business and the people that create it, "which when you look on paper, when you look at companies, when you look behind the table, the majority are Caucasian males."

"I look at the rosters of the top management companies, whether it be CAMI, IMG, Bel Canto Global Arts, whatever it is, there really isn't a mix; there are some international faces on American rosters, but on the American rosters I don't see a lot of African-American singers." It's not that they're not there at all, but "two or three doesn't amount to the hundreds and hundreds of other singers that have potential."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447424831881/Syracuse%20Opera%20-%20Porgy%20and%20Bess.jpg.jpg)
<figcaption>From Syracuse Opera's 2014 production of *Porgy and Bess*.
</figure>

Perhaps it's on opera companies to be more specific with what they want out of a casting call, similar to how auditions are run in music theatre circles. "Broadway auditions specifically, they are very clear with what they want," says Williams. "Before you even walk into the audition, they say, 'this is our casting notice, we're looking for this person in their mid-20s that happens to have blue hair.' If you don't have blue hair, don't show up. It sounds ridiculous, but that's just the way it is."

So, should opera follow suit with, say, a production of *Otello*? I asked Jorell about the buzz surrounding the [Metropolitan Opera's current production](https://www.washingtonpost.com/entertainment/music/how-do-african-american-singers-feel-about-blackface-in-opera/2015/10/16/fbbaa318-7176-11e5-9cbb-790369643cf9_story.html), devoid of skin darkening make-up for tenor Aleksandrs Antonenko. "It's a specific character, and we understand that. So if you were to darken your tones, I don't think that's the issue. I think the bigger issue is why they're trying to focus in on this one specific show, to make it seem as though African-Americans *do* get a chance to perform in leading roles. No, that's a specific piece. What about *The Marriage of Figaro*? What about *Tosca*? What about *La bohème*?"

Williams applies that old adage, about the three sides to every story ("there's your [side], there's theirs, and there's the truth"), to all the stuff he can't control in this business. "That's my personal issue that I've been dealing with for years now. That doesn't mean that I'm bitter about it, because I still do what I have to do, and I'm still working."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447424745808/Santa%20Fe%20Opera%20-%20Kate%20Russell%20Photography%20.jpg.jpg)
<figcaption>Williams in Santa Fe Opera's 2015 production of *Les pêcheurs de perles*. Photo by Kate Russell.</figcaption>
</figure>

## Changing times

Williams also sees a big shift in how people find and consume opera, which used to be with the help of touring productions from big companies like The Metropolitan Opera, taking shows to smaller American cities. "They would expose them to the art form, which is why people would take the trips to California to go to LA Opera, San Francisco. Because they experienced it in a small format and because they were drawn to the art form they would travel to big cities to see these superstars. 'Oh, I saw this person in my back yard, now I'm going to see them in the biggest house in the world.'"

The concept of the opera singer as an autonomous celebrity has lost steam, compared even to the days of Beverly Sills and Marilyn Horne. "I think we forgot that this was actually a thing," agrees Williams. Opera singers today have celebrity within their circles, but outside of that, singers are no longer the connective force bringing new audiences into opera houses. "It's different now, the demographic is different. It's harder to break into the industry; there are too many companies, too many singers, there's not enough money that they want to spend smartly."

For Williams, getting competitive doesn't solve much. "All we have are each other in this business. It's similar to being a lawyer, doctor, or a school teacher. These are a few examples of professions (not meant to diminish the importance of others) that compare to performance practice. Many years in school, the equivalent to a residency (Young Artist Program) and endless hours of scrutiny and judgement. Very few are going to understand what we have to go through 24/7 because this is a 24/7 job, for the rest of our lives. Vacation? What's that?" It can be all-consuming, and it can make it hard for young artists to see clearly what they're striving for. "Every day is a step forward in understanding balance," echoes Williams.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447424965968/Urban%20Arias%20-%20Blue%20Viola.jpg.jpg)
<figcaption>Williams in Urban Arias' 2015 world premiere of *Blue Viola*, by Peter Hilliard and Matt Boresi.</figcaption>
</figure>

## What it's worth

"We're giving them the chance to stop, look, and listen," simplifies Williams, when I asked him why he still sings, despite how hard it is. "At the end of the day, if we can change one person's life, if we can make them laugh or cry, or forget about whatever's happening in their lives... or they just need to go somewhere that's not reality, we've done our jobs." Applause, cheers, an "emphatic boo," for Williams, they're all ways an audience can be touched. "We've given them an outlet."

He brought up that Adam Sandler movie from last year, [*The Cobbler*](http://www.imdb.com/title/tt3203616/), where a little magic helps a cobbler spend time in his clients' shoes, figuratively *and* literally. "We get to put ourselves in people's shoes, and try to the best of our ability to create something that's realistic." Williams loves the transformation, too. "We have about 5-7 seconds to go from 'oh my God, I just spilled coffee on my shirt' backstage to someone who lived in 1783. We're challenged to put ourselves in the shoes of these people."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447425139074/La%20Boheme%20OOTA.jpg.jpg)
<figcaption>Williams after a performance of *La bohème* (Schaunard) at Opera on the Avalon, 2014.</figcaption>
</figure>

Great singers have respect for the characters they play, and for the personal stories their listeners bring with them when they attend a show. Audiences may come with stress about their home or their marriage or their job, and for Williams, that matters when he steps onstage. In those 5-7 seconds he gets backstage before the stage lights hit him, he reminds himself, "Ok, I have to be a badass right now, because [that woman] is trying to kill her boss, and we don't want her to do that today." He laughs, "So, let's give her a good show."

"[We get] to bring them into our world, bring them into our playground," says Williams. "This is a chosen-by-the-greater-powers gift that we've been given, to hopefully allow change to happen in the world." 

>Want more from Jorell? Follow him on Twitter, at [@JojoNoire](https://twitter.com/JojoNoire).


