+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-09-15T13:02:00-04:00"
lastmod = "2017-10-02T21:12:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505494895761/2017-09-15---Fanning-Gotterdammerung---Gunther-Brunnhilde-0492.jpg.jpg"
primary_image_credit = "John Fanning (Gunther) and Susan Bullock as (Brünnhilde) in the COC's production of Götterdämmerung. Photo: Michael Cooper."
publishDate = "2017-10-02T20:51:00-04:00"
related_articles = ["articles/talking-with-singers-gregory-kunde.md","articles/talking-with-singers-sir-john-tomlinson.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/john-fanning.md"]
short_description = "&quot;Even geezer singers will take breaths they shouldn&#039;t,&quot; he says of the all-too-human aspect to singing live onstage. &quot;Those things never change, we just get better at dealing with them.&quot;"
slug = "talking-with-singers-john-fanning"
title = "Talking with singers: John Fanning"
+++

"This role, it's a tricky little thing," says baritone [John Fanning](/scene/people/john-fanning/) of singing Waldner in [*Arabella*](http://coc.ca/PerformancesAndTickets/1718Season/Arabella.aspx), running at the Canadian Opera Company **October 5-28**. Fanning takes on the role of the Count who's "down on his luck", trying to solve his family's financial woes by marrying off his eldest daughter, Arabella, to a wealthy friend of his from Croatia. "He's pretty much lost everything," says Fanning of Waldner, whose habits have him now "living in a bit of a run-down hotel in Vienna because he's a gambler."

As far as fathers who force their daughters into marriages go, Waldner lucks out when a different - and younger - man responds to his invitation to meet Arabella, and "she pretty much likes him right away."

"She ends up happily 'given away', I suppose."

His role in *Arabella* is the most recent in Fanning's long history with the Canadian Opera Company, which began when he was a member of the company's Ensemble Studio program from 1983-1985. "It's all very familiar and it's lovely to be back," he says of his latest return. He credits his time as a young artist with the COC with giving him "a good basis" for his career and valuable advice from the artistic staff. "I came in with [former General Director] Lotfi Mansouri, and he became a tremendous mentor for me," he says. Now "in great hands" under current General Director Alexander Neef, "I think [the COC is] the premier company in Canada."

## "It just seemed a good path to follow."

"I went to school to be a rock star," Fanning laughs of his unexpected path toward opera singing. He went to Brock University in St. Catherine's, where he studied electronic music and joined the choir; he left after a year and a half, disappointed that studying electronic music was more physics than music-making. But singing had always been on his radar, and a successful audition for the New England Conservatory started him down a more focused path. He moved on first to the University of Toronto Opera School, then to the COC Ensemble Studio. Lighthearted and cavalier about his early success, Fanning says, "it just seemed a good path to follow."

"And then it was a job, and it seemed to be a pretty good one," he says, "aside from being away from home all the time."

For any working opera singer, maintaining an over-30-year career like Fanning's is no accident. "Good advice was the big one," he says of the elements needed for longevity on the stage. His training came with plenty of advice about which roles to take and which to turn down. "I mostly sang roles I should have," he says, adding with a laugh, "with the odd exception to stretch things." Those roles have included everything from Figaro in *Il barbiere di Siviglia*, to Wotan in the COC's production of *Das Rheingold* (marking the opening of the Four Seasons Centre in 2007), to the title role in the world premiere of John Estacio's *Frobisher*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506991848467/Fanning%2C%20John%202.jpg.jpg)
<figcaption>John Fanning, Canadian baritone.</figcaption>
</figure>

## "When a student gets something, it's just amazing."

In more recent years, Fanning has made a name for himself as an educator, and has been on the teaching faculty at l'Université de Montréal for the last four years. It's fulfulling in itself, and he has found that teaching creates new challenges for his work onstage. "I really do have to be careful if I have [a singing contract] during the school year," he says of the risks of vocal fatigue. "By the end of March, I abuse my voice, I think, with the talking and teaching." He chalks it up in part to aging, too, but balancing teaching and performing begs a new level of attention to detail. "It's a little bit like going back into training for the voice."

Yet for Fanning, performing is vital to being a great teacher. "I think it's important to keep a foot in the door," he explains. "If I stop doing it, I become like a book, rather than remembering something about the physical part of it." 

Inevitably, students respond positively to a mentor who can genuinely put himself in their shoes, and Fanning takes a similar pleasure in seeing young singers take on the same challenges he did at their age. "When a student gets something, it's just amazing," he smiles. "That joy of discovery when some people go, 'I've never made that sound before!'"

He adds, "it's something that's affirmative for myself: 'Yes, this was right. I've known that for 25 or 30 years, but yes, it was right for this person too.'"

Fanning laughs at the idea of "perfecting" the art of singing, at mastering things like onstage nerves and banishing bad habits. "It's like a condition, with which we have to learn how to live, singing." He likens the process to "a batting average" that he consistently tries to raise.

"Even geezer singers will take breaths they shouldn't," he says of the all-too-human aspect to singing live onstage. "Those things never change, we just get better at dealing with them."

"I'm better at accepting that it's not going to be perfect the first time," he admits. "Perfection is in the eye of the beholder - do it with gusto and maybe they'll believe you."

>John Fanning joins the cast of [Arabella](http://coc.ca/PerformancesAndTickets/1718Season/Arabella.aspx) on the Four Seasons Centre stage from October 5-28. For details and ticket information, follow our box office links below.
