+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-01-09T11:37:00+00:00"
lastmod = "2017-01-10T10:35:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1483965173589/2017-01-09---Bridges---S-Richards.jpg.jpg"
primary_image_credit = "Photo by S. Richards Photography"
publishDate = "2017-01-10T10:13:00+00:00"
related_articles = ["articles/talking-with-singers-christine-goerke.md","articles/talking-with-singers-jorell-williams.md","articles/talking-with-singers-marina-rebeka.md","articles/in-review-dead-man-walking-at-miami-music-festival.md","articles/dead-man-walking-makes-its-minnesota-opera-debut.md","articles/a-test-of-endurance-satyagraha-at-eno.md","articles/talking-with-singers-john-holiday.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/jnai-bridges.md"]
short_description = "&quot;With track, she explains, &#039;you&#039;re competing against people, but really what you&#039;re trying to do is get your best time.&#039; Playing basketball as part of a team, &#039;you really have to be an integral part of the team that you&#039;re on,&#039; Bridges says. &#039;You have to be a player.&#039;&quot;"
slug = "talking-with-singers-jnai-bridges"
title = "Talking with singers: J&#039;Nai Bridges"
+++

"We're very sensitive beings," says American mezzo-soprano J'Nai Bridges of living the life of a singer. "We're being criticised all the time, and that's just the nature of the job." It's a mountainous task to develop the vocal technique needed to survive as an opera singer; it's another thing entirely to develop the thick skin that keeps a singer sane and healthy within a career that can depend on the opinions of others. "Inherently, whether we want to admit or not, we think about what people think of us," says Bridges, sympathising with singers who suffer from nerves and self-doubt onstage. "It's just natural, I think." 

Yet Bridges has an unexpected advantage. Before pursuing seriously her singing career, she ran track competitively and played basketball. Like many opera singers do, Bridges considers the discipline she had as an athlete, "kind of like being an opera singer."

With track, she explains, "you're competing against people, but really what you're trying to do is get your best time." Playing basketball as part of a team, "you really have to be an integral part of the team that you're on," Bridges says. "You have to be a player."

By the time she was on the audition circuit, and before she spent three years with Lyric Opera of Chicago's Ryan Opera Center, Bridges was well-trained in the psychology of competition and performance, and the relationship between the body and the mind. "I think that's why I've been successful in competitions, specifically, because I don't go in there thinking that I'm competing against anyone," she says. "I go into auditions not thinking of them as an audition. I go to perform."

She echoes some staple advice for young singers in their auditions: don't worry about who's in the room. "You literally just have to come and be prepared, because that's the only thing we can do. We only have control over ourselves."

"I am just thankful that I'm able to block all of the nonsense out. It just takes away from what I can deliver."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1483973274596/2017-01-09---Bridges.jpg.jpg)
<figcaption>J'Nai Bridges in concert with the Lyric Opera of Chicago Young Artist Showcase, 2014. Photo by Todd Rosenberg.</figcaption>
</figure>

## "There are definitely the purists out there."

Some of that "nonsense" circulated earlier this year, when Bridges was at [Los Angeles Opera](/scene/companies/los-angeles-opera/) to sing Nefertiti in Philip Glass' *Akhnaten*. A small group of sign-wielding protesters were against the casting of countertenor [Anthony Roth Costanzo](/scene/people/anthony-roth-costanzo/) in the title role, since he, a white man, would be playing an Egyptian Pharaoh (presumably with darker skin).

"I think that people's reactions are completely valid," says Bridges of the protesters' larger purpose. Yet she adds, "I think that at the end of the day, it's about who can embody the role and sing the role best." An artistic staff is charged with finding the person who can best do justice to an opera and a role. "It's what companies strive to do," and Bridges credits Los Angeles Opera with making a wise decision in Costanzo. "I think for for *Akhnaten*, with Anthony, that's what they did," she says. "His voice was the perfect voice for that, and ultimately at the end of the day, that's what it comes down to."

Even in her still-young professional career, Bridges has played characters of another race, happily without anyone batting an eye. "While I do understand people being offended when they see me singing Suzuki, or Anthony singing Akhnaten, at the end of the day it's about the music." She admits, though, "I think that there are definitely the purists out there."

"There are always going to be people who are opposed to it, and very critical, simply because of the way you look," she says, before adding with a laugh, "But that is actually not our problem."

Bridges is aware of the history of African-American singers, that "there have been black singers who are capable of a role, and who have perhaps been overseen." She's fortunate to have never experienced that kind of criticism or discrimination, "thankfully." 

This spring, Bridges will sing the role of Sister Helen Prejean in [*Dead Man Walking*](https://www.vancouveropera.ca/deadman-walking), at Vancouver Opera. "I'm the first person of colour to sing Sister Helen. I'm really excited, because I feel like I'm breaking barriers, in a way." The opera is adapted from Prejean's novel of the same name, telling the true story of death row inmate Joseph De Rocher.

"She comes to every show," says Bridges of Prejean, who also works alongside composer Jake Heggie with each production of *Dead Man Walking*. "[Heggie and Prejean] feel that my voice will fit the part very well, and I will embody the role very well," says Bridges. "I'm really excited because they can see past the colour. And there are plenty of people that do."

She's comfortable with the idea of someone in the audience who disagrees with her casting; with a smile, she adds, "but again, that's not my problem."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1483973415038/2017-01-09---Bridges---TheRapeofLucretia.jpg.jpg)
<figcaption>Bridges in the title role of *The Rape of Lucretia*, Wolf Trap Opera, June 2016. Photo by Scott Suchman.</figcaption>
</figure>

## "I swear by my Humidiflyer."

"I swear by my [Humidiflyer](http://humidiflyer.com/)," says Bridges of her tricks for staying healthy while she travels from gig to gig. "They look so insane, but it really helps," she laughs. "Also, peole are kind of afraid to talk to you, so you can get work done."

A self-proclaimed "big advocate of sleep," Bridges carries with her a simple routine of time at the gym, vitamins, and lots of water. She also takes stock of the lifestyle wherever she visits. "I love Spain. Any city in Spain, I absolutely adore," she says. "I love the lifestyle, I love the pace, which is super laid-back."

A "West Coast girl" from the Seattle area, Bridges loves her work in California. "I love, for lack of a better work, the hippiness." And of course, she finds a second home in New York. She studied at the Manhattan School of Music, and she remembers New York as "my playground."

"I was enjoying it - a lot," laughs Bridges. "If I were to live there now, I would enjoy it in a different way, a more mature way." She's already looking forward to her next New York gig, which happens to be on **January 21** with the [Marilyn Horne Song Celebration](http://www.carnegiehall.org/Calendar/2017/1/21/0730/PM/Marilyn-Horne-Song-Celebration/).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1483974117229/2017-01-09---Bridges---AndreaChenier.jpg.jpg)
<figcaption>Bridges as Bersi in *Andrea Chénier*, San Francisco Opera, September 2016. Photo by Cory Weaver.</figcaption>
</figure>

## "I just had this burning in my gut."

"I've had a lot of amazing mentors who kind of gave me the run down," says Bridges, who feels as though she was sent out of her academic years well prepared for the hectic career of an opera singer, through which she strides comfortably and confidently. "I can't imagine doing anything else," she says of her work. Though it wasn't a simple decision to decide whether to focus her time on sports or singing, "that feeling just kept coming back, *No, keep going you're on the right path*."

"As I listened to myself, I was exposed to people who were just supposed to be in my life and who encouraged me and who affirmed that I was on the right track." Music was a new pursuit for Bridges' family, who questioned her choice to forego her athletic scholarships in favour of singing. "While they questioned me, they supported me," she says, thankful for a family who respects her ambition. "This career is very difficult. It's not impossible, but it's very difficult if you don't have that support." 

"Opera chose me, and it brings me so much joy," she says, simply. "It has brought me so much more knowledge about the world and life." Bridges has always had a nonconformist air about her, and perhaps it's why she's able to look constantly forward, day by day.

"I started out not really knowing much, and I just had this burning in my gut that this was what I was supposed to do." Her gut also tells her, "there's a bigger reason why I chose to do this, and I'm finding that every day."

>J'Nai Bridges sings concerts in [New York](http://www.carnegiehall.org/Calendar/2017/1/21/0730/PM/Marilyn-Horne-Song-Celebration/) and [Hamburg](https://www.elbphilharmonie.de/en/whats-on/ndr-late-night/6953) before singing Bersi in *Andrea Chénier* at [Théâtre des Champs-Élysées](http://www.theatrechampselysees.fr/en/the-season/concert-version-of-opera/andrea-chenier-1) and at the [Bayerische Staatsoper](https://www.staatsoper.de/en/productioninfo/andrea-chenier.html). For more, follow J'Nai on [Facebook](https://www.facebook.com/jnaibridgesmezzo/?fref=ts), [Twitter](https://twitter.com/jnaimarie) and [Instagram](https://www.instagram.com/jnaibmezzo/)
