+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-12-11T10:54:00+00:00"
lastmod = "2016-12-12T15:23:00+00:00"
preamble = "Roles like Rosina, Lucia di Lammermoor, and Rossini's Desdemona have taken soprano [Jessica Pratt](/scene/people/jessica-pratt/) to stages in Italy, Germany, Spain, the Netherlands, the UK, and Australia. This month, she makes her debut at [The Metropolitan Opera](/scene/companies/the-metropolitan-opera/) as the Queen of the Night in Julie Taymor's 21st-century classic production of [*The Magic Flute*](https://www.metopera.org/Season/2016-17-Season/magic-flute-mozart-tickets/) (December 20 to January 5). \n\nPratt spoke with us about being patient with her voice, about the opinionated opera fans in Italy, and offers advice on how to be competitive in a healthy way."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481453862914/2016-12-11---Jessica---Pratt---BEalovega.jpg.jpg"
primary_image_credit = "Photo by Benjamin Ealovega."
publishDate = "2016-12-12T13:23:00+00:00"
related_articles = ["articles/spotlight-on-amanda-majeski.md","articles/talking-with-singers-christine-goerke.md","articles/4-tips-for-when-there-are-too-many-notes.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/jessica-pratt.md"]
short_description = "&quot;It is our diversity that makes for a healthy industry. I prefer to think of us all contributing in our own way, rather than all competing, which seems like such a limiting view to me. The only competition that I feel constantly is competition with myself, to try overtime to improve something in my performance or my technique.&quot;"
slug = "talking-with-singers-jessica-pratt"
title = "Talking with singers: Jessica Pratt"
+++

## What do you anticipate most about your debut in *The Magic Flute* at The Metropolitan Opera?

I'm very much looking forward to making my debut at The Metropolitan Opera in this beautiful production by Julie Taymor, the costumes of the Queen of the Night are stunning and I am very excited to be a part of such a wonderful cast.  I hope that we bring a fun and fantastical night of entertainment to families this Christmas!

## What do you find is unique about Italian opera audiences?

In the Italian language the word *melomane* (melomaniac) is commonly used to specifically refer to the more passionate opera fans. Opera audiences in Italy are very "tifosi" ("fans") and sometimes it can get a bit like a football match if they get rowdy, for example, a Sunday matinee where a large part of the Italian opera public travel around the country to see their favorite singers.  It is a very vocal public both in their approval and disapproval; they make up a strong part of the performance with their energy and involvement. Not always just applauding, but sometimes also shouting things out, words of approval or otherwise.  

There are occasionally strange moments for example, I have been onstage with my colleagues a couple of times when arguments have broken out in the public about the production in the middle of the show.  So the Sunday matinee always makes for a bit of a nerve-wracking show as the traveling public expects us to make their trip worthwhile. But they are also some of the most rewarding shows, because when the Sunday public is happy they really let you know! 

## How have you dealt with the competitive industry, especially for sopranos?

I find that in this industry there are a lot of insecurities, and of course loneliness with all the travelling, and this can sometimes make people frustrated and aggressive. The important thing is to be patient, to find common ground and to understand that at all levels we have insecurities. By trying to understand why someone is behaving in a certain way, if you cannot defuse it with kindness, at least you can see where they are coming from and that it is not personal.  

I don’t think of other singers in terms of competition. Sure, one person might get a coveted engagement or top agency, but in my experience, those things have not been my main focus as I have no control over who agents or theatres choose.  I tend to focus on what I can have some control over, and that is how I develop my technique and prepare for my performances; the rest has very little to do with me so there is not much point in using up energy worrying about it. 

We are all individual artists, no one soprano is like another physically, vocally or emotionally, what one singer lacks in technique another might lack in charisma.  It is a very subjective art form, I've often heard vastly different opinions from the public on the same production; every audience member translates what they see and hear using their knowledge and life experience, giving each audience member a very personal take on the performance. 

It is our diversity that makes for a healthy industry. I prefer to think of us all contributing in our own way, rather than all competing, which seems like such a limiting view to me.  The only competition that I feel constantly is competition with myself, to try overtime to improve something in my performance or my technique.  My main goal is to always be in some small way better than my last performance, and this takes up enough energy and time for me not to think about much else.

## What do you wish you knew about singing 10 years ago?

Singing is a life-long pursuit to master an ever-changing instrument. There is no perfect technique or concrete answer for all your technical difficulties - it is an artisan pursuit that takes many years of experience to develop, and the process is as enriching as the end result.   As we age our voice changes and so things that I found easy and natural ten years ago require technique now, and things I found impossible ten years ago now come naturally.  So, I guess I wish that ten years ago I knew that certain things simply come with age, experience and a lot of patience! 

## Why do you sing professionally?

My father was a tenor and he wanted me to be a singer, it was never really a conscious decision of mine I was just going to be a singer for as long as I can remember.  As a child I thought it was the perfect job, you got to sing, act and play dress-up in beautiful costumes and at the end of the performance people give the singers flowers!  As an adult I fell in love with opera and I really enjoy exploring all these characters and musical worlds.  I will confess that I still get a thrill when I am given an awesome costume to wear onstage like this one for the Queen of the Night in *The Magic Flute*! 

