+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-04-12T11:05:00+01:00"
lastmod = "2016-04-12T16:34:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460455467935/2016-04-12---Jamie-Barton.jpg.jpg"
primary_image_credit = "Photo: Stacey Bode."
publishDate = "2016-04-12T11:38:00+01:00"
related_articles = ["articles/talking-with-singers-christine-goerke.md","articles/talking-with-singers-nicole-cabell.md","articles/talking-with-singers-elizabeth-deshong.md","articles/talking-with-singers-othalie-graham.md","articles/talking-with-singers-melody-moore.md","articles/talking-with-singers-bryan-register.md","articles/spotlight-on-samantha-pickett.md","articles/singing-tso1617-renee-jamie-weill.md","articles/talking-with-singers-elza-van-den-heever.md","articles/album-review-all-who-wander.md","articles/talking-with-singers-sondra-radvanovsky.md","articles/the-ride-of-the-dragkyries-how-to-name-an-opera-drag-queen.md","articles/talking-with-singers-angela-gheorghiu.md","articles/talking-with-singers-angela-meade.md","articles/spotlight-on-rihab-chaieb.md","articles/spotlight-on-emma-char.md","articles/talking-with-singers-lisette-oropesa.md","articles/simone-osborne.md","articles/barton-leads-fantasy-cast-in-wnos-don-carlo.md"]
related_companies = ["scene/companies/washington-national-opera.md","scene/companies/the-metropolitan-opera.md","scene/companies/san-francisco-opera.md","scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/jamie-barton.md"]
short_description = "&quot;This seems a bit cliché in terms of mezzo roles, but dude, throw me a Carmen. I would love to sing a Carmen. I think I would sing the pants off of her. And she&#039;s also, once again, a character who is so fascinating to me, psychologically.&quot; Barton is eager to portray opera&#039;s infamous, hedonistic femme-fatale as &quot;someone who is not the typical body type. I think that is an envelope I would love to try and push, given the right director and the right production.&quot;"
slug = "talking-with-singers-jamie-barton"
title = "Talking with singers: Jamie Barton"
+++

We had the chance to talk with American mezzo-soprano [Jamie Barton](/scene/people/jamie-barton/) between rehearsals for [Washington National Opera](/scene/companies/washington-national-opera/)'s upcoming [*Ring Cycle*](http://web.kennedy-center.org/Marketing/Ring/Landing), where she'll be singing Waltraute in *Götterdämmerung*, and covering Fricka in *Die Walküre*. She has been in Washington for about two weeks, prepping for the *Cycle*'s April 30th opening. "I'm just now in cover stagings for Fricka," says Barton. "We were doing the first scene of Wotan and Fricka this morning. I think tomorrow is *Valkyries*. There's a lot of German happening right now!"

In her mid-30s, Barton is familiar with the gamble that can be found in singing Wagner's music. "As a singer, especially a young singer, they tend to say 'don't do Wagner, don't sing it, don't listen to it, just stay away Wagner, it'll hurt your voice'." For her, the difference lies less in age, and more in whether or not a singer is "built to sing it". "It's easier for me to sing this music than it is for me to sing *bel canto*, like, by miles. It's so much harder doing an Adalgisa."

*Bel canto* is fairly new for Barton; she's had great success with roles like Adalgisa (*Norma* )in [Los Angeles](/scene/companies/los-angeles-opera/) and [San Francisco](/scene/companies/san-francisco-opera/), and as Giovanna Seymour (*Anna Bolena*) in [Chicago](/scene/companies/lyric-opera-of-chicago/) and opposite [Sondra Radvanovsky](/scene/people/sondra-radvanovsky/) at [The Metropolitan Opera](/scene/companies/the-metropolitan-opera/). She loves the repertoire, and she admits "it is a lesson in getting your ass kicked every once in a while." For Barton, *bel canto* is not "roll-out-of-bed-and-sing music"; it takes a calculated amount of attention to her instrument. "I have to be so careful, and I'm not that kind of a singer. I'm not neurotic, my cords are really dependable. They just get super touchy when I do *bel canto*."

In contrast to the conscious care required in Bellini and Donizetti, Barton relishes the smart vocal writing in Wagner's music. "It's really an Italianate kind of composition, very very smart," she says. The common impression is that Wagnerian singers are constantly working to be heard over huge amounts of sound coming from the orchestra. Barton notes that "for all the bombasticness of the composer, that happens *around* the vocal singing, not so much *with* the vocal singing." Singers who find comfort in this music tend to ride comfortably, without the need for extra muscle. "You don't have to push, you don't have to manipulate to sing over an 80-piece orchestra, because for most of the time you're not, at all."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460475257648/JamieBartonCreditStaceyBode4.jpg.jpg)<figcaption>Photo by Stacey Bode.</figcaption>
</figure>

## "I think mezzos have it good."

There are plenty of mezzo-sopranos who confess some level of soprano envy, but not Barton. "I think mezzos have it good. We get some really complicated people." Though they're not easy to sing, one gets the sense that Barton could spend endless amounts of time peeling back the layers of characters like Adalgisa, Fricka, and Handel's Cornelia.  "It took me forever to really get into liking Jane Seymour in *Anna Bolena*," she says. "You can very much play her the villain, but I think that's the easy way out. I think she's in a tough position." She finds similar tension in roles like Mère Marie in Poulenc's *Dialogues des Carmélites*. "I think she is a fascinating woman, one who has a lot of hangups, but at the same time wants to do the right thing."

So, where does she begin with these layered women, full of options? With the words, of course. "My job is that of a storyteller; my tools are not just words but music as well, and movement onstage. But it comes down to the words, first and foremost." She spends lots of time poring over her character's text, and often more importantly, the text of the other characters. It comes in handy in earlier music, where the words are sparse and the notes are plentiful. "If you're in a Handel piece and you've got an ABA composition of an aria, what are you going to do to make that return of the A mean something? Why do they say the same thing a bagillion times in bel canto?"

It's one of the tough parts of a singer's career, to grow familiar enough with an opera's text in order to understand it; strong opinions about her character inevitably come out of this stage of work, yet she's always careful to leave some wiggle room for the director. "Mère Marie, great example," she recalls. "I was in love with the opera beforehand, I was in love with this character. I came in with very strong ideas that were immediately dashed due to the production." Similarly, her Cornelia at Oper Frankfurt turned out to be "a very different woman. I had to find a way to connect with that."

We had to ask: how difficult is that balance, to shift her ideas of a character that have come from her own intensive work on the score? "It's difficult when both parties are unmovable," says Barton, smiling. "Even when I have very strong opinions about something, if you can convince me within the context of a production of a completely opposite view, then I will leap for you onstage, I will do what I need to do. If I can't be convinced, then I can't convince the audience. It's a team effort."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460475235844/JamieBartonCreditStaceyBode2.jpg.jpg)
<figcaption>Photo by Stacey Bode.</figcaption>
</figure>

## Barton, offstage

With her thick, cerebral regimen of rehearsals and practice, Barton has found a few ways to shake off the days and unwind from work. "These days it involves a lot of watching *RuPaul's Drag Race*," she laughs. Music plays a role in her off-hours, too, and those playlists can look very different than the music found on her own résumé. They include classical music, and even some Wagner. "There are some things I listen to almost religiously." But of course, "there are times where it's time for some Ke$ha, or some Lady Gaga, like, let's just turn the brain off, kind of deal."

Cooking works, too. Barton jokes (?), "I would make an excellent sous-chef, because I love the process of just chopping things. That, to me, is really great way to unwind from a very cerebral kind of rehearsal." It's not mindless, she adds. "You can't have your head somewhere else, if you want all of your fingers!" Repetitive tasks can be a sort of "meditation away from the cerebral area of trying to learn staging, getting into a character."

Barton grew up on a farm, surrounded not by classical music, but by Bluegrass. "That's kind of where I think I got an ear for virtuosic music. I absolutely still love it," she says, enthusiastically. "If I'm ever listening to Bluegrass then I'm probably missing home a little bit." She's a big fan of Chris Thile's music, and his collaborations with the Punch Brothers. "It is everything from Brandenburg Concertos to their own music which sounds at times very traditionalist for Bluegrass, and then at other times," she chuckles, "like Schoenberg had a baby with Earl Scruggs." While at the Aspen Music Festival one summer, Barton went to hear the Punch Brothers in concert. She was hooked, and she has since gone to see them perform as often as she can. "Every single time I am moved to tears at some points, to uncontrollable glee, to giggling out of sheer confusion and delight that they could create this music."

Barton sees a decent overlap with the evolution of Bluegrass music, and what's happening with classical music. "My own personal goal at some point is to figure out a way to bridge the gap between an art form that I grew up loving and listening to and doing, and an art form that I now do on a daily basis."

## Verdi, Carmen, and other challenges

Even with her enviable CV of mezzo roles, Barton still has her wish list for the future. Roles like Amneris and Ulrica are near the top, and she's waiting patiently for her voice to grow into the demands of these characters. "I would love to do a Sister Helen in *Dead Man Walking*," she adds. "I think that's a fascinating opera; so hard. It makes the audience seriously question things."

"This seems a bit cliché in terms of mezzo roles, but dude, throw me a Carmen. I would love to sing a Carmen. I think I would sing the pants off of her. And she's also, once again, a character who is so fascinating to me, psychologically." Barton is eager to portray opera's infamous, hedonistic femme-fatale as "someone who is not the typical body type. I think that is an envelope I would love to try and push, given the right director and the right production."

It may seem an odd comparison, but Barton sees plenty of Carmen-like traits in *RuPaul's Drag Race*. "[Latrice Royale](http://latriceroyale.com/) is this huge, gorgeous, amazing drag queen, who is, in her words, 'curves and swerves, chunky yet funky'. You cannot look at this person and deny that there is beauty and magnetism. Those are the two things that I think Carmen has in spades."

In the midst of opera's years of being HD-ready, paired with an increasingly inclusive mainstream media, Barton finds it easier than ever to look at an artist's work, rather than their bodies, to move people. "If you can yank me out of reality and put me in the middle of the show with you, I am on board." Barton goes to the opera to stop thinking about her to-do lists, all those mundane aspects of human reality. "You can be a Natalie Dessay, a tiny, tiny, tiny person, or you can be a bigger person like me, and as long as you're doing your job, I'm a happy audience member."

>Wagner's Ring Cycle runs at Washington National Opera April 30-May 22. For details and ticket information, follow our box office links below.
