+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-03-14T18:41:20+00:00"
disclaimer = ""
image_gallery = []
postamble = "_Berenice_ runs at ROH's Linbury Theatre 27 March to 7 April in a co-production with the London Handel Festival. For details and ticket information, [click here](https://www.roh.org.uk/productions/berenice-by-adele-thomas)."
preamble = "American soprano [Jacquelyn Stucker](/scene/people/jacquelyn-stucker/) is currently in London, gearing up for Handel's _Berenice_, directed for the Linbury Theatre by Adele Thomas. In this co-production with the Royal Opera House and the London Handel Festival, Stucker takes on the trouser role of Alessandro, whom she describes as equal parts Atticus Finch, Fred Astaire, and Barack Obama. We chat with Stucker, about Handel's tricky scores and the lovely weirdness of her job."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1552588824/media/2019/03/sqJacquelynStuckerJonathanNesteruk.jpg"
primary_image_credit = "Photo: Jonathan Nesteruk."
related_articles = ["articles/spotlight-on-jennifer-davis.md", "articles/orpheus-eurydice-in-the-hands-of-a-theatrical-genius.md", "articles/in-review-partenope-at-eno.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/jacquelyn-stucker.md"]
short_description = "\"Handel wrote this role for castrato Gioacchino Conti, who was, by all accounts that I read, a complete freak of nature: he could allegedly sing high Cs (as in, C6), and while he preferred to sing roles with more lyrical material, he was known to be equally virtuosic in how he executed coloratura.\""
slug = "talking-with-singers-jacquelyn-stucker"
title = "Talking with singers: Jacquelyn Stucker"
youtube_url = ""

+++
### Why do you sing professionally?

Because where else but in a David Alden production am I going to get to have a slow-motion water gun fight against a group of acrobats in monkey costumes? It was the dream I didn't know I had for myself, to be asked to kick some ass in a slow-motion fight onstage, and I got to do it at one of my favorite places in the entire world — The Santa Fe Opera — in my professional debut alongside some really legendary singers: Paula Murrihy, Alek Shrader, Christian Van Horn, Daniela Mack, and Elza van den Heever.

### What kind of person is Alessandro in _Berenice_?

In my mind, Alessandro is one-third Atticus Finch, one-third Fred Astaire in _Roberta_, and one-third Barack Obama during his speech at the 2004 Democratic National Convention — this is to say: my husband aside, Alessandro is, to wit, my definition of the perfect life partner. He's empathic and patient; he's very much aware of his emotions, and is both able and willing to articulate them; he is intelligent and thoughtful and honest; he rejects the idea that violence is ever a potential response to conflict (unless someone's life needs saving, as is the case in Act I!); he has values that he's completely unwilling to compromise — and, most important of all, he understands what it means to respect himself and other people.

At virtually any point in the opera, he could simply force Berenice through any number of means to marry him, but — whenever he is confronted with an opportunity to actually do it — he dismisses the idea. He respects her enough to accept whatever she chooses for herself, and he respects himself enough to wait for a partner who actually wants to be with him.

To be clear, it's not as though he doesn't want to be with her: he falls hopelessly in love with her at first sight, and his affection for her only grows deeper and more ardent as the opera progresses. He's only human, and he has moments where his love for Berenice nearly overpowers his integrity. However, these moments of emotional struggle and ethical dissonance give him opportunities to really come into himself as a person.

Alessandro rises to each and every one of these challenges throughout the opera and he successfully self-actualizes from a wide-eyed young prince into a self-assured, self-respecting man who is ready to become king.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552605268/media/2019/03/JacquelynStuckerJonathanNesteruk.jpg){{% /md %}}

<figcaption>Photo: Jonathan Nesteruk.</figcaption>  
</figure>

### What do you find the most challenging of Alessandro's traits?

For me, it is the technical difficulty of Alessandro's music that most challenges me: from his first aria (which nearly spans two octaves and is, essentially, just under six minutes of non-stop fioratura) to his last aria (an awkwardly andante _sicilienne_ written almost entirely in a modern soprano's secondo passaggio), Alessandro's music stretches me to my vocal limits.

Handel wrote this role for castrato Gioacchino Conti, who was, by all accounts that I read, a complete freak of nature: he could allegedly sing high Cs (as in, C6) with absolute _sprezzatura_, and, while he preferred to sing roles with more lyrical material, he was known to be equally virtuosic in how he executed _coloratura_. I offer this as a possible explanation for why Alessandro's music is so relentlessly technically demanding.

### As a performer, what can you do in a smaller venue like the Linbury Theatre, that you can't do in a large theatre? What are the unique demands on a singer in a intimate space?

The Linbury Theatre has been closed since the very beginning of my time at ROH, so tech week for _Berenice_ is the first time I will perform in the space. From what I understand about the conception and purpose of the theatre, the Linbury was designed to be both extraordinarily flexible and technologically cutting-edge in terms of how it accommodates a variety of different performing arts disciplines, so I'm excited to experience it all for myself for the first time in just a few days.

### What do you know now about the singing career that you wish you knew 10 years ago?

"Don't learn diction; just learn the language."

### If you didn't sing for a living, what would you do instead?

Move to Alsace and beg Hubert Trimbach for a job at his vineyard.