+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-11T13:40:00+01:00"
lastmod = "2017-04-08T12:19:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1491650350219/2017-04-08---Werner-Rutter.jpg.jpg"
primary_image_credit = "Photo by Nick Rutter."
publishDate = "2016-10-14T09:45:00+01:00"
related_articles = ["articles/in-review-scenes-from-the-end.md","articles/in-review-the-reimagined-winters-tale.md","articles/dont-miss-the-other-side-of-the-sea.md"]
related_people = ["scene/people/heloise-werner.md"]
short_description = "&quot;Getting a job at the Royal Opera House in the chorus, for me, even if that would be amazing for most other singers, I wouldn&#039;t like it.&quot; Werner is aware of the different pursuits of professional singers - career stability, for example. &quot;I can totally understand why most people aren&#039;t like me.&quot;"
slug = "talking-with-singers-heloise-werner"
title = "Talking with singers: Héloïse Werner"
+++

With her mismatched earrings and generous smile, chatting with soprano [Héloïse Werner](/scene/people/heloise-werner/) was a breath of fresh air. The 25 year-old singer, cellist, composer, and producer is one of the most industrious young artists working today, and she shows no signs of letting up.

"I tend to be more happy when I've got stuff to do," says Werner of packed calendar, full of everything from the traditional to the novel. "I don't think I'd ever get tired of it."

Werner was born in Paris, where she studied cello at the Conservatoire, and for six years was a member of Maîtrise de Radio France, the French national radio children's choir. "We had school in the morning, and after we had choir practice and music," Werner says of her first taste of touring with the choir, while maintaining a well-rounded education. 

In fact, one of her first artistic crises was the choice between pursuing music and science. "I did really enjoy science, and I wanted to keep that going," she says. "I actually decided to study medicine. I did a week, and then I was like, 'Oh my god, I don't know!'" Werner chose to suspend her degree in medicine, and focused her sights again on music. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1491650339209/2017-04-08---Werner-Rutter-2.jpg.jpg)
<figcaption>Photo by Nick Rutter.</figcaption>
</figure>

"At the time, I couldn't speak English," she recalls. "But in France, basically if you want to go into music, you have to go to a Conservatoire straight away. You can't go to a university, it's not very good." She instead moved to England, where she worked for several months as an *au pair* to learn the language and ease the significant transition.

At the suggestion of a friend, Werner applied - and was accepted - at Cambridge University's Clare College. Now, she sees the true value of her time studying music, in the pool of colleagues - the "loads of friends" she met at a student. "In that respect, Cambridge - and it could have been any university - was amazing because I made those contacts." Like most of her university friends, Werner moved to London, where she has made a name for herself in contemporary music circles.

"It has so much to do with the people you meet," she says of the small, yet industrious circle of musicians who share Werner's love of the new and creative. A move to the UK wasn't part of any larger plan she had for her own career, and similarly, "I don't really know what I'm going to do in five years' time." Currently, she is pursuing a Master's degree, "just to keep having singing lessons and making sure that my technique is good enough and that I don't lose my voice."


<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476361120876/2016-10-13---Werner-Rutter-1.jpg.jpg)
<figcaption>Photo by Nick Rutter.</figcaption>
</figure>

It's a universal truth for any singer, and for Werner, her love for contemporary music, and "using my voice in a different way," can pose an added risk to her instrument. "Vocally, I need to be careful that I don't do literally anything and lose my voice in five years, because I shout and do weird things," she laughs.

One of those "weird" pursuits is Werner's involvement with [The Hermes Experiment](http://www.thehermesexperiment.com/), a quartet of voice, clarinet, harp, and double bass. Formed with friends she made at Cambridge, The Hermes Experiment was an answer to the tough question of how to find an outlet for the kind of performance she wanted, and in those tricky first years following graduation. "I was really interested in vocal contemporary music, but at the time I didn't know where to start," she explains, adding that the idea of forming a group seemed less daunting than starting out on her own.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/KvHhCLUw3qA" frameborder="0" allowfullscreen></iframe>
</figure>

"After we graduated, I just had this idea of forming the quartet, with this combination of instruments, which is sort of weird," Werner admits. Since its inception, The Hermes Experiment has become a fixture in the UK's contemporary music scene, both out of the members' love for new music, and out of necessity. "We commission composers to write for us, because basically there's no repertoire for this combination," says Werner. "We also do  a lot of free improvisation, and we also create our own arrangements of pieces." 

Most of the quartet studied composition during their university years, and writing music is something that Werner enjoys herself. Now, their exhaustive work has paid off. "For three years we'd be working really hard at contacting people, inviting them to hear our work. Now, festivals contact us, and we're quite busy," she says, adding with a laugh, "We make money now!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476361094887/2016-10-13---SFTE-Rutter-1.jpg.jpg)
<figcaption>Héloïse Werner in *Scenes From The End*. Photo by Nick Rutter.</figcaption>
</figure>

Werner also keeps busy with her own projects, including her one-woman show, [*Scenes From The End*](https://www.tristanbatestheatre.co.uk/whats-on/scenes-from-the-end), which premiered at the Camden and Edinburgh Fringe Festivals, and will come to London in December. "It's a one-woman opera, although I found that calling it an opera is actually wrong, because a lot of it doesn't involve singing," she explains. Werner commissioned composer Jonathan Woolgar to write *Scenes From The End*, and she worked closely with him and director Emily Burns to create a cohesive commentary on grief and death.

"The first part grieves for the end of the universe, the second part grieves for the end of humanity, and the last part grieves for an individual," ways Werner. "It explores various things and raises issues about grief and death, and how, in our society, we deal with grief." Inspired by her own experiences with grief, Werner took the opportunity to use her voice "as the main medium to express feelings and ideas in a very direct way." The one-woman opera is for *a cappella* voice, featuring Werner alone on stage, with a few added elements like percussion instruments, upstage projections, and what she calls "physical theatre."

"A lot of people who saw it said they've never seen anything like it before, which I like," says Werner of the initial reception of *Scenes From The End*. "I was really pleased. It's not meant to be just for a musical audience or a theatre audience."

Werner has come to recognize, as a soprano in a competitive industry of many, where her unique strengths lie, and how she can put them to best use. "I think it's true, that unless you're incredibly lucky and have the voice of an angel, that's a lot better than everyone else or has a quality that no one else has, it's incredibly hard to become a 'successful' opera singer." Yet with her strong background as a cellist, and her experience in composition and choral work, Werner has skills that not every professional singer can boast.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476361106548/2016-10-13---STFE-Rutter-2.jpg.jpg)
<figcaption>Héloïse Werner in *Scenes From The End*. Photo by Nick Rutter.</figcaption>
</figure>

"Some people take so long to learn their music that it feels like ages before we actually block it and do it," she says of the more traditional process of rehearsing opera. "At the end it's great, but the whole music rehearsal process, I find quite long and tedious."

"In the rehearsal process I like suggesting things and being involved," she admits. Although she has experience as a producer and even a director, performing is still at the top of Werner's priorities. For her, artistic autonomy is key. "If I have an idea, I'll tend to just do it and make it happen - and actually make it happen, not just talk about it," she says of her strong worth ethic, which matches her drive for creativity. Her work with ensembles like The Hermes Experiment, and collaborating with folk band, The Coach House Company, speak to her love of communcal music-making; yet when it's all up to Werner, "If anything, I put more energy into it. At the end of the day, it's me who wants to do it."

"Getting a job at the Royal Opera House in the chorus, for me, even if that would be amazing for most other singers, I wouldn't like it." Werner is aware of the different pursuits of professional singers - career stability, for example. "I can totally understand why most people aren't like me." Yet at the same time, she has that special combination of love and discipline that allows her to put her skills into the paths that inspire her the most. 

"I get really excited by things that I create myself," she puts it, simply. "I just want to live my life and do what I want to do."

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/aLuMU8DvPoY" frameborder="0" allowfullscreen></iframe>
</figure>

>For details and ticket information for Scenes From The End, December 6-10 at London's Tristan Bates Theatre, [click right here.](https://www.tristanbatestheatre.co.uk/whats-on/scenes-from-the-end)
