+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2020-03-09T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "The [London Handel Festival](https://www.london-handel-festival.com/) runs through 5 April."
preamble = "After her 2018 win at the [Handel Singing Competition](https://www.london-handel-festival.com/handel-singing-competition/), British mezzo-soprano [Helen Charlston](/scene/people/helen-charleston/) returns to the London Handel Festival, ongoing through 5 April. Charlston sings Counsel/Truth in Handel's allegorical oratorio [_The Triumph of Time and Truth_](https://www.london-handel-festival.com/show/the-triumph-of-time-and-truth-hwv-71/?event=15402) on 17 March; on 1 April she'll sing Isabella in [_Fernando, Re di Castiglia_](https://www.london-handel-festival.com/show/fernando-hwv-30/?event=15802), Handel's fragmented work that gets its full, overdue debut in a new critical edition, with Leo Duarte conducting the Orchestra of Opera Settecento.\n\nWe spoke with Charlston about the joy of singing Handel, and her curious wish-list of roles."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1582773868/media/2020/02/sqHelen-Charlston-c-BenMcKee_zriphx.jpg"
primary_image_credit = "Photo: Ben McKee."
related_articles = ["articles/spotlight-on-stephanie-tritchew.md", "articles/talking-with-singers-eszter-balogh.md"]
related_companies = []
related_people = ["scene/people/helen-charleston.md"]
short_description = "\"'Good singing' is getting the very best out of your voice; a partnership between a solid technique and a need to let your voice be heard. We all only have our own sound, and there is nothing more thrilling than listening to singers who let their voice flood out direct to our hearts.\""
slug = "talking-with-singers-helen-charlston"
title = "Talking with singers: Helen Charlston"
youtube_url = ""

+++
## Why do you sing, and why are you doing it professionally?

Being a professional musician is a hugely rewarding career. It is collaborative, creative and immense fun, and I was in no doubt when I realised that I might be able to spend all of my time making music that was so worth working for. On quite a primal level though, I also have come to realise that actually I couldn’t have made any other decision. I sing because I cannot not. I have a lot I want to share as an artist, and hope that I will continue to make music for an with people as my chosen route of expression to move people and cause them to stop and think in their lives.

## What does "good singing" mean to you? What does it feel like when you achieve it?

"Good singing" is getting the very best out of your voice; a partnership between a solid technique and a need to let your voice be heard. We all only have our own sound, and there is nothing more thrilling than listening to singers who let their voice flood out direct to our hearts. Singing should be free and liberating for both the performer and the audience. I feel strong, powerful and extremely connected to the music when I achieve that: almost invincible and ready for anything!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1582774455/media/2020/02/HelenCharlston-BenMcKee_zmrmnl.jpg){{% /md %}}

<figcaption>Helen Charleston, mezzo-soprano. Photo: Ben McKee.</figcaption>

</figure>

## What do young singers need to do more of? What should they do less of?

I think there are no hard or fast rules. Every career and voice develops differently, and probably the most important thing that everyone could do more of (and I really need to remind myself to practice what I preach here) is patience, and trust in our own skill and hard work to move us forward. That said, I would also advocate saying yes to everything you can: you’ve no idea what door one opportunity might open, or what you might learn from the other performers around you. There is no better way to learn that by doing – I am continually inspired by the people with whom I share the stage, watching them is some of the best education you can get.

## What do you think are the unique challenges and pleasures of singing Handel's music?

Handel’s music is immensely fun to sing, it sits under the voice so well and every time I come back to Handel its like coming home. Technically, of course, it is not easy music often requiring extended passages of coloratura or extremely expansive hushed lines. One of the real pleasure though is that often throughout his operas, each character gets to follow all the different character tropes and the relevant music styles that relate (the fiery vengeful arias, slow plaintive melancholy of a lost love, bubbling excitement of a new desire just to name a few) and so you feel that you go through a wonderful journey dramatically and musically.

One of the unique challenges to my voice part is the prevalence of trouser roles. I’m tall (6 foot in fact) so I have quite the height advantage in this department and so feel quite at home in this, but it means that I do more often spend time singing words sung by men than by women.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1582774359/media/2020/02/HelenCharleston-BenjaminEalogeva_q5snla.jpg){{% /md %}}

<figcaption>Helen Charleston, mezzo-soprano. Photo: Benjamin Ealovega.</figcaption>

</figure>

## Do you have any bucket-list roles you would like to sing (realistically or otherwise)?

Something that has been high on my list for a long time is Irene from Handel's _Theodora_. If anyone hasn't seen the [video of Lorraine Hunt Lieberson](https://www.youtube.com/watch?v=IQlt1UxjvWU) singing this at Glyndebourne in the late 1990s then do, it will change your life. Its extraordinary music, and Irene is a fascinating character – she’s almost not human but a metaphor of faith itself. In fact, she disproves my point about characters getting to sing all the different styles of musical character as they develop: she doesn’t change through the opera but is constantly devout and gets to sing some of the most beautiful music. Excitingly though, I am currently learning that so she will soon be ticked off the list for the first time!

The wish list is pretty long, but some instant standouts are Dido (Purcell), Orfeo (Gluck), Cesare (Handel) and I am waiting with great excitement for a chance to sing the Angel in Elgar's _Dream of Gerontius_ for the first time as well.

## How do you explain your job to non-music folks?

I have a feeling my friends would say, not very well. I tend to say I am lucky to get to spend all my time doing what I love, but it’s sometimes hard to really give people a sense of what you’re up to on a day-to-day basis, particularly if you’re in a very preparation/audition heavy period. Of course, I don’t spend every working hour performing: there are rehearsals to be accounted for, practice at home, lessons, auditions and coachings, as well as writing emails, planning programmes, learning translations and memorising words. So spinning lots of plates just like any job, I imagine!