+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-05-13T20:59:00-04:00"
lastmod = "2018-05-13T21:17:00-04:00"
preamble = "American soprano [Hailey Clark](/scene/people/hailey-clark/) is currently in Switzerland, where she is nearly through her first season with the ensemble at Theater Basel. She is set to sing the role of Anne Trulove in a new production of [*The Rake's Progress*](https://www.theater-basel.ch/Schedule/The-Rakes-Progress/oYxgCgJO/Pv4Ya/), directed by Lydia Steier, running **May 18 to June 24**. She will share the stage with fellow American singers Matthew Newlin as Tom Rakewell and Seth Carico as Nick Shadow.\n\nWe spoke with Clark about the nuances of playing an archetypal role like Anne Trulove, and how she balances her artistic profession with the realities of being an entrepreneur."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526257682779/sqHaileyClark7.jpg.jpg"
primary_image_credit = "Photo: Eric Melear."
publishDate = "2018-05-13T20:59:00-04:00"
related_articles = ["articles/spotlight-on-shelley-jackson.md"]
related_people = ["scene/people/hailey-clark.md"]
short_description = "&quot;The sooner you can define who you are and what you do best, the easier it is for people to identify and understand your &quot;brand.&quot; This is an artistic field, of course, but it&#039;s also a business, and in order for companies to sell tickets and keep the art form alive, it&#039;s important for them to know the three-dimensional artist that they’re hiring and trusting to tell their story.&quot;"
slug = "talking-with-singers-hailey-clark"
title = "Talking with singers: Hailey Clark"
+++

## Why do you sing professionally?

Singing opera for a living synthesizes many of my greatest loves: people, travel, creativity, marketing and adventure.  As a professional singer, I am constantly engaging with diverse new teams and personalities on a variety of projects, and challenging myself to learn new languages and hone my technique as my voice grows and matures. It’s a thrill getting to explore new places (and cuisines!); one is never bored, and one is never "finished." I also find it a tremendous opportunity as both an extrovert and a "feeler" to have permission to draw on both of those aspects of myself to help others unlock and confront their own thoughts, emotions, biases and reactions.

I'd also be lying if I said being an entertainer and a storyteller hasn't been a part of my fabric since I could walk and talk. (Cue sassy home videos of interviews with pets and live concerts as *The Little Mermaid*.)

## What do you know now about the singing career that you wish you knew 10 years ago?

Wow, I feel like I could write a book on that. Ha! First, I would say that singing for a living is about so much more than just singing.  Success in this field is defined in a million ways, but it will always demand that you be your own bookkeeper, personal trainer, guardian of sleep, marketing director, networker, and mental health advocate, even if you have hired people to help you take on these tasks. 

The sooner you can define who you are and what you do best, the easier it is for people to identify and understand your "brand." This is an artistic field, of course, but it's also a business, and in order for companies to sell tickets and keep the art form alive, it's important for them to know the three-dimensional artist that they’re hiring and trusting to tell their story.

Finally: if you want to work in Europe, start learning to speak German. Yesterday.

### What kind of woman is Anne Trulove? What do you think are some common misconceptions about her character?

Since this opera is based on a series of paintings by William Hogarth, Stravinsky and his librettist W.H. Auden have woven a narrative to connect these "scenes," and in this depiction named the characters each to represent an Archetype. Anne, like her name, is the representation of "true" love: unselfish, faithful, steadfast.  One of the traps of playing an archetype is to fall into the portrayal of an overall "mood" or a depiction defined by a concept, rather than creating a flawed, dimensional, and dynamic human being. 

It's easy looking at this story with broad strokes to think that Anne is silly and naïve for following a man who has clearly shown through his immaturity and a series of devastating choices his disrespect toward her.  She is simple in that her experience of the world is somewhat limited, but she is not a doormat.  I find the fact that she wrestles with her duty and identity, and pushes through the pain of betrayal and abandonment in order to help someone who she believes to be truly in need of her help to be infinitely complex, selfless and mature beyond her years. 

Our director Lydia Steier has taken great care in defining relationships between each character, and I feel fortunate that my colleagues, (Seth Carico singing Nick Shadow, Eve-Maud Hubeaux as Baba the Turk, and tenor Matthew Newlin in the title role), are incredibly giving, adaptable and dynamic actors able to make this an even more relatable tale.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526259464333/_U2_5530_Clark_Newlin_Carico-c-LucianHunziker.jpg.jpg)
<figcaption>Hailey Clark, Matthew Newlin, and Seth Carico in *The Rake's Progress*, Theater Basel, 2018. Photo: Lucian Hunziger.</figcaption>
</figure>

## What does *The Rake's Progress* have to say about romantic relationships, and how people treat the ones they love?

I'm definitely still exploring this. The opera tells the heartbreaking story of a man destroyed by depravity, and the two people (Anne and Baba) wounded and abandoned in a cyclone of his destruction.  I believe the creators of this opera (Stravinsky, Auden, Hogarth), and our artistic team in this production find this to be the ultimate cautionary tale.  The final words an audience hears in the Epilogue are: "For idle hands and hearts and minds, the Devil finds a work to do. A work, dear sir, fair Madam, for you — and you."

I think it's a valuable warning to a modern audience, especially in a culture inundated with the 24-hour news cycle and the pressure to curate a virtual identity and "highlight reel" on social media, that we are ultimately all accountable for our own actions.  That life is empty if it is devoid of substantive experiences and interactions, especially in our tendency to "show" the world what we're doing rather than remaining present and honest. That we should never take for granted the ones whom we love, and who love us in return.

## If you didn't sing for a living, what would you do instead?

I would absolutely do something involving arts advocacy, children, or animal advocacy (or all three!)  For now I get my fix seeing my nieces and nephews when I can, and volunteering with animal rescue organizations wherever I'm living.  My husband and I fostered dogs for "Animal Care Austria" when we lived in Vienna, and now I spend 5-10 hours per week with the animals, employees and volunteers at the animal shelter across the German border in Weil am Rhein, DE.  Maybe one day I'll open a giant ranch for rescue animals!

>The Rake's Progress is onstage at Theater Basel May 18 to June 26. For details and tickets, [click here.](https://www.theater-basel.ch/Spielplan/The-Rakes-Progress/oYxgCgJO/Pv4Ya/)
