+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-11-03T16:18:00+00:00"
lastmod = "2016-11-08T10:00:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478529486369/2016-11-07---Gyula-Nagy.jpg.jpg"
publishDate = "2016-11-08T10:00:00+00:00"
related_articles = ["articles/talking-with-singers-david-shipley.md","articles/talking-with-singers-kate-lindsey.md","articles/spotlight-on-owen-mccausland.md","articles/talking-with-singers-levente-molnr.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
short_description = "He takes seriously the artistic work he does as a singer, yet the come-what-may attitude that Nagy has about his pursuit of singing is one of his biggest advantages. &quot;If I hadn&#039;t gotten this [position at the ROH], then probably I would have gone on auditioning on my own,&quot; he says of the Jette Parker programme&#039;s influence on his career. &quot;I would have managed somehow. It would have been really different, but there would have been another way.&quot;"
slug = "talking-with-singers-gyula-nagy"
title = "Talking with singers: Gyula Nagy"
+++

"The whole [singing] thing came from shouting Guns n' Roses at home," laughs Gyula Nagy, the Hungarian baritone who is a new member of the Jette Parker Young Artists Programme with the [Royal Opera House](/scene/companies/royal-opera-house/). "'Paradise City' and all these things." Nagy's parents figured if he would continue "shouting," some voice lessons would be in order. 

"He was a classical teacher, so I started singing Handel and things like that, which I started to love," recalls Nagy. His love of singing "just grew and grew," and he continued to pursue private voice lessons. He did one year at a conservatory, but soon transferred University of Pannonia in Hungary, where he studied English Literature and Linguistics.

"But I couldn't get away from singing," smiles Nagy. "I started having lessons again." After graduation, he started working as a teacher, "which was grand, but I felt that I should at least try this thing, at least once more." He studied at the Royal Irish Academy of Music in Dublin and at the National Opera Studio in London; he then joined the Opera Theatre Company’s Young Associate Artists Programme in Dublin, and sang as an Associate Artist at Welsh National Opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478529726047/2016-11-07---Oreste-1.jpg.jpg)
<figcaption>Gyula Nagy in rehearsal for Handel's *Oreste* at Wilton's Music Hall. Photo by Roger Way Photography.</figcaption>
</figure>

Now, as a young artist with the Royal Opera House, Nagy admits that he never dreamed of singing at such a major house, and he certainly value of his time with the company. "You have to dedicate yourself to it," says Nagy, who found himself in the middle of rehearsal for *Il barbiere di Siviglia* on his first day with the ROH. "Everybody was quite nice, and it was quite calm," he recalls, laughing that, "the dress rehearsal was the worst, because that was the first time I sang on that stage."

For a young artist at a major house, a huge portion of learning happens simply by observing professionals in action, "Just being around them, sitting in rehearsals and watching how they work." Nagy is no different, and he finds the rehearsal room a "pretty inspiring" space. He observes technical habits of mainstage singers, "how free they are, what colour of sounds they use." Even being up close with the artists onstage can be a picture that's worth a thousand words. "It was inspiring to see how everything is a bit exaggerated," says Nagy.

This season with the Royal Opera House, Nagy sang Fiorello in *Il barbiere di Siviglia*, and he'll take the stage again as the Nachtigall in *Die Meistersinger von Nürnberg*, the High Commissioner in *Madama Butterfly* (as well as understudying Sharpless), Baron Douphol in *La traviata*, covering Belcore in *L'elisir d'amore*, and he is cast as "singer" in Philip Glass' dance opera [*L'enfant terrible*](http://www.roh.org.uk/productions/les-enfants-terribles-by-javier-de-frutos), featuring the dancers of the Royal Ballet.

On top of his mainstage responsibilities, Nagy and his fellow Jette Parker Young Artists sing in their own production of Handel's [*Oreste*](http://www.roh.org.uk/productions/oreste-by-richard-gerard-jones). Nagy sings the role of Filotete, the captain of King Toante's guards, where he spends time "cleaning up things after human sacrifices."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478530382622/2016-11-07--Oreste-2.jpg.jpg)
<figcaption>Gyula Nagy (centre) in rehearsal for Handel's *Oreste* at Wilton's Music Hall. Photo by Roger Way Photography.</figcaption>
</figure>

"We all know each other, and it was really great [to be] together in a different venue," says Nagy of the prodution happening at Wilton's Music Hall. Away from the theatre in Covent Garden, Nagy finds the rehearsal process for *Oreste* "a bit freer, with all of us looking for colours, looking for intentions." The license for experimentation among colleagues at a similar stage in their careers is a breath of fresh air; yet Nagy has no qualms about the demanding schedule that comes from splitting his time between productions and venues.

He has a relaxed air about his place at the Royal Opera House, though the value of the experience - and the rarity of two years' worth of work - is not unnoticed. "You have a lot of help here," says Nagy of the ROH's fostering of their young artists. Young singers learn quickly that maintaining a career becomes about much more than the beauty of their instrument, and Nagy is grateful for the support, both creative and entrepreneurial.

He takes seriously the artistic work he does as a singer, yet the come-what-may attitude that Nagy has about his pursuit of singing is one of his biggest advantages. "If I hadn't gotten this [position at the ROH], then probably I would have gone on auditioning on my own," he says of the Jette Parker programme's influence on his career. "I would have managed somehow. It would have been really different, but there would have been another way."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478530394597/2016-11-07---Oreste-3.jpg.jpg)
<figcaption>Gyula Nagy (left) in rehearsal for Handel's *Oreste* at Wilton's Music Hall. Photo by Roger Way Photography.</figcaption>
</figure>

At Nagy's stage of his career, it's a relatively rare thing for a singer to reap the benefits of the extraordinary experience as a young artist at a major opera house, and have the confidence that their success and happiness do not hinge on landing that "one great gig." Nagy is one of the few singers we've interviewed who has no real "bucket list" of coveted roles, and his love of theatre and literature are still strong. 

"Of course, if you decide that, 'Ok, I'm just not up for it anymore, this constant auditioning [and being] on the road...nobody is putting a gun to your head." Nagy prefers to focus on the present, getting inspired by his colleagues, and singing well for the company that offers him invaluable opportunities.

"So far, what has come up for me are all pretty exciting things, and I think I can enjoy whatever comes."
