+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-04-27T10:39:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "The Canadian Opera Company's production of _Otello_ runs April 27 to May 21. For details and ticket information, [click here](https://www.coc.ca/productions/16510). "
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1556296879/media/2019/04/sqGeraldFinley-pc-SimCanettyClarke.jpg"
primary_image_credit = "Photo: Sim Canetty Clarke."
related_articles = []
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/gerald-finley.md"]
short_description = "Shady characters aren't new for the affable Finley; before adding Iago, Baron Scarpia (Tosca), and Duke Bluebeard (Bluebeard's Castle) to his repertoire, his career was famously rooted in two of Mozart's most prominent cads, Don Giovanni (Don Giovanni) and Count Almaviva (Le nozze di Figaro)."
slug = "talking-with-singers-gerald-finley"
title = "Talking with singers: Gerald Finley"
youtube_url = ""

+++
"Absolute stillness is the thing about villainous people," says Canadian bass-baritone [Gerald Finley](/scene/people/gerald-finley/), who has been busy studying malevolence in preparation for his Iago in David Alden's stark production of Verdi's [_Otello_](https://www.coc.ca/productions/16510) (running April 27 to May 21 at the Canadian Opera Company).

Shady characters aren't new for the affable Finley; before adding Iago, Baron Scarpia (_Tosca_), and Duke Bluebeard (_Bluebeard's Castle_) to his repertoire, his career was famously rooted in two of Mozart's most prominent cads, Don Giovanni (_Don Giovanni_) and Count Almaviva (_Le nozze di Figaro_).

>"It's the ultimate involvement of what one can do."

Yet in Otello’s nemesis, Finley finds "the perfect villain." An expert at false charm, constantly adapting himself to earn trust from others, Finley uses physical stillness to portray Iago’s unnatural, unpredictable nature. The bass-baritone has done his homework on psychopathic behaviour, drawing on literature like Robert D. Hare's comprehensive - and slightly controversial - “Psychopathy Checklist”. Out of the list's twenty attributes to suggest psychopathic behaviour, "Iago checks all the boxes."

"I think there's always this idea that a villain is at once attractive and dangerous," he says. "That's what I love about playing a part like that, because he's always adjusting his demeanour, depending on who he's with." Only when Iago is alone, delivering his famous "Credo" in Act II, does he present his true self to the audience, and reveal what Finley calls, "the snake, the worminess."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556297196/media/2019/04/COCOtello-pc-MichaelCooper.jpg){{% /md %}}

<figcaption>(l-r) Andrew Haji as Cassio, Gerald Finley as Iago, and Russell Thomas as Otello (background) in the Canadian Opera Company's production of Otello, 2019. Photo: Michael Cooper.</figcaption>

</figure>

Iago, with his intelligent and remorseless malice, and the thrilling music Verdi writes for him, is a role that sits confidently at the top of most baritone wish-lists. Finley is no exception, yet he had to prove his fitness for it. Perhaps it comes as a surprise for his fans that Finley - a Grammy Award-winning artist, Officer of the Order of Canada, Commander of the Order of the British Empire, and general superstar in his discipline - would not have a standing invitation into the world of Italian lyric baritone repertoire.

"I've had to get into what I call the 'villainous repertoire' a little bit by insistence," says Finley of his work in roles like Iago and Scarpia. "My career is incredibly varied, and you wouldn't necessarily say an Italian lyric baritone would be singing Schubert songs."

>"That's the sound that fills opera houses, that's the sound that gets over an orchestra: the incessant reverberation of the voice."

Perhaps not - but it's easy to argue that they should. Until recently, Finley's career has been arguably light on Verdi; indeed, it seems as though he's been everywhere but. His is the voice that lends us definitive performances of Mozartean hits, of contemporary works like John Adams' _Doctor Atomic_ and Jaufré Rudel in Kaaija Saariaho's _L'amour de loin_. His are exemplary recordings of _Dichterliebe_ and _Winterreise_.

It's not how we imagine the lead-up to a baritone's arrival at Iago, or comparable Verdi roles like Conte di Luna in _Il trovatore_ or Rodrigo in _Don Carlo_. Yet who better but someone like Finley - trained in the detail work of German Lied, the subtle control of Mozart, and the unique challenges of new opera - to take on lyric baritone repertoire? To take on a Shakespearean villain?

It seems even Finley is not immune to opera's knee-jerk tendency to categorize voices; they're not only identified by what they can do, but corollary assumptions are then made about what they cannot. It seems a nonsensical conclusion to draw, but perhaps Finley's historical focus on text delivery and detail work makes him a harder sell for the broad legato of so-called "Verdi baritone" repertoire.

Or perhaps the pigeon-holing isn't entirely unfounded. Finley muses that he is "trying to haul myself from a tradition" where singers prioritized clear and crisp text, almost as a replacement for the sound of the voice. "I was taught not on legato," he says. "I really tried in the last ten years to understand. I worked really hard to get into the idea that my voice can ride this constant wave."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1556297170/media/2019/04/GeraldFinley-pc-SimCanettyClarke.jpg){{% /md %}}

<figcaption>Bass-baritone Gerald Finley. Photo: Sim Canetty Clarke.</figcaption>

</figure>

Particularly in the recording studio, which has grown unfavourable to an expansive, hall-filling sound, "The modern taste is for the intimate and the subtle." Essentially, it's for consonants over vowels.

"It's a train," Finley says of the sustained voice. "It has cars attached, and the flow of sound is going along." Anything that stops the flow - belaboured consonants, mostly - is a precarious gap between the train cars. "It upsets literally the track."

>"Guys, let's get the voice sorted out."

Finley points to the likes of Tom Krause, Barry McDaniel, and George London as examples of telling stories with vowels. "If you go and listen to Fischer-Dieskau, he is a classic bel canto singer," he argues, invoking the man whose name is synonymous with German Lied. "We still don't realize that singing is this amazingly subtle art, and it's always based on this constant flow of sound."

"That's the sound that fills opera houses, that's the sound that gets over an orchestra: the incessant reverberation of the voice."

All this is to say that singers are more versatile than we may suspect. Singers with a flair for finely drawn lines may be the same as those who have a natural bent toward a sound that reaches the back row without breaking a sweat.

It's something that can be unearthed with a simple return to voice-first training. Finley yearns for a more singular focus among the now-ubiquitous young artist programmes: "Guys, let's get the voice sorted out." If for any reason, to be free to reap the largest rewards from a career as an opera singer.

"It's the ultimate involvement of what one can do," Finley says of his vocation, which calls upon his body, mind, and emotions in order to become a "speaker of society's ills and joys."

"I hope that whenever I encounter any singer beginning out, that they understand that that's what they can be a part of."
