+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = "2018-10-16T20:22:00-04:00"
lastmod = "2018-10-17T09:55:00-04:00"
preamble = "American bass-baritone Evan Hughes is making his company debut as Figaro at the San Diego Opera in Mozart's *The Marriage of Figaro*, October 20 to October 28, 2018."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539736401270/sqhughes-headshot-icon.jpg.jpg"
primary_image_credit = "Photo: Matthu Placek."
publishDate = "2018-10-17T09:55:00-04:00"
related_companies = ["scene/companies/san-diego-opera.md"]
related_people = ["scene/people/evan-hughes.md"]
short_description = "&quot;Opera is so difficult to get right. There are a lot of valiant efforts but even in the master works of previous centuries, so many things have to come together for an opera to actually work for the audience. The story telling has to be clear, all the actors have to be on the same page, and the chorus has to be invested.&quot;"
slug = "talking-with-singers-evan-hughes"
title = "Talking with singers: Evan Hughes"
+++

### How is this production of *Figaro* in San Diego comparing to some of the others you've done?

This production is under the intellectual guidance of director Stephen Lawless and he's very brilliant about bringing out the naturalism of the characters and finding the way the characters really talk to each other. At the beginning of the opera, when it's Susanna's and Figaro's wedding day and he is measuring the room, they speak to each other confrontationally, the way that a couple who loves each other would fight. They are fighting, but lovingly. Stephen has figured out a way to find that balance, not making it too storybook sweet. He brings that subtext to the whole opera. It always feels natural, the way I would say something. However, that is also already in the libretto. Lorenzo DaPonte and Mozart have an incredible natural and human approach. The characters are not gods or mythological. They are normal people fighting for rational and normal things. Stephen complements the libretto really well.

### Do any of the productions you've done stand out for being wildly different?

I've been doing performances for the Figaro production of the Semperoper in Dresden. The production is by Johannes Erath. Each act takes place in a different time period. It starts in a *commedia dell'arte* period in the first act, then progresses in the second and third act into an 18th-century interpretation. As the drama in the production goes forward and the circumstances for the characters get more intense and the stakes get higher, the production goes forward in time. By the time we reach the fourth act, we've taken off our wigs and we're in modern dress and we're speaking. It becomes a hyper realist modern dramatic realism of spoken word. That is the wildest approach I've seen to *Figaro*.

#### How does the interpretation of the role of Figaro differ in the various productions? Is it ever a challenge to adapt to the different interpretations?

I'm the kind of singer who approaches each project as an actor, rather than as a singer. I end up getting the singing together by the time we open but the thing I really look for is feeling this human being, understanding the circumstances of this human being, and figuring out what this person is fighting for. The only reason it would be a challenge is if I don't agree with the approach of the director to the character, but that doesn't happen most of the time. The director has a clear idea of who the character is and what he's fighting for. 

#### You're a champion of contemporary music and you favor interpreting new compositions. What are the opportunities in contemporary music and new compositions? 

I've always been, in every part of my life, not just as an artist but an adventurous person. Taking on modern music and modern opera and chamber music is as adventurous as I can be. It makes me think outside of the box. It's as adventurous as you can be because it's a new piece and it's often something that's quite abstract. You have a piece of poetry, or a text which can be very dense, and you have a musical interpretation of that text. Especially with modernist compositions, you are dealing with very difficult rhythmic structure, with atonality, and it challenges you as a musician to the greatest degree. All these things push the boundaries of one's limits. 

As soon as I started doing contemporary music, I stopped thinking that there was anything that was too difficult. I no longer saw boundaries. The only thing I will say no to now is something that I know will harm my voice or that I know is the wrong fit for me in terms of temperament and character. It's a positive challenge but it's not without stress. I always seem to make things difficult for myself but I always grow if I do. For example, whenever I program a recital, I never just do an easy song recital. I always end up taking on something that is both vocally really challenging and also interpretively very challenging or dramatic. I always try to tell a story that brings me to a catharsis and also brings the audience to a catharsis.

### Is it ever frustrating that there is so little new opera that becomes popular?

Opera is so difficult to get right. There are a lot of valiant efforts but even in the master works of previous centuries, so many things have to come together for an opera to actually work for the audience. The story telling has to be clear, all the actors have to be on the same page, and the chorus has to be invested. If you're sitting in the audience and there a couple of people in the chorus who seem not to realize where they are, it takes you out of the drama. So many things have to be firing full cylinder to make opera work. You have got to have musical, dramatic, and technical components all happening at the same time. 

It's not surprising that there aren't very many great masterpieces of the 21st-century. There are a few, of course, and one of these is my next project. I'm going to sing George Benjamin's opera [*Written on Skin*](https://mahlerchamber.com/concerts/234). This is a piece that works in every area. It gets it all right. The text is profound, challenging and stunning. The dramatic challenge is wonderful, and the music is so very strong. It's going to be a wonderful opportunity. I'm singing it with the Mahler Chamber Orchestra in a small tour of a semi-staged production with an amazing cast. Having this very stripped down but staged version will be exposing and illuminating the piece.  I'm really looking forward to that.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539736468498/hughes-headshot-black-and-white.jpg.jpg)
<figcaption>Photo: Matthu Placek.</figcaption>
</figure>

### Why do you sing?

Singing is a place within myself. When I'm doing it, I both don't recognize myself and I feel the most myself. What I'm able to access is what I feel to be the best I am. It's also so expressive. It's a place where I can dig into myself emotionally. I can open up my whole self, my whole psyche, to let something flow through me. I can't help but get a little spiritual thinking about why I sing. It is who I am, and it is also not. It's ephemeral.

Speaking circumstantially, singing is something I was born into. I was raised by an opera singer and voice teacher. I grew up at the Music Academy of the West in Santa Barbara, the place where there is a world-renowned music festival. My father worked there for 37 years as the Buildings and Grounds manager, and when my mom was a student there in the early 1980s, she fell in love with this cute Welsh guy who was the Buildings and Grounds manager. It's all rather romantic and I ended up growing up on the campus. For my entire life, I heard opera at the highest level, people like Marilyn Horne and Warren Jones, giving master classes about art songs. There was never a time when I was not thinking of myself as a singer and I was not expressing myself through song. 

### I'd like to come back to something you said earlier, that acting comes first.

That can be a controversial thing to say as a singer. It doesn't mean that I don't deeply care about singing well and my technique. It's just that technique and singing is something that has always come naturally to me. It has not been the thing that I nerd out about. It is something that I've had to work really hard for, but it's never been as interesting to me as the music or as the drama. Music and drama are the place where I can let that make the best of me and hopefully, with the help of all the great teachers I've had, bring a technique into the picture. Story-telling, acting, interpretation through the music, and the drama are the things that turn me on, more than the sound of my own voice or the perfection of it.

#### You have a very well-filled European career. How did you get to Europe after starting in the U.S. as a Lindemann young artist at the Metropolitan Opera? 

There's a conventional wisdom in the opera world that you have two choices. You can try to make it in America if you're really lucky, immediately singing with A houses right after you're a young artist. As a young bass-baritone, I needed more time to cook. People always talk about more opportunity and work in Europe. I have found this to be the case, that there is very diverse work in Europe, and especially in Germany. Through all the opportunities that the Lindemann Program gave me at the Met, and I was also very lucky to be managed at a young age, I had many auditions for European companies and I ended up getting an offer to join the ensemble in Dresden in the Semperoper. 

I was terrified to move to a small German city but I knew the incredible musical tradition of the Semperoper and I couldn't say no. It ended up being a real musical home for me. I was there for five seasons, in the Fest. They believed in me and very quickly I had that wonderful experience of doing good work that was recognized and rewarded. It was empowering because I was able to constantly grow. They kept giving me bigger challenges each season. As soon as I got there, I started singing principal roles. I was able to build my repertoire, especially in Mozart and Handel, which I believe are the two composers with whom I have the most to say and where I'm the best at this particular point in my singing life. Then I had also a home base in Europe, people started hearing me, and I started singing for various companies. My European career started to blossom. I'm excited to have most of my work there now in various houses.

### How is opera different in Europe than in the U.S.? 

It comes down to the difference in culture and the relationship to classical culture in Europe. It's still taught in schools and very much part of the vernacular. You talk to a person at a dinner party and say you're an opera singer and they say they were at the opera the other day and maybe, they hated the costume design. People from every walk of life in Europe have an opinion about opera. It's a European tradition. It feels more every day and a part of normal cultural life in Europe than in America. It's much more difficult to connect to new audiences in America. While there are amazing things happening in opera in America, the younger generations unfortunately don't have as much access because it is not supported by our government.

#### Is there a moment in your career that you can look back on, whether it's on stage or as a member of the audience, that elicited a strong emotional response from you? 

It's a very young memory for me. It's the sound of my own mother's voice. She is an extraordinary singer, and when I was a little kid, she was making ends meet by teaching, auditioning and doing a lot of recitals. I never went through a period where I was uncomfortable with my mom singing. I always was her fan. She was a singer who brought her entire being to everything that came out of her. It was very self-expressive and cathartic. I immediately identified with the possibilities of the expression of singing. I would sit under the piano on a sheepskin while she taught lessons. I would go to her coachings with her. I remember listening to her sing and learn *Butterfly* when I was a little boy and being riveted. I was emotional even as a five-year old. That was my first memory of being moved by singing. It also happens to me very often as an audience member that I'm moved by the human voice as an instrument, the kind of color and emotion that can come through the climax of vocal expression.

### Who are your operatic heroes that you listen to and that you watch for inspiration and for learning?

Maria Callas is always my number one. My mother listened to her. You can hear in the sound of her voice that full cathartic emotional human experience. That attracted me. There's something so virtuosic but also so natural and human in her sound, so imperfect. Whenever people say Callas was an amazing artist but her voice was ugly, I find that to be offensive. What does that mean esthetically? Don't you want a voice to own things other than beauty? Callas has always been my number one. I wish I could say that it was some bass-baritone. People say you have to listen to your own voice type and I've made myself do that as a good student, but I've always been into sopranos [laughs]. I can't get over the sound of a B-flat coming out of Renée Fleming's throat. I love the bass-baritone voice too but it's for the repertoire. If I'm listening to opera, for sheer pleasure, I would go to the soprano.

### Are there any singers that you wish you could have performed with, or are looking forward to performing with?

I'm going to talk about sopranos again. One of them is Renée Fleming. In my coming of age, she was the height of the possibility of singing. She was also a really down to earth and beautiful artist who I was always inspired by. In terms of people in my own generation, I've already had the opportunity of working with Julia Bullock, and I would love to continue singing with her throughout my career, whenever possible. She's somebody, as a friend and as a singer, who inspires me to dig deep.

### What are some of your upcoming projects? 

I'm going to be singing my first Papageno, which excites me very much. I'm going to be singing it on tour with the Komische Oper Berlin and the Lincoln Center Festival. *Written on Skin*, which I mentioned earlier, is an opportunity of a lifetime. Next year, I'm singing the role of Astolfo in Vivaldi's *Orlando Furioso*, in Moscow. I'm really excited about the fact that it's in Russia. It is very intriguing to me to check out that artistic tradition and also to sing a Vivaldi work there. I'm doing Cithéron in Rameau's *Platée*. I've never sung French Baroque so I'm excited for that. I will be doing it at the Semperoper in a new production directed by Rolando Villazón. There are also a couple of things that haven't been announced yet that I wish I could talk about.

### Anything you would especially like to sing in the future?

I'm not very goal oriented. I feel that whatever is meant to be will come to me but there are some things that really turn me on, like Iago, Scarpia - some of the big bass-baritone milestone roles that I hope I'll get to sing later in my career.

>San Diego Opera's production of *The Marriage of Figaro* runs October 20-28. For details and tickets, [click here.](https://www.sdopera.org/season/2018-2019-season/figaro) For more with Evan Hughes, follow him on [Instagram](https://www.instagram.com/evanbenhughes/) and [Facebook](https://www.facebook.com/evanhughesbassbaritone).
