+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2022-04-08T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1649352664/media/2022/04/sqETIENNE_DUPUIS_DarioAcosta_itpnyr.jpg"
primary_image_credit = "Photo by Dario Acosta."
related_articles = ["articles/anna-1.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/nicole-car.md", "scene/people/etienne-dupuis.md"]
short_description = "“My answer was always the same, and I think confinement has just strengthened it,” Dupuis says. “It's because, emotionally, we need to share something communally.” "
slug = "talking-with-singers-etienne-dupuis"
title = "Talking with singers: Étienne Dupuis"
youtube_url = ""

+++
When I asked him about his memories of the start of the pandemic, [Étienne Dupuis](/scene/people/etienne-dupuis/) laughed at the thought of what he knows is a strange flex:

“I brag about how Nicole and I knew how long it was going to be from the beginning,” says the Canadian baritone, referring to his wife, Australian soprano [Nicole Car](/scene/people/nicole-car/). Both singers were working at The Metropolitan Opera during that fateful March in 2020; Car's final performance of _Così fan tutte_ had been cancelled, and Dupuis was on the eve of his final dress rehearsal for _Werther_ (also cancelled).

The news they got back then was what we all got, which was that we should all stay home and life would resume in two weeks' time. "I turned to Nicole," Dupuis recalls, "and I said, 'We're not opening again until they find a vaccine or they find a treatment that works.'"

He doesn't consider his pandemic foresight a win, exactly, but the early dose of reality may have helped Dupuis and his family stay grounded for the last two years. His was among the singing careers that was going at full tilt when everything screeched to a halt, and he has empathy for his fellow singers who felt the loss not just of income, but of identity and emotional health. "They didn't have their outlet anymore," he says.

It's not just about opera singers missing their usual fixes of spotlight and applause; that "outlet" is about staying sharp in their bodies and minds. Memorizing music, traveling the world and working multilingually, the physical demands of singing well and with stamina - for a working singer, maintaining these skills can be synonymous with maintaining their well-being.

"These muscles, used on a daily basis are very efficient," Dupuis says, before trailing off, "but if they haven't worked for a while…"

I've thought a lot about the singers and other performing artists, and the really kind of specific loss they've suffered in the last two years. It's not the same kind of tragedy as the pandemic's death toll or the daily chaos that healthcare workers face. Still, it's significant deprivation for these artists, who live in a world where one's work is the same as one's community and sense of purpose; and even as things open back up, the effects will last.

"I think for years now," Dupuis predicts, "we're going to be saying to each other, 'Hey, how was your pandemic? Where were you when the pandemic happened? How did you cope?'"

> "There’s something that happens when you put a bunch of people on stage, before the people in the audience, and we share this moment in time of beauty."

I spoke by phone with Dupuis last month, while he was happily back at the Met, singing in David McVicar’s looming, star-studded [new production of _Don Carlos_](https://www.metopera.org/season/2021-22-season/don-carlos/) alongside [Jamie Barton](/talking-with-singers-jamie-barton/), [Matthew Polenzani](/talking-with-singers-matthew-polenzani/), and [Sonya Yoncheva](/scene/people/sonya-yoncheva/). We talked about the complicated history of Verdi's 1867 opera, which has dual identities as a four-act Italian masterpiece and a five-act work of French grand opera.

Upon request, Dupuis gave me a glimpse of the opera's history: its life in French (ballet included, _bien sûr_) and the ways one could argue that Verdi's writing for the Italian version is better.

But I was more interested in how loudly this production of _Don Carlos_ spoke about the world's current events. Dupuis felt it, too, in his opening scene as Rodrigue. His first lines are to Carlos, telling him about the war and blood he's seen in Flanders, and wonders if the fighting is truly achieving peace. "And as I say that the orchestra has this ginormous chord - this noise, really, of the trombones blasting," says Dupuis. "It's like Verdi's commentary, saying 'that's what I think about that kind of war.'"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1649353236/media/2022/04/MetOpera_DonCarlos_Dupuis_Polenzani_cvacq8.jpg){{% /md %}}

<figcaption>Matthew Polenzani as Don Carlos and Etienne Dupuis as Rodrigue in Verdi's “Don Carlos.” Photo: Ken Howard / Met Opera.</figcaption>

</figure>

Even more pointed than Verdi's commentary is the connection to war today. "Immediately, if I was in the audience, I'd be like, 'I'm thinking of Ukraine right now.'"

Since he was right in the middle of it all when we spoke, I asked Dupuis about the [Met's response to Anna Netrebko](/opera-politics-blurry-lines-being-kind/), the Russian star soprano who was dropped by the company - and others, including her management - after she took decidedly too long to denounce the war in Ukraine.

"Political opinion is the same as a human opinion," Dupuis says. He's sympathetic to how artists are like everyone else, with varying political leanings; still, the Netrebko case seems more acute. "It's hard to justify saying, 'No, it's cool that a country should invade its neighboring country.'"

(It should be noted that after my conversation with Dupuis, [Netrebko did offer a condemnation](https://www.theguardian.com/music/2022/mar/30/russian-soprano-anna-netrebko-putin-ukraine-war-met-opera) of the war in Ukraine. It didn't get her back onstage at the Met, but it reportedly cost her a gig at the State Opera and Ballet Theatre in Siberia.)

Dupuis and I agreed that neither of us envy Met General Director Peter Gelb, who has effectively ousted one of his friends with his decision to keep Netrebko off the mainstage. And we mused on the idea that it might not have been safe for Netrebko to explicitly condemn the actions of Putin, with whom she has appeared allied in previous years. "  
Maybe we're asking too much of a single person," Dupuis offers.

And it may be that, in general, we ask too much of artists and their political views. I think Gelb made the right call regarding Netrebko - but as a general rule, do we really want to threaten a singer’s career because of their ideologies? Are we ready for the slippery slope? How easy is it to argue that being on one side of an issue is objectively "worse" or "better" than the other? Can we trust ourselves to approach the issue with a case-by-case-basis type of maturity?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1649352761/media/2022/04/ETIENNE_DUPUIS_DarioAcosta_o6qf3k.jpg){{% /md %}}

<figcaption>Canadian baritone Étienne Dupuis. Photo by Dario Acosta.</figcaption>  
</figure>

Dupuis wrapped _Don Carlos_ last month, and now he's set to step into the title role of _Don Giovanni_, in a [new production for San Francisco Opera](https://www.sfopera.com/on-stage/don-giovanni) by fellow Canadian Michael Cavanagh. And for the good-natured baritone with no political controversy stealing his thunder, it's clearer than ever that his work is meaningful and important. 

I asked him whether the pandemic had changed anything for him, if it had affected how he sees the performing arts and why he sings for a living. The short answer? No.

"My answer was always the same, and I think confinement has just strengthened it," Dupuis says. "It's because, emotionally, we need to share something communally."

"There's something that happens when you put a bunch of people on stage, before the people in the audience, and we share this moment in time of beauty. It's slightly different for everybody but as a whole something happens that’s impossible to describe."

Yep. I'm excited for intangible wonder, again, too.