+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2019-11-07T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Erin Wall stars in the Toronto Symphony Orchestra's in-concert presentation of [_Thaïs_](https://www.tso.ca/concert/thais-grand-opera-concert), conducted by Sir Andrew Davis, November 7 and 9."
preamble = "On November 7 and 9 with the Toronto Symphony Orchestra, Canadian soprano [Erin Wall](/scene/people/erin-wall/) brings one of her signature roles - [Massenet's Thaïs](https://www.tso.ca/concert/thais-grand-opera-concert) - to the stage of Roy Thomson Hall. _Thaïs_, the 1893 opera about a courtesan's pursuit of love in all its forms, places high demands on any soprano who takes on its title role. It's a rare thing to hear on the opera stage, and rarer still in Canada.\n\nWe spoke with Wall about Thaïs, the woman and the challenging operatic role:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1573073482/media/2019/11/sqErinWall-KristinHoebermann_jliiu0.jpg"
primary_image_credit = "Photo: Kristin Hoebermann."
related_articles = ["articles/talking-with-singers-sondra-radvanovsky.md", "articles/talking-with-singers-othalie-graham.md", "articles/talking-with-singers-corinne-winters.md"]
related_companies = ["scene/companies/toronto-symphony-orchestra.md"]
related_people = ["scene/people/erin-wall.md"]
short_description = "\"It's fairly extreme in its demands, and Massenet saved some of the hardest writing for the very end - the duet which closes the opera builds to two high Ds! It requires the singer to finesse a pianissimo one minute, and then have a huge fortissimo outburst over full orchestra the next!\""
slug = "talking-with-singers-erin-wall"
title = "Talking with singers: Erin Wall"
youtube_url = ""

+++
## What kind of woman is Thaïs? What are some common misconceptions about her character?

She's a courtesan and a performer - Massenet lists her as a comedienne. On a deeper level, when we meet her in the opera, she's exercising her power and her charm over the men in the cast, but underneath her shiny exterior, she's very unhappy - she's bored with her existence and knows that as she ages, her beauty will fade and she won't be able to carry on as she has been. She's feeling the passage of time and her own mortality, something I think we can all identify with as we age.

> Basically, it just requires a lot of range, and several secure Cs and Ds.

As far as misconceptions go, I don't think that many people are familiar enough with this opera to have them, as it is so rarely performed. I have heard that people find her "instant" conversion to Christianity a little hard to swallow - for me, reading the source material (Anatole France's novel) cleared this up. In the novel, you learn that Thaïs grew up unloved and abused, and was actually baptised a Christian after learning about the faith from a slave who worked for her family. It's something that's been in the back of her mind, and Athanael comes to convert her at a time when she's really unhappy and longing for change.

## What do you think makes the role of Thaïs notoriously difficult?

It's fairly extreme in its demands, and Massenet saved some of the hardest writing for the very end - the duet which closes the opera builds to two high Ds! It requires the singer to finesse a pianissimo one minute, and then have a huge fortissimo outburst over full orchestra the next! Basically, it just requires a lot of range, and several secure Cs and Ds.

There's also very little time offstage once the role begins - although she doesn't appear until halfway through the second scene of the opera, once she's onstage, she's there almost constantly for the rest of the opera.

## As a singer and storyteller, how does your job change with an in-concert production?

It really depends on how much staging is possible. Since we're recording these performances in Toronto for a CD release, we are limited in the amount of staging and interacting we can do in the concerts - too much movement means that we won't capture the best sound. If we turn our heads to sing to each other, the microphones will lose the full sound of our voices. In contrast, in two weeks I'm doing concerts of _Peter Grimes_ where we are almost fully staged in the small amount of space we have.

> Maybe the point is that neither idea of love is enough on its own.

Ultimately, what it means for _Thaïs_ in Toronto is that all the acting and expression will be done with my face and hands, and most importantly, with my voice - although that shouldn't change too much from opera house to concert stage anyway! We have to have confidence that the music will tell the story well!

## What does this opera have to say about big topics like faith, love, and lust?

It's interesting - Thaïs tells Athanaël from the start that denying his lust is impossible, and as it turns out, she ends up being right. That said, this opera also points out that for Thaïs, the pleasures of the flesh ultimately aren't enough, and she is drawn inexorably towards the promises of the Christian faith - eternal life and the all-powerful love of God.

Athanaël, the ultimate religious fanatic, does exactly what he sets out to do - convert a sinful woman to Christianity - but this very act is his undoing, and he ultimately succumbs to human love. So ultimately, maybe the point is that neither idea of love is enough on its own, and humans will long for a connection with the divine, but also for connection with each other.