+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-10-25T17:30:00-06:00"
lastmod = "2016-06-19T19:33:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445899946209/Caballero.E.Headshot.jpg.jpg"
publishDate = "2015-10-28T09:00:00-06:00"
related_articles = ["articles/talking-with-singers-othalie-graham.md","articles/talking-with-singers-nicole-cabell.md","articles/paul-appleby-telling-stories-at-wigmore-hall.md","articles/a-butterfly-but-not-from-puccini.md"]
related_companies = ["scene/companies/opera-grand-rapids.md","scene/companies/the-metropolitan-opera.md","scene/companies/florida-grand-opera.md","scene/companies/lyric-opera-of-kansas-city.md","scene/companies/central-city-opera.md","scene/companies/opera-coeur-dalene.md"]
related_people = ["scene/people/elizabeth-caballero.md"]
short_description = "Cuban-American soprano Elizabeth Cabellero has built herself a busy life on the road, singing some of opera&#039;s most coveted roles in houses across the United States. She just finished singing Donna Elvira in Lyric Opera of Kansas City&#039;s Don Giovanni, and when we spoke over Skype, she was in Miami, FL, preparing for a recital in honour of legendary Romanian soprano, Virginia Zeani. "
slug = "talking-with-singers-elizabeth-caballero"
title = "Talking with singers: Elizabeth Caballero"
+++

Cuban-American soprano [Elizabeth Cabellero](/scene/people/elizabeth-caballero/) has built herself a busy life on the road, singing some of opera's most coveted roles in houses across the United States. She just finished singing Donna Elvira in [Lyric Opera of Kansas City](/scene/companies/lyric-opera-of-kansas-city/)'s *Don Giovanni*, and when we spoke over Skype, she was in Miami, FL, preparing for a recital in honour of legendary Romanian soprano, [Virginia Zeani](/interviewing-the-greats-virginia-zeani/). "Her 90th birthday was yesterday," says Caballero. "They're celebrating her." (For more on Zeani, check out Olivier Bergeron's fantastic interview with her [right here]((/interviewing-the-greats-virginia-zeani/).)

Caballero heads next to Michigan to sing her first [Verdi *Requiem*](http://www.operagr.org/tickets/requiem/) with [Opera Grand Rapids](/scene/companies/opera-grand-rapids/) on October 30th. The *Requiem* is often passionately nicknamed "Verdi's greatest opera," and Caballero assures me that it's easy to move from Violetta and Alice Ford to singing Verdi oratorio. "With Verdi it's very easy, because it is like singing an opera." To her, that means being true to her own voice at its most healthy and its most natural. 

"I'm always going to sing with my voice, the only thing that will change is the style," she explains. "I'm going to sing Mozart the same way that I'm going to sing Puccini, just the style will be different. I'll sing Puccini the same way that I'll sing Verdi, or Monteverdi. I'm still using the same voice. There's no 'Mozart voice,' there's no 'Verdi voice.'"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445898347022/unnamed-1-706x1030.jpg.jpg)
<figcaption>Elizabeth Caballero as Donna Elvira in *Don Giovanni* at Lyric Opera of Kansas City, 2015.</figcaption>
</figure>

So how does an opera singer connect with the "libretto" of oratorio? Caballero approaches the role of "soprano soloist" in the *Requiem* no differently than she approaches Elvira or Susanna. "I always try and put a little bit of myself in these characters, whether I've had a connection with them or not." 

Like all good acting singers, Caballero finds a kernel of truth each character she plays. "For example, like Violetta, we've all been in a situation where, maybe you've fallen in love, but it wasn't the right time, something like that." She notes that a true personal connection to just one aspect of a role can allow the rest of the character to come to life in an organic way. "Elvira is one that I think a lot of girls know what it feels like, because we've all been bitten by some guy one time or another. Whether you went a little stalkery or not is up to your personal taste, but we can sympathize with a woman like that."

Next month Caballero will revisit a favourite role in Opera Coeur d'Alene's production of *La bohème*. "I'm singing Musetta for the very first time in, gosh, in years, I don't remember how long. So this will be fun!" She first impressed with her Musetta at New York City Opera in 2007. I asked her about what it takes to pivot from style to style, to go from the concert stage to the opera stage. She told me it's not a new challenge for opera singers.

"All these singers, that we all study nowadays, they would sing everything, whether it was right for them or not. They would sing Wagner one night, and then sing Mozart the next, or Bellini the next. Maria Callas is known for doing that. Whether it's right to do or not, I don't think it's right for us to judge. I think it's up to the singer to make that decision." Caballero maintains that great singers "should be able to sing anything, just sing it with your instrument." 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445898504658/011-1030x832.jpg.jpg)
<figcaption>As Cio-Cio San in *Madama Butterfly* at Lyric Opera of Kansas City, 2012. Photo by Cory Weaver.</figcaption>
</figure>

The idea of singing with one's own instrument can take a long time for a singer to learn, and I think it's a significant mirror to our everyday lives. "It was something that I'd say *Madama Butterfly* taught me," says Caballero. "She's got such a stigma on her for being this powerhouse soprano role, and it is very taxing - the Puccini orchestra, and you're on stage the entire time. We get into the habit of imitating this singer or that singer, because we admire them so much and we want to be like them." 

It's true that she gets some fantastic characters to play, but these same roles come with history, and what some would claim is artistic responsibility. For Caballero, that balance is part of learning her craft. "Butterfly really taught me how to do that, how to still sing her healthy, and do it right, and feel that I was being honest with myself, and do it with my instrument. I learned a lot from singing that role."

She works regularly across the United States, in regional opera houses like Opera Grand Rapids, and at the big "work horse" companies like [The Metropolitan Opera](/scene/companies/the-metropolitan-opera/). I was curious about the difference in process and experience for working singers, and Caballero admits to enjoying the intimacy of smaller houses. "You have donors that really participate with you, and they pick you up at the airport, and you go to these parties and you meet them, and this and that." She gets that houses like the Met produce high quantity as well as quality. "There's a bit of a more warm and fuzzy feeling when you do go to these regional houses, as opposed to these bigger places that are there to just get operas together and get it going."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445898557453/042-685x1030.jpg.jpg)
<figcaption>As Micaëla in *Carmen* at Central City Opera, 2011. Photo by Kira Horvath.</figcaption>
</figure>

That real connection with the people around her matters a lot to Caballero and her work. She takes frequently to social media to connect with colleagues, and, more importantly, her fans. "That's what's nice about social media, that you can connect with all these wonderful people. And they'll ask if they can see you backstage, and you'll be like, 'Yeah sure, come see me!' You get to meet new people, and they're such supporters. It's just a nice way of connecting with everyone on a more personal level."

Caballero is in that sweet spot of her career, where her professional schedule is busy, but she's not so far removed from her years in training. When she was singing Donna Elvira in Kansas City, she spoke with a group of students about her work, and what she wished she'd known sooner. "I wish I had taken a couple courses in business, and business management and administration, so that I would know how to manage myself as my own personal business as a singer." 

She stresses that learning about taxes, about how to deal with student loans ("Especially us kids in the United States!"), and the basics of self-promotion are vital to the daily life of a working singer. "You don't think about it when you're in school. All you're thinking about is your singing, and getting your roles in, and your repertoire in...so you're not thinking about all the other stuff that's very important, almost more important when you're out there as a performing singer."

I found Caballero to be totally refreshing to talk to, and candid about the realities of this career. Her love for the art is strong, and it keeps the hard stuff in perspective. "It's not easy. It's a very, very tough career. It's very lonely, you're travelling a lot. There's a lot of competition, a lot of nastiness, a lot of rejection. So, you have to be very, very tough." 
