+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-10-29T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Opera Atelier's production of [_Don Giovanni_](https://www.operaatelier.com/season-and-tickets/2019-2020/mozart-don-giovanni), starring [Douglas Williams](/scene/people/douglas-williams/) in the title role, is onstage at the the Ed Mirvish Theatre Oct. 31-Nov. 9."
preamble = "Opera Atelier is set to revive its 2011 production of _Don Giovanni_, this time starring bass-baritone [Douglas Williams](/scene/people/douglas-williams/) in the title role. \n\nMozart's Giovanni is a role that continues offers new layers, new angles from which to observe the famed womanizer, and Williams' perspective is some of the most compelling deconstruction of the Don we've heard yet."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1572373169/media/2019/10/DouglasWilliams_dr1mrf.jpg"
primary_image_credit = ""
related_articles = ["articles/talking-with-singers-luca-pisaroni.md", "articles/talking-with-singers-christopher-purves.md"]
related_companies = ["scene/companies/opera-atelier.md"]
related_people = ["scene/people/douglas-williams.md"]
short_description = "\"At the moment I'm thinking of a project where I can bring singing and nature together. Probably a video. Probably somewhere in Nevada. Maybe text by Robinson Jeffers. Maybe music by me.\""
slug = "talking-with-singers-douglas-williams"
title = "Talking with singers: Douglas Williams"
youtube_url = ""

+++
## Why do you sing professionally?

Since I was a child I wanted to work in a theater. I also loved music and took it seriously, and I was attracted to musical challenges. When I really feel like I am at my best usually it's because both these early urges are being satisfied equally: the creative side of inventing and exploring a character, and the cerebral side of discipline, language, and making music with many people at the same time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572463278/media/2019/10/OperaAtelier-DonGiovanni_w0bim8.jpg){{% /md %}}

<figcaption>Douglas Williams in the title role of Opera Atelier's production of Don Giovanni, 2019. Photo: Bruce Zinger.</figcaption>

</figure>

Over the years the pursuit of becoming a better singer has accumulated more and more meaning to me. Singing is a reflection of what is going on inside your body and soul, and every day starts with a look inward. I've learned a lot about myself from singing, and let go of a lot of old pain or protective masks that I've worn in the process of learning how to sing. It's something I never expected as a young man and I'm grateful to singing for teaching me in this way.

## What kind of man is Mozart's Don Giovanni? What do you think are some common misconceptions about his character?

I think that Don Giovanni is very often played today as a monster. In this production with Opera Atelier, and my representation of the Don, I am trying focus on him as a sensual lover, someone who loves to be truly in love with every new woman he meets.

He lives for romance, not for hurting people, and at times he is actually totally open and honest about the way he lives. Unfortunately no one wants to be loved and quickly forgotten and so the world around him cannot deal with such a libertine.

> That's the power of the anti-hero. To be enthralled and conflicted by someone who is so sexy and so corrupt.

It's not that I would defend all of his actions if Don Giovanni were a real person. But in this opera the audience can't be repulsed by him from the onset, otherwise why follow him around for an evening? They have to want to join him in his freedom, his party, his ecstasy, his lack of shame, even if at the same time we feel uneasy about it or even disgusted by him.

That's the power of the anti-hero. To be enthralled and conflicted by someone who is so sexy and so corrupt. It's easy to do a production of Don Giovanni the monster. It's harder but a more incisive portrayal, I think, to do Don Giovanni the rogue that we are desperate to be, or to be with, even if all along hoping to see punished.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572463266/media/2019/10/OperaAtelier-DonGiovanni-DouglasWilliams-BruceZinger_py3t1j.jpg){{% /md %}}

<figcaption>Douglas Williams in the title role of Opera Atelier's production of Don Giovanni, 2019. Photo: Bruce Zinger.</figcaption>

</figure>

## How do you balance a "dramma giocoso" about Don Juan, in post-#metoo 2019?

The #metoo movement is a sea-change in how we openly talk about power and sex in the career. It has certainly already brought about shocking changes in the opera world and caused opera companies and stage unions to urgently address the problem of sexual intimidation in the work place.

> The dramatic interest in this opera occurs in this tense grey zone of desire and repulsion.

In my own experience, besides being abhorrently uncomfortable, sexual pressure in the opera workplace is the killer of any desire to experiment or feel free to create. So it's not just a personal transgression, it is antithetical to a creative environment. I'm glad things are changing.

I don't know, however, if #metoo applies entirely to Don Giovanni as I have described him in my answer to the previous question. The women he encounters want to be with him on some level. Even Donna Anna throws herself into his arms at one point in our production.

Don Giovanni isn't leveraging career possibilities, undesired incentives, or even physical force to ensnare them. It's not so black-and-white. The dramatic interest in this opera occurs in this tense grey zone of desire and repulsion. That story, while not as topical, is actually even more relatable to the human condition. Because it's about being hurt and hurting others in a way that is inseparable from any love story. And the shame that comes with all of that.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572463241/media/2019/10/OperaAtelier-DonGiovanni-DouglasWilliams-CarlaHuhtanen-ColinAinsworth-MireilleAsselin-BruceZinger_q2h41m.jpg){{% /md %}}

<figcaption>(l-r) Douglas Williams (Don Giovanni), Carla Huhtanen (Donna Elvira), Colin Ainsworth (Don Ottavio), and Meghan Lindsay (Donna Anna) in Opera Atelier's production of Don Giovanni, 2019. Photo: Bruce Zinger.</figcaption>

</figure>

For me, the surreal dinner finale where the "stone guest" comes to ask for the Don to repent his ways is like a nightmare, where all of the shame that he has had to repress his entire life in order to live exactly as he pleases arrives literally at his door, personified.

Now about that "giocoso"… For me there is always humor in seeing people act very confidently or righteously but in fact have no idea what they want. And this opera is loaded with such personalities.

## What do you know now about the singing career that you wish you knew 10 years ago?

Seems obvious, but people find it more interesting when you are yourself. It's perhaps not obvious because opera can sometimes feel like an art form where you have to slot yourself in to a certain type - especially when starting out.

> A couple times a year I do some kind of wilderness trip, even if it's just for two nights.

So as a young man I felt like I needed to achieve a certain seriousness or a certain barihunkiness. And I deprived myself and others of my wackiness, my queerness, or even acknowledging my weaknesses… all the things that make me who I am.

I try to bring it all into my identity as a singer today. No surprise that it's useful to me and more interesting to others.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572373225/media/2019/10/DouglasWilliams-JuanCamiloRoa_zhp5zj.jpg){{% /md %}}

<figcaption>Douglas Williams, baritone. Photo: Juan Camilo Roa.</figcaption>

</figure>

## If you didn't sing for a living, what would you do instead?

I have a deep response to nature. A couple times a year I do some kind of wilderness trip, even if it's just for two nights. I haven't been able to square this with singing other than to say that both can elicit a feeling of connectedness to something very, very ancient.

I'm intuitive with maps and landscapes. Maybe I would do something with this. At the moment I'm thinking of a project where I can bring singing and nature together. Probably a video. Probably somewhere in Nevada. Maybe text by Robinson Jeffers. Maybe music by me. Certainly would make sense for this age to use art to bring consciousness to this singular, miraculous planet that we inhabit.