+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-14T15:13:00+01:00"
lastmod = "2016-10-18T14:54:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476625217815/2016-10-16---David_Shipley_2_Credit_Maximilian_van_London.jpg.jpg"
primary_image_credit = "Photo: Maximilian van London."
publishDate = "2016-10-18T13:02:00+01:00"
related_articles = ["articles/talking-with-singers-gyula-nagy.md","articles/spotlight-on-jennifer-davis.md","articles/in-review-the-jpya-summer-performance-.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/david-shipley.md"]
short_description = "Shipley also sang in Tosca with Angela Gheorghiu (&quot;She was lovely.&quot;), and in Nabucco with Plácido Domingo; this season, he&#039;ll join Sondra Radvanovsky in Manon Lescaut, and Bryn Terfel in Die Meistersinger von Nürnberg. &quot;You&#039;re having a conversation with these huge figures of the opera world,&quot; says Shipley of the opportunity to work closely with top-tier singers in the industry. "
slug = "talking-with-singers-david-shipley"
title = "Talking with singers: David Shipley"
+++

David Shipley, a young bass with the [Royal Opera House](/scene/companies/royal-opera-house/)'s Jette Parker Young Artists Programme, took some time to chat between rehearsals for [*The Nose*](http://www.roh.org.uk/productions/the-nose-by-barrie-kosky), set to open at Covent Garden on October 20. Shipley is in his second season with the ROH, and he seems already a pro at balancing the busy schedule of his mainstage responsibilities, and the demands of the Young Artists Programme itself.

"Today, I've been in *The Nose* this morning, and then later on I have Italian language," he says of an average day-in-the-life during the operatic season. For the young artists, staging and musical rehearsals for the ROH season take precedence; in their spare hours, there are opportunities to learn and gain experience in all facets of stagecraft. 

Shipley takes advantage of "musical coachings, language coachings, movement, stage fighting, nearly everything," and he's well aware that "having coaching 'on tap' like that is a luxury." Members of the JPYAP have the opportunity to tailor their learning experience, by making specific coaching requests according to their needs. "You can ask for whatever," adds Shipley, who admits that it can be easy to push oneself too far. For a young artist with a major company, it can be daunting to turn down the opportunity for high-level coachings, and even more scary to admit when their workloads are too much.

"It's difficult, and I have to admit, I wasn't very good [about that]," says Shipley of his first season as a young artist. "I was very much an, 'Oh yes, I'll do that!'" With experience - and the support offered by the ROH - he has learned to be somewhat selfish about his vocal limits. "When you firstly arrive, they talk about the fact that you just have to be honest," he explains. "If you're getting to a place where you're vocally tired, you just have to hold your hands up."

"It's no use to the company if you somehow battle your way through a week's worth of rehearsals, and then because you do that you completely kill yourself and you have to miss a couple of performances." It's a balancing act that affects singers at every stage of their career, and in that sense, it's another way the JPYAP prepares its young singers for professional life. "You're worked very, very hard," says Shipley. "It's a fantastic place to be - I wouldn't change it for the world. But they do work you very hard."

Shipley has several small roles in Shostakovich's *The Nose*, translated into English by David Pountney for this production by Barrie Kosky. "I'm Clerk #3, Policeman #4, I am Speculator, and I'm Respectable Lady's Son #2," he lists, with a smile. On top of the invaluable hours spent in the rehearsal room with mainstage artists, Shipley gets the chance to practice costume changes. "There's one quick-change in this, which I think I have about 45 seconds," he laughs. "I have two dressers next to me, I'm just flinging my clothes off as quickly as I can." He admits to failing "miserably" on the first couple of tries. "I came on with my trousers halfway down my legs."

## "Acting around people like that is so easy."

Of course, mastering the quick change isn't the only benefit of sharing the stage with the mainstage artists at the Royal Opera House. Shipley began the 2015/16 season singing in *Eugene Onegin*, with Dmitri Hvorostovsky in the title role. "It was a bit overwhelming the first time, because it was my first mainstage experience," he remembers. "Dmitri has a wicked sense of humour. He's a bit of a joker."

Shipley also sang in *Tosca* with Angela Gheorghiu ("She was lovely."), and in *Nabucco* with Plácido Domingo; this season, he'll join [Sondra Radvanovsky](/scene/people/sondra-radvanovsky/) in *Manon Lescaut*, and [Bryn Terfel](/scene/people/bryn-terfel/) in *Die Meistersinger von Nürnberg*. "You're having a conversation with these huge figures of the opera world," says Shipley of the opportunity to work closely with top-tier singers in the industry. "Acting around people like that is so easy. They're so experienced, that you just feed off what they're doing."

"I got on so well with Jamie [Barton]," he says of his time in the ROH's 2016 production of *Nabucco*, where the star mezzo sang Fenena. "She is hilarious, and I think she's one of the most relaxed people I've ever seen. She's so chilled out." Shipley smiles, remembering, "Minutes before going onstage, we'd always have a bit of a giggle." Barton is an example of someone whose legacy is not yet as notable as someone like Terfel or Domingo, but she is an artist who has begun to enjoy the fruits of her own hard work; young as she still may be, Shipley learns from Barton and other artists at similar points in their career trajectory. "[Barton] is just so comfortable with what she does. I suppose that's a sign of someone with an amazing voice, good technique." 

## "I kind of fell into it."

Shipley credits his musically-inclined family for his own career choice. "I was constantly surrounded by music," he says of his upbringing. "I kind of fell into it." He pursued both singing and the French horn, before deciding to concentrate on the former. Shipley was a chorister for six years as a child, taking in stride the dramatic shift in his voice from boy treble to adult bass.

Though a career in music wasn't an odd choice for Shipley, he's very aware that success involves much more than growing up in an arts-friendly home. "One thing at college that I don't feel is talked about enough, is the competition," he says. "I thank my lucky stars because, being a young bass, the competition for me is absolutely nothing compared to nearly all the other voice types."

Even winning one of the coveted positions in the Jette Parker Young Artists Programme is no free pass to success. "There's no actual guarantee that even us, somewhere like here, that we're going to come out and we're going to have loads of work," he explains. "Often, that's just not the case."

Shipley notes that it's a generation of finding one's own way, when it comes to achieving success as an opera singer, especially when music schools are producing more singers than there are positions available for them. Being self-aware is a huge advantage for any freelancing artist, and Shipley is taking full advantage of the resources and experiences available to him during his time at the ROH. "Becoming an international opera singer is not impossible, but it's just so difficult," he admits. "I consider myself so lucky."

>The Nose opens at the Royal Opera House on Thursday, October 20. For details and ticket information, [click here.](http://www.roh.org.uk/productions/the-nose-by-barrie-kosky)
