+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2014-03-05T09:00:00-05:00"
lastmod = "2015-04-27T18:44:00-04:00"
preamble = "American tenor David Cangelosi has worked with, well, everyone. We're talking Conlon, Ozawa, Boulez, Zeffirelli, and Plácido himself, and he made his Met debut singing Wagner with James Levine. David has even graced the stage of the Four Seasons Centre here in Toronto, appearing most recently as Spoletta (_Tosca_, 2012) and Dr. Blind (_Die Fledermaus_, 2012).  [You may recall some bright green undies?](http://www.davidcangelosi.com/gallery/nggallery/photo-gallery/die-fledermaus-coc-2012/image/die-fledermaus-coc-2012-6/) David is that colleague whose enviable career easily makes him the most interesting man in the room. We couldn't wait to ask him about it."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1430174437632/CangelosiSquare.jpg.jpg"
publishDate = "2014-03-05T09:00:00-05:00"
related_articles = []
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/david-cangelosi.md"]
short_description = "American tenor David Cangelosi has worked with, well, everyone. We&#039;re talking Conlon, Ozawa, Boulez, Zeffirelli, and Plácido himself, and he made his Met debut singing Wagner with James Levine. David has even graced the stage of the Four Seasons Centre here in Toronto, appearing most recently as Spoletta (Tosca, 2012) and Dr. Blind (Die Fledermaus, 2012)."
slug = "talking-with-singers-david-cangelosi"
title = "Talking with Singers: David Cangelosi"
+++



### 1. Can you tell us what you love most about your career?

What I love most about my career can be summed up in two words: “being relevant”.  To be somewhat of a force in the most demanding artistic endeavor known to humankind is fulfilling and humbling at the same time.  James Levine, with whom I made my Metropolitan Opera debut with my signature role of _Mime,_ once said that the Met stage is a big place that requires big people, big voices, and big personalities.  To become known and respected for bringing my roles ‘to life’, whether big or small, is quite a compliment in an industry where the emphasis is often placed on the newest rising young star.  I am now a veteran of the industry, and am quite impressed when an opera company will cast their operas with as deep a bench as someone like myself, who now brings not only his own special brand of acumen to the stage, but decades of experience too.  To now be recognized as “luxury casting” in some circles is quite a thrill, but I still bring the same enthusiasm to each performance now as I did over 20 years ago in an effort to: _stay relevant_!!

### 2. What's it like to be known for singing supportive roles?</span>

This is _my_ saying:  “There are no small roles in opera…only small voices.”  While this is meant to be humorous, and has indeed garnered many laughs over the years, it remains an absolute truism.  A chain is only as strong as its weakest link; and in the ever-competitive pastiche that is opera today, it is now even more important to bring everything you have to every role.  It is employing this exact philosophy that has kept me active for over two decades.  I have, and continue to do, opera’s ‘smaller’ roles, but always make an impact.  I also sing opera’s larger(est) roles, such as the aforementioned Mime (smaller role in _Rheingold_, HUGE role in _Siegfried_), Prunier (_Rondine_), Shuisky (_Godunov_), Pedrillo (_Abduction_).  They are not title roles, but if they are not done well, it can be a long night in the opera house while waiting for the star to sing again!  If they are done excellently, one will leave a bigger impression behind than the size of the role itself.  I am opera’s ‘utility baseball player’…I play every position really well…but no one expects me to crush the baseball each time while at bat.  When I do, which is most of the time (if I can say so humbly), it leaves a real impression.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1430174563313/12-13-02-b-mc-d-3790.jpg.jpg)
<figcaption>Jan Pohl and David Cangelosi in the COC's production of Die Fledermaus, 2012. Photo by Michael Cooper</figcaption>
</figure>

### 3. Are there any unique challenges in performing character or _comprimario_ roles?

When doing the plumb cameos, character, and comprimario roles; the big challenge is the amalgamation and compression of text, music, and staging all at once.  Everything has to come together with precision because your stage time is often limited.  There is no time to “make up for it later”.  It’s all or nothing, all at one time.  Every word is important, every musical moment is important.  If you do it well, you will be respected and remembered.

### 4. How do your passions for travel and music coincide?

The passion for travel and music is so simple that one can easily overlook it… Each opera (and song for that matter) is set in a different locale worldwide, and at a different time period in history.  I sang the dual roles of Noctambulist/Pape de Fous in _Louise_ at the Spoleto Festival a few years ago_,_ and as the ‘Embodiment of Paris’, I brought so much more to these roles (even if only internally/psychologically) simply because I have spent so much time in Paris itself.  Goro (_Butterfly_), or Pang (_Turandot_) are sung and acted completely differently once one has actually spent time in Japan and China.  Instead of creating _caricatures_, one can create believable CHARACTERS.
### 5\. How do you maintain a routine while on the road?

When ‘on the road’, as I have been for decades (including 10 years as a nightclub entertainer before I began an opera career), the road _becomes_ your life. The advent of internet banking has truly simplified our lives as a matter of pragmatism. On a less practical--more personal level, however, one must like their own company…meaning you had better be comfortable with yourself, because you are going to be spending a lot of time alone and in temporary housing.  It can be lonely, frustrating, and depressing.  At the same time, it is exhilarating, exciting, and uplifting.  I ALWAYS take a tourist oriented ‘guided bus tour’ of every city I am in the first time.  I just love them!!  I walk lots of places, and stop into a few watering holes/restaurants regularly to speak with locals.  I like to get a flavor of each locale, and ‘a read’ on the people.  You’d be surprised to find how similar _and_ different each new city truly is.  It’s only after a bit of digging that one begins to discover the nuances that make each locality unique.
### 6\. Can you tell us about your longest flight?

The longest flight is either New York to Auckland, New Zealand; or Melbourne, Australia.  The craziest thing that is well documented in my worldwide travel, has been flying to Kuwait or Dubai for lunch, and then flying right back home on the night flight! This schedule always results in an extra security sweep for me at international airports…!
### 7\. How do you find the work environment and the audiences in Toronto?

I, in fact, [did a full blog](http://www.davidcangelosi.com/expectations-and-turning-points-a-coc-timeline/) (or two) at [davidcangelosi.com](http://www.davidcangelosi.com/) about my experience in Toronto. I thought it was the most interesting and forward edging company with whom I have ever been invited to sing.  The energy from the Administration is young and decidedly non-corporate; the workplace environment is friendly, eye pleasing, and comfortable; the theater is new and acoustically satisfying; the talent base is first rate on an international level; the support teams (musical staff, stage management, stage crew) are outstanding and well prepared; and the other artistic departments (wigs/makeup/wardrobe etc.) are as creative and professional as I have experienced at such august organizations as Lyric Opera of Chicago, Paris Opera, San Francisco Opera, or the Metropolitan Opera.  What’s not to like???
### 8\. Do you have any professional highlights?

_Pagliacci_ starring Domingo and televised (Washington Opera), _Rheingold_ at the Met (debut), two different outstanding _Ring_ Cycles (Chicago, San Francisco), a feature film version of _Tosca_ (Venice Film Festival), and a _Highlights from the Ring_ recording project with Placido Domingo/Covent Garden Orchestra in London, and participating in the venerable Otto Schenk and current Lepage _Ring_ at the Met, are among the most treasured of highlights.  But to also say you have sung in Carnegie Hall, and the Hollywood Bowl are ancillary delights to recall as well.  Additionally, to say that you have worked _personally_ with Domingo, Levine, Zeffirelli, Boulez, Bartoletti, Conlon, Slatkin, Runnicles, Ozawa, Menotti, Pappano, Zambello, Robert Wilson, Robert Altman, Anthony Minghella, and a plethora of other great directors, singers, and conductors, is not something that everyone can boast.  I am among the last of a generation to have had real, meaningful contact with the previous (and still current) generation of true classicists.
### 9\. Why do you think you've succeeded in striking a balance between your personal and professional lives?

There really is no such thing as “striking a balance” on this subject in my opinion.  This is actually a constant _management_ issue.  I have been lucky to be surrounded with supportive people in my life, which includes of course my recent wife.  When you are away on ‘professional assignment’, it’s hard to say that your ‘personal life’ is in balance; and for the most part Vice-Versa.  As a practical matter, it is always important to make sure that some way, some-_how_, we make a point of seeing one another after not more than 3 weeks.  Should you have a loved one, spouse, or partner; this seems to be the outside range one can be away from the other before beginning to feel disconnected.
### 10\. Do you have any roles on your "Bucket List"?

Only one role had eluded me all of these years…I would love to do the Wicked Witch (_Hansel & Gretel_).  To this end, I must say that I have really done all of the roles that I have wished to do at this point, and a few that I _never_ thought that I would have done (Tobias Ragg in _Sweeney Todd_, and Shuisky in _Boris Godunov_, to name two that specifically come to mind).   How many people in this industry can be so lucky as to say that they have been satisfied with their career arc and be so fulfilled as a result thereof?? I feel truly blessed, and am very appreciative that so many Tier 1 opera houses and symphony orchestras have put their trust in me for well over 20 years.  Truly blessed!
<div class="intro">For more about David, read his very excellent [blog](http://www.davidcangelosi.com/category/blog/), and follow him on Twitter [@DavidCangelosi](https://twitter.com/davidcangelosi).</div>
