+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-09-03T15:48:00+02:00"
lastmod = "2016-09-10T09:28:00+02:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472911088396/2016-09-03---Daniela-Mack---Simon-Pauly-Square.jpg.jpg"
primary_image_credit = "Photo by Simon Pauly."
publishDate = "2016-09-10T09:09:00+02:00"
related_articles = ["articles/talking-with-singers-marina-rebeka.md","articles/talking-with-singers-brenda-rae.md","articles/elizabeth-cree-kevin-puts.md","articles/a-stunning-premiere-elizabeth-cree.md","articles/talking-with-singers-beste-kalender.md"]
related_people = ["scene/people/daniela-mack.md"]
short_description = "&quot;One of the big motivators for me will be setting an example for her so that she will also be able to follow whatever her passion is, and to show her that that&#039;s a possibility.&quot;"
slug = "talking-with-singers-daniela-mack"
title = "Talking with singers: Daniela Mack"
+++

"It's a big year," agrees mezzo-soprano [Daniela Mack](/scene/people/daniela-mack/), about her season of major company debuts. In February 2017, Mack will make her Metropolitan Opera debut as the Kitchen Boy in *Rusalka*; for now, she's concentrating on her debut at the Royal Opera House, where she'll sing Rosina in [Moshe Leiser and Patrice Caurier's *Il barbiere di Siviglia*](http://www.roh.org.uk/productions/il-barbiere-di-siviglia-by-moshe-leiser-and-patrice-caurier), opening September 13. 

"It's surreal every time I walk into the building," says Mack of rehearsing at Covent Garden. "This place in particular has been a dream of mine for a long time." Mack will share the stage with an exciting cast, including Javier Camarena as Almaviva, Vito Priante as Figaro, and Ferruccio Furlanetto as Don Basilio.

"I can't let everything else sink in way too much," says Mack of the combination of big company and big singers. "Because at the end of the day, it is my job and I have to focus on that first." She admits that the comfort of a familiar role, and a "team of veterans" onstage with her are good things. "It gives you the freedom to really just go into the rehearsal space and just play."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472998445491/2016-09-04---Daniela-Mack---Pauly.jpg.jpg)
<figcaption>Photo by Simon Pauly.</figcaption>
</figure>

## "Her flame burns very brightly."

"I quite like her," Mack says of playing Rosina in *Il barbiere di Siviglia*. Singers who play Rossini's iconic role often have a tricky line to walk between smart and manipulative, and the audience's understanding of Rosina can vary between productions.

"She's very spirited," says Mack. "I think her flame burns very brightly."

The story of a woman, imprisoned and owned by older men, is not a new one. Yet for Mack, "I think one of the cooler things about her is that she's a forward thinker." Other women of Rosina's time may be content to accept her fate and station in life, but instead, "she's willing to do absolutely whatever it takes to remove herself from the situation."

So, when she meets Count Almaviva (or Lindoro, depending on who you ask), is it true love, or simply a ticket to freedom? 

Her Covent Garden performances will be Mack's fifth production of *Il barbiere di Siviglia*, and the question of love between Almaviva and Rosina is one with many answers. "In this production, it's not an instant, 'Oh my God, this is love at first sight!' It's more 'this is a way out.' And then she develops feelings, which I think is more realistic."

When it comes to singing the role, Mack is noticeably comfortable with the demands of the score. "Rossini has always been a really good fit for me." Singing coloratura is what came "almost immediately" for her, and "the thing that I had to work the hardest at was always legato."

Mack recalls a lightbulb moment of sorts, from her time as a finalist in the 2013 BBC Cardiff Singer of the World Competition. "The biggest thing that I walked away with from that experience was a sense of leaving everything you have on the stage when you perform." Perhaps it was because of the size and scale of the Cardiff competition, with TV cameras hovering and BBC commentators offering real-time opinions on the competing singers, but Mack says that "something clicked."

"If you can't leave all of your goods on the table then, then what's the point?" It's a feeling that she tries to repeat each time she performs; "that's when I'm most satisfied with my performance, when I feel like I didn't hold back."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472911119082/2016-09-03---Daniel-Mack---SImon-Pauly.jpg.jpg)
<figcaption>Photo by Simon Pauly.</figcaption>
</figure>

## "It's like a puzzle."

Mack often travels with her husband, tenor Alek Shrader, and their newest travel companion is her 14 month-old daughter. "It's tricky. It's like a puzzle every time you travel to a new place."

Her first stop in a new city is to track down a gym and a decent grocery store. "It's especially hard to keep a routine if we're talking about eating healthy and exercising," she says, noting that short-term travel can be even more difficult than settling into a long stretch in a new place.

How does Mack maintain a healthy routine for her and her family on the road? "I think if anything, the single most important thing that I only learned the older that I get, is really planning into my schedule a time to decompress." She remembers being "more resilient" in past years, with hurried trips to New York and back-to-back gigs. 

Now, she values the chance to stay near a park - which she does while in London - so that she can find that decompression within a hectic city, those "moments of quiet in the middle of all of this."

## "I was hooked."

Mack admitted, "I've never been asked that in such a simple way," yet she has wonderfully simple reasons why she sings.

"It's never been a question for me. I've always loved music. My parents exposed me to it very young, I saw my first opera when I was 7. I was hooked."

"It is very difficult, especially with all the travelling and all the things that you give up in order to be able to do it, like time with family and a sense of stability. But I've been in love with opera for a long time."

She had "dreams of singing in a big opera house," and pursued singing in college. While she didn't have a plan - other than to be able to keep singing - she remembers, "I never saw myself doing anything else."

The fun of singing and the love of opera are strong factors, but since the birth of her daughter, Mack's reasons for singing have grown. 

"I've been thinking a lot about this," she says, thinking ahead to the times where her work may mean she is away from her daughter for periods of time. "One of the big motivators for me will be setting an example for her so that she will also be able to follow whatever her passion is, and to show her that that's a possibility."

Like her calm, centred approach to singing one of opera's most iconic roles at an iconic opera house, we were struck by Mack's wise attitude towards what's difficult and what's fulfilling about a singing career. With all the opportunities for singers to worry about balancing time for work, family, and rest, Mack prefers to take on each job as it comes, and do it with focus.

"If you're planning for the possibility of maybe not succeeding in what you're trying to do, then you're not devoting yourself fully to the task at hand."

>*Il barbiere di Siviglia* opens at the Royal Opera House on September 13. To find out more and purchase tickets, [click here](http://www.roh.org.uk/productions/il-barbiere-di-siviglia-by-moshe-leiser-and-patrice-caurier).

