+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-09-25T19:19:00+01:00"
lastmod = "2016-10-05T09:54:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474981931070/2016-09-26---Craig-Irvin.jpg.jpg"
publishDate = "2016-10-05T09:43:00+01:00"
related_articles = ["articles/sidney-outlaw-stairs-success.md","articles/talking-with-singers-steven-cole.md","articles/spotlight-on-alexander-hajek.md","articles/kevin-puts-i-know-who-i-am-as-a-composer.md","articles/talking-with-singers-george-gagnidze.md","articles/talking-with-singers-zachary-nelson.md","articles/talking-with-singers-matthew-polenzani.md","articles/talking-with-singers-clarence-frazer.md"]
related_companies = ["scene/companies/minnesota-opera.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/craig-irvin.md"]
short_description = "Perhaps not surprisingly, Irvin learned some big truths about his singing life from being an amateur comic. &quot;If it was about the applause, I wouldn&#039;t have gotten up and done it again,&quot; he explains. &quot;It was about the performance. That&#039;s what I&#039;m drawn to most of all.&quot;"
slug = "talking-with-singers-craig-irvin"
title = "Talking with singers: Craig Irvin"
+++

"If I would have known 10 years ago, the path that would bring me here, and the struggle, I might not have done it," says American baritone [Craig Irvin](/scene/people/craig-irvin/) of his career so far. 

His fall schedule keeps him away from home for nearly three months, and Irvin, a husband and father of three, is accustomed to the conflicting feelings of excitement and dread. "There are so many wonderful things about it, but there are so many difficult things about this career," he says. "Like, being away from your spouse, your kids, your dog, not being able to sleep in your own bed."

Of course, it can also seem for singers that the universal language of the opera industry is rejection. "How many hundreds of auditions have I done that led to nothing?" asks Irvin. He has learned that it can be tough to be a singer, yet it's not tough enough to keep him away from the career. "There's a lot of stress, don't get me wrong. But the stress is worth the wonderful parts."

## "It's the most amazing opera I have ever had a chance to work on." 

After a few [concerts in Orlando](http://www.thesharon.com/event.php?id=121&title=FOUR-DIVO), Irvin heads to [Atlanta Opera](/scene/companies/atlanta-opera/) for a new production of Kevin Puts's [*Silent Night*](http://www.atlantaopera.org/calendar/view.aspx?pid=62346335), where he'll reprise his role of Lieutenant Horstmayer. Having been a part of the premiere production at Minnesota Opera, Irvin is enthusiastic about another run of the new opera that has gained impressive popularity across North America.

"It's the most amazing opera I have ever had a chance to work on," he says without hesitation. "The puzzle pieces are put together so well." He looks forward to working on the production by Tomer Zvulun in Atlanta, despite the special place he has in his heart for Eric Simonson's original staging in Minneapolis. He recalls getting "giddy" upon seeing his name in Kevin Puts's score, listed under "first cast." 

"I hadn't even thought about that fact. It hadn't even dawned on me that my name would be in the front of the book," says Irvin, calling it "amazing," that "one hundred years from now, somebody's going to open this score to perform this show, and they're going to see my name in the score."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475582842720/2016-10-04---Irvin-Silent-Night.jpg.jpg)
<figcaption>Irvin as Lt. Horstmayer in *Silent Night*, Minnesota Opera, 2012.</figcaption>
</figure>

Irvin gets excited about working with [forward-looking companies like Minnesota Opera](/michael-christie-new-opera-that-the-box-office-loves/), joking that "They're very smart at who they hire. They've hired me many times, they have wonderful taste." He returns to the company for the final set of workshops for their March 2017 premiere by William Bolcom and Mark Campbell, [*Dinner at Eight*](http://www.mnopera.org/season/2016-2017/dinner-at-eight/).

He notes that Minnesota is a company that has "done everything they can do to educate their audience to want new opera," which only bodes well for artists like Irvin. "When all the companies started closing," he says, "my first though was 'That sucks.' My second thought was, 'It will fertilize the land for new companies to come up.'"

One of those new companies is New York's [Loft Opera](https://www.loftopera.com/), where this season, Irvin will have his first crack at the title role in Verdi's *Macbeth*. "I certainly don't want to do three of them next season," he laughs of the scope of a role like Macbeth. "Big rep like that is something that I want to do, but I want to do a Pirate King in between." 

It's an unexpected advantage of working outside of the major-company circle, that Irvin has more opportunity to stretch his chops with major roles on lower-risk stages. "If I were working regularly at, say, Chicago, and the Met, San Francisco, I'd mostly be doing smaller roles, and not having those opportunities to do the major roles that I really enjoy doing," he explains, before laughing, "Of course, I could also feed my kids more, but there's a trade-off."


<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475582930575/2016-10-04---Irvin-Arabella.jpg.jpg)<figcaption>Irvin as Mandryka in *Arabella*, Minnesota Opera, 2013.</figcaption>
</figure>

## "I'm driven to perform."

"Because I have to," Irvin blurts out when we ask about his chosen career path. "It's not just the audience, and applause. I'm driven to perform." And when he's singing well? "It feels like strength."

He recalls a lull-like period in his early career, shortly after finishing his time in the Lyric Opera of Chicago's Ryan Opera Center. He was acutely aware of the lack of creative avenues, and so he began looking to open mic poetry and stand-up comedy, "Just because I had to have an outlet for artistic expression."

"Trust me, I've done some stand up sets that were not good," he says of his comic experience, which began in Los Angeles; he has since tried out his material in Toronto, Des Moines, and (hopefully) Atlanta. Perhaps not surprisingly, Irvin learned some big truths about his singing life from being an amateur comic. "If it was about the applause, I wouldn't have gotten up and done it again," he explains. "It was about the performance. That's what I'm drawn to most of all."


<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475582960197/2016-10-04---Irvin-Hansel.jpg.jpg)
<figcaption>Irvin as Peter in *Hänsel and Gretel*, Minnesota Opera, 2014.</figcaption>
</figure>

It doesn't take a long conversation with Irvin to understand that his family takes the top spot in his list of priorities, and he has found an unique perspective on the age-old dilemma of purusing a singing career, and maintaining a happy, supported family life. A *Star Trek* fan, Irvin recalls something that Patrick Stewart said in the [*The Captains*](https://en.wikipedia.org/wiki/The_Captains_(film), that his family didn't *always* come first.

Irvin likens his family and his career to food, water and oxygen, pointing out that a person needs all three to survive. "You have to stop breathing to drink, and you have to stop breathing and drinking to eat. If you don't do all of those things, you will die." For Irvin, being a great father and husband comes in part from the fulfillment he gets from performing. "What's more honest than saying, 'My family doesn't always come first,' is saying, 'I can't always put my family first, or I die.'"

>Craig Irvin joins Atlanta Opera's cast of *Silent Night*, running November 5-13. [Click here](http://www.atlantaopera.org/calendar/view.aspx?pid=62346335) for full details.
